/*
 * Decompiled with CFR 0.152.
 */
package utils.email;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import utils.email.DummySSLSocketFactory;
import utils.email.IMAPUtil;

public class CommonEmailer {
    public static Settings PROVIDER_GMAIL = new Settings("smtp.gmail.com", "465", true, true, true);
    public static Settings PROVIDER_BYTEMARK = new Settings("smtp.bytemark.co.uk", "25", false, false, false);
    public static String MIME_PLAIN_TEXT = "text/plain";
    public static String MIME_HTML = "text/html";
    IMAPUtil imapUtil = new IMAPUtil();
    Settings prov;
    String std_user;
    String std_pass;
    String std_from;
    protected int timeout = 20000;
    protected int connectiontimeout = 30000;
    protected String encoding;

    public CommonEmailer(Settings provider, String user, String pass, String from, String encoding) {
        this.prov = provider;
        this.std_user = user;
        this.std_pass = pass;
        this.std_from = from;
        this.encoding = encoding;
    }

    public void setTimeout(int time) {
        this.timeout = time;
    }

    public void setConnectionTimeout(int time) {
        this.connectiontimeout = time;
    }

    public void createDraftGmailEmail(String to, String subject, String content, String mime, File[] attachedFiles) throws Exception {
        String host = "imap.gmail.com";
        int port = 993;
        this.imapUtil.createDraftGmailEmail(this.std_user, this.std_pass, host, port, true, this.std_from, to, subject, content, attachedFiles);
    }

    public void send(String subject, String content) throws Exception {
        this.send(new String[]{this.std_from}, subject, content, MIME_PLAIN_TEXT, null);
    }

    public void send(String[] to, String subject, String content) throws Exception {
        this.send(to, subject, content, MIME_PLAIN_TEXT, null);
    }

    public void send(String[] to, String subject, String content, String mime, File[] attachedFiles) throws Exception {
        this.send(to, subject, content, mime, attachedFiles, null);
    }

    public void send(String[] to, String subject, String content, String mime, File[] attachedFiles, String[] replyTo) throws Exception {
        this.send(to, subject, content, mime, attachedFiles, replyTo, null);
    }

    public void send(String[] to, String subject, String content, String mime, File[] attachedFiles, String[] replyTo, String overrideFrom) throws Exception {
        MimeMessage msg = this.initMimeMessage(to, subject, replyTo, overrideFrom);
        if (attachedFiles == null || attachedFiles.length == 0) {
            if (this.encoding == null || this.encoding.equals("ASCII")) {
                msg.setContent((Object)content, mime);
            } else {
                msg.setContent((Object)content, mime + ";charset=" + this.encoding);
            }
        } else {
            MimeMultipart parts = new MimeMultipart();
            MimeBodyPart mainBody = new MimeBodyPart();
            if (this.encoding == null || this.encoding.equals("ASCII")) {
                mainBody.setContent((Object)content, mime);
            } else {
                mainBody.setContent((Object)content, mime + ";charset=" + this.encoding);
            }
            parts.addBodyPart((BodyPart)mainBody);
            for (int i = 0; i < attachedFiles.length; ++i) {
                MimeBodyPart attachmentBody = new MimeBodyPart();
                attachmentBody.attachFile(attachedFiles[i]);
                parts.addBodyPart((BodyPart)attachmentBody);
            }
            msg.setContent((Multipart)parts);
        }
        msg.setSentDate(new Date());
        try {
            Transport.send((Message)msg);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t.getMessage(), t.getCause());
        }
    }

    protected MimeMessage initMimeMessage(String[] to, String subject, String[] replyTo, String overrideFrom) throws MessagingException {
        try {
            Class<?> clazz = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
            Security.addProvider((Provider)clazz.newInstance());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String SMTPHOST = this.prov.SMTPHOST;
        String SMTPUSER = this.std_user;
        String SMTPPWORD = this.std_pass;
        String SMTPPORT = this.prov.SMTPPORT;
        boolean TLS = this.prov.TLS;
        boolean SSL = this.prov.SSL;
        String from = this.std_from;
        if (overrideFrom != null) {
            from = overrideFrom;
        }
        String[] recipients = to;
        Properties props = new Properties();
        this.addCustomProperties(props, this.prov.customProperties);
        props.put("mail.smtp.user", SMTPUSER);
        props.put("mail.smtp.host", SMTPHOST);
        props.put("mail.smtp.auth", "" + this.prov.AUTH);
        props.put("mail.smtps.auth", "" + this.prov.AUTH);
        props.put("mail.smtp.port", SMTPPORT);
        if (TLS) {
            props.put("mail.smtp.starttls.enable", "" + TLS);
        }
        if (SSL) {
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.smtp.socketFactory.class", DummySSLSocketFactory.class.getName());
        }
        props.put("mail.smtp.socketFactory.port", SMTPPORT);
        props.put("mail.smtp.socketFactory.fallback", "false");
        props.put("mail.smtp.connectiontimeout", "" + this.connectiontimeout);
        props.put("mail.smtp.timeout", "" + this.timeout);
        SMTPAuthenticator auth = new SMTPAuthenticator(SMTPUSER, SMTPPWORD);
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress addressFrom = new InternetAddress(from);
        msg.setFrom((Address)addressFrom);
        InternetAddress[] addressTo = new InternetAddress[recipients.length];
        for (int i = 0; i < recipients.length; ++i) {
            addressTo[i] = new InternetAddress(recipients[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        if (replyTo != null && replyTo.length > 0) {
            InternetAddress[] replyToAddresses = new InternetAddress[replyTo.length];
            for (int i = 0; i < replyTo.length; ++i) {
                replyToAddresses[i] = new InternetAddress(replyTo[i]);
            }
            msg.setReplyTo((Address[])replyToAddresses);
        }
        if (this.encoding == null || this.encoding.equals("ASCII")) {
            msg.setSubject(subject);
        } else {
            msg.setSubject(subject, this.encoding);
        }
        return msg;
    }

    protected void addCustomProperties(Properties props, Properties customProperties) {
        if (customProperties == null) {
            return;
        }
        for (String string : customProperties.keySet()) {
            String value;
            if (string == null || (value = customProperties.getProperty(string)) == null) continue;
            props.put(string, value);
        }
    }

    static class SMTPAuthenticator
    extends Authenticator {
        String SMTP_AUTH_USER;
        String SMTP_AUTH_PWD;

        public SMTPAuthenticator(String user, String pwd) {
            this.SMTP_AUTH_USER = user;
            this.SMTP_AUTH_PWD = pwd;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            String username = this.SMTP_AUTH_USER;
            String password = this.SMTP_AUTH_PWD;
            return new PasswordAuthentication(username, password);
        }
    }

    public static class Settings {
        String SMTPHOST;
        String SMTPPORT;
        boolean TLS;
        boolean AUTH;
        boolean SSL;
        public Properties customProperties = null;

        public Settings(String host, String port, boolean auth, boolean TLS, boolean SSL) {
            this.SMTPHOST = host;
            this.SMTPPORT = port;
            this.TLS = TLS;
            this.AUTH = auth;
            this.SSL = SSL;
        }

        public Settings(String host, String port, boolean auth, boolean TLS, boolean SSL, Properties customProperties) {
            this.SMTPHOST = host;
            this.SMTPPORT = port;
            this.TLS = TLS;
            this.AUTH = auth;
            this.SSL = SSL;
            this.customProperties = customProperties;
        }
    }
}

