/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.local.datalist.split;

import java.io.File;
import java.io.IOException;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.local.datalist.split.SplitTimedList;

public class SplitByteArrayList
extends SplitTimedList {
    public SplitByteArrayList(File file, long maxChunkSize) throws IOException {
        super(file, null, maxChunkSize);
    }

    public SplitByteArrayList(File file, ChunkHeader header, long maxChunkSize) throws IOException {
        super(file, null, header, maxChunkSize);
    }

    @Override
    public Class getDataClass() {
        return byte[].class;
    }

    @Override
    public void initializeByteContainer() {
        this.byteContainer = new byte[8];
    }

    @Override
    public int writeEventData(Object object) throws Exception {
        byte[] bytes = (byte[])object;
        super.growByteContainer(8 + bytes.length);
        System.arraycopy(bytes, 0, this.byteContainer, 8, bytes.length);
        return bytes.length + 8;
    }

    @Override
    public Object parseEventValue(byte[] bytes) throws Exception {
        int newLength = bytes.length - 8;
        byte[] copy = new byte[newLength];
        System.arraycopy(bytes, 8, copy, 0, newLength);
        return copy;
    }

    public byte[] getBytes(long index) {
        return (byte[])this.getValue(index);
    }

    public void addBytes(double timestamp, byte[] data) {
        this.add(timestamp, data);
    }

    public void setReadCacheMaximumSizeBytes(long size) {
        long readCacheMaxSize = size;
    }
}

