/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.local.datalist;

import java.io.File;
import java.io.IOException;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.gziplist.ChunkList;
import utils.dataservice.gziplist.IndexHelper;
import utils.dataservice.gziplist.MemoryChunk;
import utils.dataservice.gziplist.aggregator.AggregateQueryMetadata;
import utils.dataservice.gziplist.policies.CachePolicy;
import utils.dataservice.gziplist.util.TypeCoverter;
import utils.dataservice.local.ListLock;
import utils.dataservice.local.LocalDataList;

public abstract class TimedList
extends LocalDataList {
    protected ChunkList list;
    protected byte[] byteContainer;
    protected Object mostRecentValue = null;
    protected double mostRecentTime = Double.NaN;
    private byte[] listAggregatorTypes;
    private String canPath;
    static long total = 0L;
    long prevStart = 0L;
    double prevBlock = 0.0;
    int prevCount = 0;

    public TimedList(File file, byte[] aggregatorTypes) throws IOException {
        this(file, aggregatorTypes, true);
    }

    public TimedList(File file, byte[] aggregatorTypes, ChunkHeader header) throws IOException {
        this(file, aggregatorTypes, true, header);
    }

    public TimedList(File file, byte[] aggregatorTypes, boolean loadImmediately) throws IOException {
        this(file, aggregatorTypes, loadImmediately, null);
    }

    public TimedList(File file, byte[] aggregatorTypes, boolean loadImmediately, ChunkHeader header) throws IOException {
        super(file);
        this.canPath = file.getCanonicalPath();
        this.list = new ChunkList(file, aggregatorTypes, header);
        this.initializeByteContainer();
        this.list.readLastAggregate(this);
        this.listAggregatorTypes = aggregatorTypes;
        if (this.list.getSize() > 0L) {
            byte[] result = this.list.getEvent(this.list.getSize() - 1L);
            try {
                this.mostRecentValue = this.parseEventValue(result);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void setReadCachePolicy(CachePolicy policy) {
        this.list.setReadCachePolicy(policy);
    }

    public abstract void initializeByteContainer();

    public abstract int writeEventData(Object var1) throws Exception;

    public abstract Object parseEventValue(byte[] var1) throws Exception;

    public void writeHeader() throws IOException {
        this.list.writeHeader();
    }

    public File getTimedListFile() {
        return this.file;
    }

    @Override
    public long size() {
        return this.list.getSize();
    }

    public long getSizeOnDisk() {
        return this.list.getSizeOnDisk();
    }

    protected void growByteContainer(int requiredLength) {
        if (this.byteContainer.length < requiredLength) {
            byte[] newContainer = new byte[requiredLength];
            System.arraycopy(this.byteContainer, 0, newContainer, 0, this.byteContainer.length);
            this.byteContainer = newContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(double timestamp, Object object) {
        try {
            Object object2 = ListLock.INSTANCE.getListLock(this.canPath);
            synchronized (object2) {
                TypeCoverter.doubleToByte(timestamp, this.byteContainer, 0);
                int length = this.writeEventData(object);
                this.list.addAggregateEvent(timestamp, object, this.mostRecentTime, this.mostRecentValue);
                this.mostRecentValue = object;
                this.mostRecentTime = timestamp;
                this.list.addEvent(timestamp, this.byteContainer, length);
            }
        }
        catch (Exception e) {
            System.err.println("Unable to add event " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    @Override
    public double getTime(long index) {
        try {
            byte[] b = this.list.getEvent(index);
            if (b == null) {
                return Double.NaN;
            }
            return TypeCoverter.byteToDouble(b, 0);
        }
        catch (Exception e) {
            System.err.println("Unable to get event " + index + ": " + e.getMessage());
            e.printStackTrace();
            return Double.NaN;
        }
    }

    @Override
    public Object getValue(long index) {
        try {
            byte[] b = this.list.getEvent(index);
            if (b == null) {
                return null;
            }
            return this.parseEventValue(b);
        }
        catch (Exception e) {
            System.err.println("Unable to get event " + index + " - " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Double[] getTimes(long min, long max) {
        max = Math.min(max, this.size());
        min = Math.max(min, 0L);
        Double[] tmp = new Double[(int)(max - min)];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = new Double(this.getTime(min + (long)i));
        }
        return tmp;
    }

    @Override
    public Object[] getValues(long min, long max) {
        max = Math.min(max, this.size());
        min = Math.max(min, 0L);
        Object[] tmp = new Object[(int)(max - min)];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.getValue(min + (long)i);
        }
        return tmp;
    }

    @Override
    public Object getLastValue() {
        if (this.size() == 0L) {
            return null;
        }
        return this.getValue(this.size() - 1L);
    }

    @Override
    public Double getLastTime() {
        if (this.size() == 0L) {
            return null;
        }
        return new Double(this.getTime(this.size() - 1L));
    }

    @Override
    public Object getFirstValue() {
        if (this.size() == 0L) {
            return null;
        }
        return this.getValue(0L);
    }

    @Override
    public Double getFirstTime() {
        if (this.size() == 0L) {
            return null;
        }
        return new Double(this.getTime(0L));
    }

    @Override
    public void close() throws IOException {
        this.list.close();
    }

    @Override
    public void flush() throws IOException {
        this.list.flush();
    }

    @Override
    public Object[] getSpecificAggregateValues(long startEvent, long endEvent, byte[] aggType, AggregateQueryMetadata metadata) throws IOException {
        startEvent = Math.min(this.size(), Math.max(startEvent, 0L));
        endEvent = Math.min(this.size(), Math.max(endEvent, 0L));
        Object[] results = this.list.getAggregateValue(this, startEvent, endEvent, aggType, metadata);
        return results;
    }

    @Override
    public Object[] getMultipleAggregateValues(double startEvent, double blockMS, int blockCount, byte aggType) throws IOException {
        if (startEvent != (double)this.prevStart && blockMS != this.prevBlock && this.prevCount != blockCount) {
            System.out.println("New Request: getMultipleAggregateValues ... " + startEvent + ", blockMS=" + blockMS + ", count=" + blockCount);
            this.prevStart = (long)startEvent;
            this.prevBlock = blockMS;
            this.prevCount = blockCount;
        }
        byte[] agg = new byte[]{aggType};
        Object[] tmp = new Object[blockCount];
        if (this.size() != 0L) {
            Double startTime = this.getFirstTime();
            Double endTime = this.getLastTime();
            if (startTime != null && endTime != null) {
                for (int i = 0; i < tmp.length; ++i) {
                    double t;
                    double startBlock = startEvent + (double)i * blockMS;
                    double endBlock = startBlock + blockMS;
                    if (endBlock < startTime || startBlock > endTime) {
                        tmp[i] = new Double(Double.NaN);
                        continue;
                    }
                    long startIndex = this.getIndex(startBlock);
                    long endIndex = this.getIndex(endBlock, false, false);
                    boolean haveData = true;
                    if (startIndex == endIndex && ((t = this.getTime(startIndex)) < startBlock || t > endBlock)) {
                        haveData = false;
                    }
                    if (haveData) {
                        AggregateQueryMetadata queryMetadata = new AggregateQueryMetadata();
                        queryMetadata.startTime = startBlock;
                        queryMetadata.endTime = endBlock;
                        Object[] obj = this.getSpecificAggregateValues(startIndex, endIndex, agg, queryMetadata);
                        tmp[i] = obj[0];
                        continue;
                    }
                    tmp[i] = new Double(Double.NaN);
                }
            }
        }
        return tmp;
    }

    @Override
    public long getIndex(double timestamp) {
        return this.getIndex(timestamp, true, true);
    }

    @Override
    public long getIndex(double timestamp, boolean includeMatch, boolean after) {
        long chunk = this.list.getChunkForTimestamp(timestamp);
        long startIndex = 0L;
        long endIndex = 0L;
        if (chunk != -1L) {
            startIndex = IndexHelper.getChunkStartIndex(chunk);
            endIndex = Math.min(this.size(), IndexHelper.getChunkEndIndex(chunk));
        } else {
            startIndex = this.list.getMemoryChunkStart();
            endIndex = Math.min(this.list.getSize(), startIndex + (long)MemoryChunk.EVENT_COUNT);
        }
        return this.getIndexOrNearestAfter(timestamp, startIndex, endIndex - 1L, includeMatch, after);
    }

    private long getIndexOrNearestAfter(double timestamp, long startIndex, long endIndex, boolean includeMatch, boolean after) {
        if (startIndex <= endIndex) {
            long midIndex;
            double midTime;
            if (startIndex == endIndex) {
                return startIndex;
            }
            if (endIndex - startIndex <= 20L) {
                for (long i = startIndex; i <= endIndex; ++i) {
                    double time = this.getTime(i);
                    if (time == timestamp) {
                        if (includeMatch) {
                            return i;
                        }
                        if (after) {
                            return i;
                        }
                        return i - 1L;
                    }
                    if (after) {
                        if (time > timestamp) {
                            return i;
                        }
                    } else if (time > timestamp) {
                        return Math.max(startIndex, i - 1L);
                    }
                    if (i != endIndex) continue;
                    if (after) {
                        return i + 1L;
                    }
                    return i;
                }
            }
            if (timestamp < (midTime = this.getTime(midIndex = (endIndex - startIndex) / 2L + startIndex))) {
                return this.getIndexOrNearestAfter(timestamp, startIndex, midIndex, includeMatch, after);
            }
            if (timestamp > midTime) {
                return this.getIndexOrNearestAfter(timestamp, midIndex, endIndex, includeMatch, after);
            }
            return midIndex;
        }
        return startIndex;
    }

    public long debugGetCachedMemoryBytes() {
        return this.list.debugGetCachedMemoryBytes();
    }
}

