/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.local.datalist;

import java.io.File;
import java.io.IOException;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.local.datalist.TimedList;

public class StringList
extends TimedList {
    public static final String STRING_ENCODING = "UTF-8";

    public StringList(File file) throws IOException {
        super(file, null);
    }

    public StringList(File file, ChunkHeader header) throws IOException {
        super(file, null, header);
    }

    @Override
    public Class getDataClass() {
        return String.class;
    }

    @Override
    public void initializeByteContainer() {
        this.byteContainer = new byte[8];
    }

    @Override
    public int writeEventData(Object object) throws Exception {
        String s = (String)object;
        byte[] bytes = s.getBytes(STRING_ENCODING);
        int requiredLength = bytes.length + 8;
        super.growByteContainer(requiredLength);
        System.arraycopy(bytes, 0, this.byteContainer, 8, bytes.length);
        return requiredLength;
    }

    @Override
    public Object parseEventValue(byte[] bytes) throws Exception {
        return new String(bytes, 8, bytes.length - 8, STRING_ENCODING);
    }

    public String getStringValue(long index) {
        return (String)this.getValue(index);
    }

    public void addString(double timestamp, String stringValue) {
        this.add(timestamp, stringValue);
    }
}

