/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.stream;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import utils.dataservice.gziplist.PooledRAFile;

public class RandomAccessOutputStream
extends OutputStream {
    File file;

    public RandomAccessOutputStream(File file) {
        this.file = file;
    }

    @Override
    public void write(int b) throws IOException {
        PooledRAFile.write(this.file, b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        PooledRAFile.write(this.file, b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        PooledRAFile.write(this.file, b, off, len);
    }

    @Override
    public void close() throws IOException {
        PooledRAFile.close(this.file);
    }

    public long getPosition() throws IOException {
        return PooledRAFile.getFilePointer(this.file);
    }
}

