/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class SumAggregator
extends Aggregator {
    double value = Double.NaN;
    long count = 0L;
    double[][] sub_sum;

    protected SumAggregator(int chunkSpan, boolean subAggregator) {
        super((byte)0, chunkSpan, subAggregator);
        this.initSubAggregator();
        this.reset();
    }

    private void initSubAggregator() {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            this.sub_sum = new double[subLevels][];
            for (int i = 0; i < subLevels; ++i) {
                int subEventSpan = AggregateChunk.SUB_EVENT_SPAN[i];
                int bucketCount = AggregateChunk.AGGREGATE_EVENT_SPANS[0] / subEventSpan;
                this.sub_sum[i] = new double[bucketCount];
            }
        }
    }

    private void writeSubToStream(OutputStream outStream) throws IOException {
        if (this.subAggregator) {
            StreamUtils.writeLong(outStream, this.count);
            int levels = this.sub_sum.length;
            StreamUtils.writeShort(outStream, (short)levels);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.writeDoubleArray(outStream, this.sub_sum[i]);
            }
        }
    }

    private void readSubFromStream(InputStream inStream) throws IOException {
        if (this.subAggregator) {
            this.count = StreamUtils.readLong(inStream);
            int levels = StreamUtils.readShort(inStream);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.readDoubleArray(inStream, this.sub_sum[i]);
            }
        }
    }

    private void resetSubAggregator() {
        if (this.subAggregator) {
            this.count = 0L;
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                Arrays.fill(this.sub_sum[i], 0.0);
            }
        }
    }

    private void addSubAggregatorValue(Number number) {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                int bucket = (int)(this.count / (long)AggregateChunk.SUB_EVENT_SPAN[i]);
                double[] dArray = this.sub_sum[i];
                int n = bucket;
                dArray[n] = dArray[n] + number.doubleValue();
            }
            ++this.count;
        }
    }

    private void addSubAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
        for (int i = 0; i < subLevels; ++i) {
            if ((long)AggregateChunk.SUB_EVENT_SPAN[i] != eventSpan) continue;
            long subStartIndex = startIndex % (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0];
            int bucket = (int)(subStartIndex / eventSpan);
            this.value += ((SumAggregator)agg).sub_sum[i][bucket];
            this.count += eventSpan;
        }
    }

    @Override
    public Object getValue() {
        return new Double(this.value);
    }

    @Override
    public void writeToStream(OutputStream outStream) throws IOException {
        StreamUtils.writeDouble(outStream, this.value);
        this.writeSubToStream(outStream);
    }

    @Override
    public void readFromStream(InputStream inStream) throws IOException {
        this.value = StreamUtils.readDouble(inStream);
        this.readSubFromStream(inStream);
    }

    @Override
    public void reset() {
        this.value = 0.0;
        this.resetSubAggregator();
    }

    @Override
    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Double.isNaN(number.doubleValue())) {
                return;
            }
            if (Double.isNaN(this.value)) {
                this.value = 0.0;
            }
            this.addSubAggregatorValue(number);
            this.value += number.doubleValue();
        }
    }

    @Override
    public void addAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        if (eventSpan < (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0]) {
            this.addSubAggregateValue(agg, startIndex, eventSpan);
        } else {
            SumAggregator sumAgg = (SumAggregator)agg;
            if (!Double.isNaN(sumAgg.value)) {
                this.value = Double.isNaN(this.value) ? sumAgg.value : (this.value += sumAgg.value);
            }
            this.count += sumAgg.count;
        }
    }
}

