/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class MaxAggregator
extends Aggregator {
    double max = -1.7976931348623157E308;
    double[][] sub_max;
    long count = 0L;

    protected MaxAggregator(int chunkSpan, boolean subAggregator) {
        super((byte)2, chunkSpan, subAggregator);
        this.initSubAggregator();
        this.reset();
    }

    private void initSubAggregator() {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            this.sub_max = new double[subLevels][];
            for (int i = 0; i < subLevels; ++i) {
                int subEventSpan = AggregateChunk.SUB_EVENT_SPAN[i];
                int bucketCount = AggregateChunk.AGGREGATE_EVENT_SPANS[0] / subEventSpan;
                this.sub_max[i] = new double[bucketCount];
            }
        }
    }

    private void writeSubToStream(OutputStream outStream) throws IOException {
        if (this.subAggregator) {
            StreamUtils.writeLong(outStream, this.count);
            int levels = this.sub_max.length;
            StreamUtils.writeShort(outStream, (short)levels);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.writeDoubleArray(outStream, this.sub_max[i]);
            }
        }
    }

    private void readSubFromStream(InputStream inStream) throws IOException {
        if (this.subAggregator) {
            this.count = StreamUtils.readLong(inStream);
            int levels = StreamUtils.readShort(inStream);
            for (int i = 0; i < levels; ++i) {
                StreamUtils.readDoubleArray(inStream, this.sub_max[i]);
            }
        }
    }

    private void resetSubAggregator() {
        if (this.subAggregator) {
            this.count = 0L;
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                Arrays.fill(this.sub_max[i], -1.7976931348623157E308);
            }
        }
    }

    private void addSubAggregatorValue(Number number) {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                int bucket = (int)(this.count / (long)AggregateChunk.SUB_EVENT_SPAN[i]);
                this.sub_max[i][bucket] = Math.max(number.doubleValue(), this.sub_max[i][bucket]);
            }
            ++this.count;
        }
    }

    private void addSubAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
        for (int i = 0; i < subLevels; ++i) {
            if ((long)AggregateChunk.SUB_EVENT_SPAN[i] != eventSpan) continue;
            long subStartIndex = startIndex % (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0];
            int bucket = (int)(subStartIndex / eventSpan);
            this.max = Math.max(((MaxAggregator)agg).sub_max[i][bucket], this.max);
            this.count += eventSpan;
        }
    }

    @Override
    public Object getValue() {
        if (this.max == -1.7976931348623157E308) {
            return new Double(Double.NaN);
        }
        return new Double(this.max);
    }

    @Override
    public void writeToStream(OutputStream outStream) throws IOException {
        StreamUtils.writeDouble(outStream, this.max);
        this.writeSubToStream(outStream);
    }

    @Override
    public void readFromStream(InputStream inStream) throws IOException {
        this.max = StreamUtils.readDouble(inStream);
        this.readSubFromStream(inStream);
    }

    @Override
    public void reset() {
        this.max = -1.7976931348623157E308;
        this.resetSubAggregator();
    }

    @Override
    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Double.isNaN(number.doubleValue())) {
                return;
            }
            this.addSubAggregatorValue(number);
            this.max = Math.max(number.doubleValue(), this.max);
        }
    }

    @Override
    public void addAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        if (agg instanceof MaxAggregator) {
            if (eventSpan < (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0]) {
                this.addSubAggregateValue(agg, startIndex, eventSpan);
            } else {
                MaxAggregator maxAgg = (MaxAggregator)agg;
                this.max = Math.max(maxAgg.max, this.max);
            }
        }
    }
}

