/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class BooleanFalseCountAggregator
extends Aggregator {
    long count = 0L;

    protected BooleanFalseCountAggregator(int chunkSpan, boolean subAggregator) {
        super((byte)11, chunkSpan, subAggregator);
    }

    @Override
    public Object getValue() {
        return new Double(this.count);
    }

    @Override
    public void writeToStream(OutputStream outStream) throws IOException {
        StreamUtils.writeLong(outStream, this.count);
    }

    @Override
    public void readFromStream(InputStream inStream) throws IOException {
        this.count = StreamUtils.readLong(inStream);
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        Boolean bool;
        if (object instanceof Boolean && !(bool = (Boolean)object).booleanValue()) {
            ++this.count;
        }
    }

    @Override
    public void addAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        if (agg instanceof BooleanFalseCountAggregator) {
            BooleanFalseCountAggregator falseAgg = (BooleanFalseCountAggregator)agg;
            this.count += falseAgg.count;
        }
    }
}

