/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import utils.dataservice.DataList;
import utils.dataservice.gziplist.ChunkList;
import utils.dataservice.gziplist.ChunkListAPI;
import utils.dataservice.gziplist.aggregator.AggregateQueryMetadata;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.dataservice.gziplist.policies.CachePolicy;
import utils.dataservice.gziplist.util.TypeCoverter;

public class SplitChunkList
implements ChunkListAPI {
    private ArrayList<ChunkListIndexer> allLists = new ArrayList();
    private File sourceFile;
    private ChunkList lastChunkList = null;
    private ChunkListIndexer lastChunkListIndexer = null;
    private long maxSplitSize;
    private Object LIST_LOCK = new Object();
    private CachePolicy readCachePolicy;

    public SplitChunkList(ChunkList list, long maxSplitSize) throws IOException {
        this.sourceFile = list.file;
        this.lastChunkList = list;
        this.maxSplitSize = maxSplitSize;
        this.lastChunkListIndexer = new ChunkListIndexer(list, 0L, -1L);
        this.allLists.add(this.lastChunkListIndexer);
        File nextFile = SplitChunkList.iterate(this.sourceFile);
        while (nextFile.exists()) {
            this.cycleLastChunk();
            nextFile = SplitChunkList.iterate(this.sourceFile);
        }
    }

    private ChunkListIndexer getFirstChunkListIndexer() {
        if (this.allLists.size() == 0) {
            return this.lastChunkListIndexer;
        }
        return this.allLists.get(0);
    }

    @Override
    public void writeHeader() throws IOException {
        this.getFirstChunkListIndexer().list.writeHeader();
    }

    @Override
    public void addEvent(double timestamp, byte[] event, int length) throws IOException {
        this.lastChunkList.addEvent(timestamp, event, length);
        if (this.lastChunkList.memoryChunk.isEmpty() && this.lastChunkList.getSizeOnDisk() > this.maxSplitSize) {
            this.cycleLastChunk();
        }
    }

    private void cycleLastChunk() throws IOException {
        long size = this.getSize();
        this.lastChunkList.flush();
        this.lastChunkListIndexer.endEventExclusive = size;
        this.sourceFile = SplitChunkList.iterate(this.sourceFile);
        this.lastChunkList = new ChunkList(this.sourceFile, this.lastChunkList.aggregatorTypes, null);
        this.lastChunkListIndexer = new ChunkListIndexer(this.lastChunkList, size, -1L);
        if (this.readCachePolicy != null) {
            this.lastChunkList.setReadCachePolicy(this.readCachePolicy);
        }
        this.allLists.add(this.lastChunkListIndexer);
        System.out.println("[SplitChunkList] Iterated chunk file to " + this.sourceFile);
    }

    @Override
    public void addAggregateEvent(double timestamp, Object event, double previousTimestamp, Object previousValue) {
        this.lastChunkList.addAggregateEvent(timestamp, event, previousTimestamp, previousValue);
    }

    @Override
    public byte[] getEvent(long eventIndex) throws IOException {
        for (int i = 0; i < this.allLists.size(); ++i) {
            ChunkListIndexer chunkListIndex = this.allLists.get(i);
            if (!chunkListIndex.containsIndex(eventIndex)) continue;
            return chunkListIndex.list.getEvent(eventIndex - chunkListIndex.startEvent);
        }
        return null;
    }

    @Override
    public long getSize() {
        return this.lastChunkListIndexer.getLastEventIndex();
    }

    @Override
    public void flush() throws IOException {
        this.lastChunkList.flush();
    }

    @Override
    public void close() throws IOException {
        this.lastChunkList.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getAggregateValue(DataList list, long startEvent, long endEvent, byte[] aggTypes, AggregateQueryMetadata metadata) throws IOException {
        Object previousEvent = null;
        if (startEvent > 0L) {
            previousEvent = list.getValue(startEvent - 1L);
        }
        Object object = this.LIST_LOCK;
        synchronized (object) {
            int i;
            Aggregator[] aggregators = new Aggregator[aggTypes.length];
            for (i = 0; i < aggTypes.length; ++i) {
                aggregators[i] = Aggregator.getAggregator(aggTypes[i], 0, previousEvent);
            }
            if (startEvent <= endEvent) {
                this.updateAggregators(list, aggregators, startEvent, endEvent);
            }
            for (i = 0; i < aggTypes.length; ++i) {
                aggregators[i].finished(metadata);
            }
            Object[] results = new Object[aggregators.length];
            for (int j = 0; j < aggregators.length; ++j) {
                results[j] = aggregators[j].getValue();
            }
            return results;
        }
    }

    private void updateAggregators(DataList list, Aggregator[] aggregators, long startEvent, long endEvent) throws IOException {
        if (startEvent < endEvent) {
            for (ChunkListIndexer indexer : this.allLists) {
                long chunkStart = indexer.startEvent;
                long chunkEnd = indexer.getLastEventIndex();
                if (startEvent > chunkStart) {
                    chunkStart = startEvent;
                }
                boolean finished = false;
                if (endEvent <= chunkEnd) {
                    finished = true;
                    chunkEnd = endEvent;
                }
                indexer.list.updateAggregators(list, aggregators, chunkStart, endEvent);
                if (!finished) continue;
                return;
            }
        }
    }

    @Override
    public void readLastAggregate(DataList list) throws IOException {
        this.lastChunkList.readLastAggregate(list);
    }

    @Override
    public long getChunkForTimestamp(double timestamp) {
        for (ChunkListIndexer indexer : this.allLists) {
            if (!indexer.list.containsTimestamp(timestamp)) continue;
            return indexer.list.getChunkForTimestamp(timestamp);
        }
        return -1L;
    }

    @Override
    public long getMemoryChunkStart() {
        return this.lastChunkList.getMemoryChunkStart();
    }

    public static File iterate(File file) {
        String filename = file.getName();
        int lastDot = filename.lastIndexOf(46);
        String extension = "";
        int part = 1;
        if (lastDot != -1) {
            extension = filename.substring(lastDot);
            filename = filename.substring(0, lastDot);
        }
        if ((lastDot = filename.lastIndexOf(46)) != -1) {
            String partString = filename.substring(lastDot + 1);
            if (partString.startsWith("p")) {
                partString = partString.substring(1);
            }
            part = Integer.parseInt(partString) + 1;
            filename = filename.substring(0, lastDot);
        }
        return new File(file.getParentFile(), filename + ".p" + part + extension);
    }

    public static void main(String[] args) throws IOException {
        int i;
        File temp;
        File original = temp = new File("woot.tmp");
        if (temp.exists()) {
            temp.delete();
        }
        File t = temp;
        for (int i2 = 0; i2 < 20 && (t = SplitChunkList.iterate(t)).exists(); ++i2) {
            t.delete();
        }
        ChunkList list = new ChunkList(temp, new byte[0], null);
        SplitChunkList splitList = new SplitChunkList(list, 5000L);
        int size = 10000;
        byte[] tmp = new byte[8];
        for (i = 0; i < size; ++i) {
            TypeCoverter.doubleToByte(i, tmp, 0);
            splitList.addEvent(i, tmp, tmp.length);
        }
        splitList.close();
        System.out.println("WROTE " + size + " EVENTS!\n");
        list = new ChunkList(original, new byte[0], null);
        splitList = new SplitChunkList(list, 5000L);
        System.out.println("Reopened. Size = " + splitList.getSize());
        i = 0;
        while ((long)i < splitList.getSize()) {
            byte[] event;
            double d;
            System.out.println(i);
            if (i == 2400) {
                System.out.println();
            }
            if ((d = TypeCoverter.byteToDouble(event = splitList.getEvent(i))) != (double)i) {
                System.err.println("ERROR!");
            }
            ++i;
        }
    }

    @Override
    public void setReadCachePolicy(CachePolicy policy) {
        this.readCachePolicy = policy;
        for (ChunkListIndexer indexer : this.allLists) {
            if (indexer == null) continue;
            indexer.list.setReadCachePolicy(this.readCachePolicy);
        }
    }

    class ChunkListIndexer {
        File chunkListSource;
        ChunkList list;
        long startEvent;
        long endEventExclusive;

        public ChunkListIndexer(ChunkList list, long startEvent, long endEventExclusive) {
            this.list = list;
            this.chunkListSource = list.file;
            this.startEvent = startEvent;
            this.endEventExclusive = endEventExclusive;
        }

        public String toString() {
            return "ChunkListIndexer [" + this.startEvent + "->" + this.endEventExclusive + ")";
        }

        public long getLastEventIndex() {
            if (this.endEventExclusive == -1L) {
                return this.list.getSize() + this.startEvent;
            }
            return this.endEventExclusive;
        }

        public boolean containsIndex(long eventIndex) {
            long lastEventIndex = this.getLastEventIndex();
            return eventIndex < lastEventIndex && lastEventIndex >= this.startEvent;
        }
    }
}

