/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import utils.dataservice.gziplist.Chunk;
import utils.dataservice.gziplist.DiskChunk;
import utils.stream.StreamUtils;

public class MemoryChunk
extends Chunk {
    private byte[][] chunkData;
    private int shortestRecordLength = Integer.MAX_VALUE;
    private static final byte[] EMPTY = new byte[100];
    private static final boolean USE_BOUT_FOR_VARIABLE_SIZE_CHUNKS = true;

    public MemoryChunk() {
        this.chunkData = new byte[EVENT_COUNT][];
        this.recordCount = 0;
    }

    public byte[] getRecord(long eventIndex) {
        return this.chunkData[(int)(eventIndex - this.getStartIndex())];
    }

    public void addRecord(double timestamp, byte[] record, int length) {
        if (this.recordCount == 0) {
            this.startTime = timestamp;
        }
        this.endTime = timestamp;
        this.chunkData[this.recordCount] = new byte[length];
        System.arraycopy(record, 0, this.chunkData[this.recordCount], 0, length);
        ++this.recordCount;
        if (length > this.maxRecordLength) {
            this.maxRecordLength = length;
        }
        if (length < this.shortestRecordLength) {
            this.shortestRecordLength = length;
        }
    }

    public void setRecord(int index, byte[] record, int length) {
        if (this.chunkData[index] == null || this.chunkData[index].length < length) {
            this.chunkData[index] = new byte[length];
        }
        System.arraycopy(record, 0, this.chunkData[index], 0, length);
        if (length > this.maxRecordLength) {
            this.maxRecordLength = length;
        }
        if (length < this.shortestRecordLength) {
            this.shortestRecordLength = length;
        }
    }

    public boolean isFull() {
        return EVENT_COUNT == this.recordCount;
    }

    public boolean isEmpty() {
        return 0 == this.recordCount;
    }

    public void toStream(OutputStream outStream) throws IOException {
        boolean fixedSize;
        StreamUtils.writeInt(outStream, this.recordCount);
        boolean bl = fixedSize = this.maxRecordLength == this.shortestRecordLength;
        if (!fixedSize) {
            StreamUtils.writeInt(outStream, this.maxRecordLength + 4);
        } else {
            StreamUtils.writeInt(outStream, this.maxRecordLength);
        }
        if (fixedSize) {
            StreamUtils.writeBoolean(outStream, true);
        } else {
            StreamUtils.writeBoolean(outStream, false);
        }
        if (fixedSize) {
            GZIPOutputStream gzipStream = new GZIPOutputStream(outStream);
            for (int i = 0; i < this.recordCount; ++i) {
                gzipStream.write(this.chunkData[i]);
            }
            gzipStream.finish();
        } else {
            GZIPOutputStream gzipStream = new GZIPOutputStream(outStream);
            BufferedOutputStream bout = new BufferedOutputStream(gzipStream);
            for (int i = 0; i < this.recordCount; ++i) {
                int mLength = this.maxRecordLength - this.chunkData[i].length;
                StreamUtils.writeBytes(bout, this.chunkData[i]);
                int addedBytes = 0;
                while (addedBytes < mLength) {
                    if (mLength - addedBytes > 100) {
                        ((OutputStream)bout).write(EMPTY);
                        addedBytes += EMPTY.length;
                        continue;
                    }
                    ((OutputStream)bout).write(0);
                    ++addedBytes;
                }
            }
            ((OutputStream)bout).flush();
            gzipStream.finish();
        }
    }

    public void resetMemoryChunk() {
        this.recordCount = 0;
        this.maxRecordLength = 0;
        this.shortestRecordLength = Integer.MAX_VALUE;
    }

    public void loadFrom(DiskChunk chunk, long chunkIndex) {
        this.resetMemoryChunk();
        this.setChunkIndex(chunkIndex);
        long startIndex = chunk.getStartIndex();
        long recCount = chunk.getRecordCount();
        for (long i = startIndex; i < startIndex + recCount; ++i) {
            byte[] event = chunk.getEvent(i);
            this.addRecord(0.0, event, event.length);
        }
        this.startTime = chunk.getStartTime();
        this.endTime = chunk.getEndTime();
    }

    @Override
    public boolean containsEvent(long eventIndex) {
        long startIndex = this.getStartIndex();
        return eventIndex >= startIndex && eventIndex < startIndex + (long)this.recordCount;
    }
}

