/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import utils.dataservice.gziplist.Chunk;
import utils.stream.StreamUtils;

public class DiskChunk
extends Chunk {
    public byte[] payload;
    private boolean fixedSize = false;
    public int recordCount = 0;

    public static DiskChunk fromStream(InputStream inStream, long chunkIndex) throws IOException {
        DiskChunk chunk = new DiskChunk();
        chunk.recordCount = StreamUtils.readInt(inStream);
        chunk.maxRecordLength = StreamUtils.readInt(inStream);
        chunk.fixedSize = StreamUtils.readBoolean(inStream);
        chunk.payload = new byte[chunk.recordCount * chunk.maxRecordLength];
        chunk.setChunkIndex(chunkIndex);
        GZIPInputStream gZin = new GZIPInputStream(inStream);
        int lastBytesRead = 0;
        for (int bytesDone = 0; bytesDone < chunk.payload.length && lastBytesRead != -1; bytesDone += lastBytesRead) {
            lastBytesRead = gZin.read(chunk.payload, bytesDone, chunk.payload.length - bytesDone);
        }
        return chunk;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    public byte[] getEvent(long eventIndex) {
        int eventStartPosition = (int)((eventIndex - this.getStartIndex()) * (long)this.maxRecordLength);
        if (!this.fixedSize) {
            try {
                ByteArrayInputStream inStream = new ByteArrayInputStream(this.payload, eventStartPosition, this.maxRecordLength);
                byte[] source = StreamUtils.readNBytes(inStream, this.maxRecordLength * 2);
                inStream.close();
                return source;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        byte[] result = new byte[this.maxRecordLength];
        System.arraycopy(this.payload, eventStartPosition, result, 0, this.maxRecordLength);
        return result;
    }

    public long getSize() {
        return this.payload.length;
    }
}

