/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import utils.dataservice.DataList;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.Chunk;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.gziplist.ChunkListAPI;
import utils.dataservice.gziplist.DiskChunk;
import utils.dataservice.gziplist.IndexHelper;
import utils.dataservice.gziplist.MemoryChunk;
import utils.dataservice.gziplist.PooledRAFile;
import utils.dataservice.gziplist.aggregator.AggregateQueryMetadata;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.dataservice.gziplist.index.IndexElement;
import utils.dataservice.gziplist.index.IndexList;
import utils.dataservice.gziplist.policies.CachePolicy;
import utils.dataservice.gziplist.stream.RandomAccessInputStream;
import utils.dataservice.gziplist.stream.RandomAccessOutputStream;
import utils.dataservice.gziplist.util.Cache;
import utils.dataservice.gziplist.util.ClearableBufferedInputStream;

public class ChunkList
implements ChunkListAPI {
    protected long chunkFilePointer = -1L;
    protected IndexList index;
    protected MemoryChunk memoryChunk;
    protected AggregateChunk aggregateChunk;
    protected ClearableBufferedInputStream inStream;
    protected BufferedOutputStream outStream;
    protected ClearableBufferedInputStream tempInStream;
    protected BufferedOutputStream tempOutStream;
    protected File file;
    protected File tempFile;
    protected Cache readChunkCache;
    protected CachePolicy cacheSizePolicy;
    protected long readChunkCacheSizeBytes = 0L;
    private final Object LIST_LOCK = new Object();
    AggregateChunk previousChunk = null;
    long previousChunkFP = -1L;
    long startOffset = 0L;
    private boolean USE_AGGREGATE_DATA = true;
    private static final boolean DO_NOT_SAVE_IF_NO_DATA_ADDED = true;
    private boolean saveIsRequired = false;
    private ChunkHeader header;
    private boolean useAggregates;
    protected byte[] aggregatorTypes;

    public ChunkList(File file, byte[] aggregatorTypes, ChunkHeader header) throws IOException {
        this.readChunkCache = new Cache();
        this.header = header;
        this.aggregatorTypes = aggregatorTypes;
        this.useAggregates = aggregatorTypes != null && aggregatorTypes.length != 0;
        this.initChunkList(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initChunkList(File file) throws IOException {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            this.file = file;
            this.tempFile = this.getTempFile(file);
            Object object2 = this.LIST_LOCK;
            synchronized (object2) {
                this.inStream = new ClearableBufferedInputStream(new RandomAccessInputStream(file), 500);
                this.outStream = new BufferedOutputStream(new RandomAccessOutputStream(file));
                this.tempInStream = new ClearableBufferedInputStream(new RandomAccessInputStream(this.tempFile), 500);
                this.tempOutStream = new BufferedOutputStream(new RandomAccessOutputStream(this.tempFile));
                this.memoryChunk = new MemoryChunk();
                this.aggregateChunk = new AggregateChunk();
                if (this.useAggregates) {
                    this.aggregateChunk.addAggregators(this.aggregatorTypes);
                }
                this.readHeaderAndIndexList();
            }
        }
    }

    @Override
    public void setReadCachePolicy(CachePolicy policy) {
        this.cacheSizePolicy = policy;
        long bytesBeforeTrim = this.debugGetCachedMemoryBytes();
        this.trimOldReadCacheChunks();
        if (this.cacheSizePolicy != null) {
            System.out.println("[ChunkList] Trimming from " + bytesBeforeTrim + " to " + this.debugGetCachedMemoryBytes() + " (max: " + this.cacheSizePolicy.getMaximumReadCacheSizeBytes(this) + ")");
        }
    }

    public ChunkList(File file, byte[] aggregatorTypes) throws IOException {
        this(file, aggregatorTypes, null);
    }

    private File getTempFile(File file) {
        String name = file.getName();
        File parentFile = file.getParentFile();
        String tempPath = "";
        if (parentFile != null) {
            tempPath = file.getParentFile().getPath() + File.separator;
        }
        tempPath = tempPath + "." + name + ".tmp";
        return new File(tempPath);
    }

    public long getSizeOnDisk() {
        return this.file.length();
    }

    @Override
    public void writeHeader() throws IOException {
        if (this.header != null) {
            this.seekFilePointer(0L, true);
            this.header.writeHeader(this.outStream);
            this.outStream.flush();
        }
    }

    private void readHeaderAndIndexList() throws IOException {
        this.index = new IndexList(this.file, this.LIST_LOCK);
        try {
            if (PooledRAFile.length(this.file) > 0L) {
                if (this.header != null) {
                    this.seekFilePointer(0L, true);
                    this.header.readHeader(this.inStream);
                    this.startOffset = this.header.getTotalChunkHeaderSize();
                }
                System.out.println("Reading Index List of file " + this.file.getCanonicalPath());
                this.index.readIndex(this.startOffset);
                long finalChunkIndex = this.index.getChunkCount() - 1L;
                IndexElement element = this.index.fetchIndexElement(finalChunkIndex);
                if (element == null) {
                    return;
                }
                if (IndexHelper.isAggregateChunk(element.getChunkIndex())) {
                    this.chunkFilePointer = Math.max(PooledRAFile.length(this.file), this.index.getEndIndexChunkPointer());
                    this.memoryChunk.resetMemoryChunk();
                    this.memoryChunk.setChunkIndex(finalChunkIndex + 1L);
                } else {
                    DiskChunk chunk;
                    if (element.isTemporary()) {
                        System.out.println("A previous error occurred when writing the last element to the list - attempting to perform recovery from temporary backup");
                        new Exception("Reading from temporary chunk..").printStackTrace();
                        this.seekTempFilePointer(0L);
                        chunk = DiskChunk.fromStream(this.tempInStream, finalChunkIndex);
                    } else {
                        this.seekFilePointer(element.getFilePointerPosition());
                        chunk = DiskChunk.fromStream(this.inStream, finalChunkIndex);
                    }
                    int recordCount = chunk.getRecordCount();
                    if (recordCount != Chunk.EVENT_COUNT) {
                        this.memoryChunk.loadFrom(chunk, finalChunkIndex);
                        IndexElement ielem = this.index.removeLastElement();
                        this.memoryChunk.startTime = ielem.getStartTime();
                        this.memoryChunk.endTime = ielem.getEndTime();
                        this.chunkFilePointer = element.getFilePointerPosition();
                    } else if (element.isTemporary()) {
                        System.out.println("Reloading temporary chunk into memory so that it can be rewritten");
                        this.memoryChunk.loadFrom(chunk, finalChunkIndex);
                        this.index.removeLastElement();
                        this.chunkFilePointer = element.getFilePointerPosition();
                        this.cycleMemoryChunk();
                    } else {
                        this.chunkFilePointer = Math.max(PooledRAFile.length(this.file), this.index.getEndIndexChunkPointer());
                        this.memoryChunk.resetMemoryChunk();
                        this.memoryChunk.setChunkIndex(finalChunkIndex + 1L);
                    }
                }
            } else if (this.header != null) {
                this.startOffset = this.header.getTotalChunkHeaderSize();
                this.header.writeHeader(this.outStream);
                this.outStream.flush();
            }
        }
        catch (Exception e) {
            IOException ex = new IOException("Unable to read index list from file " + this.file.getName());
            ex.initCause(e);
            throw ex;
        }
    }

    protected void cycleMemoryChunk() throws IOException {
        if (this.memoryChunk.isFull()) {
            this.writeMemoryChunk(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEvent(double timestamp, byte[] event, int length) throws IOException {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            this.saveIsRequired = true;
            this.memoryChunk.addRecord(timestamp, event, length);
            this.cycleMemoryChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAggregateEvent(double timestamp, Object event, double previousTimestamp, Object previousValue) {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            this.saveIsRequired = true;
            this.aggregateChunk.addValue(timestamp, event, previousTimestamp, previousValue);
        }
    }

    private void seekFilePointer(long fp) throws IOException {
        this.seekFilePointer(fp, false);
    }

    private void seekFilePointer(long fp, boolean isHeader) throws IOException {
        this.inStream.clearBuffer();
        if (PooledRAFile.getFilePointer(this.file) != fp) {
            PooledRAFile.seek(this.file, fp);
        }
    }

    private void seekTempFilePointer(long fp) throws IOException {
        this.tempInStream.clearBuffer();
        if (PooledRAFile.getFilePointer(this.tempFile) != fp) {
            PooledRAFile.seek(this.tempFile, fp);
        }
    }

    private long getFilePointer() throws IOException {
        return PooledRAFile.getFilePointer(this.file);
    }

    private void writeMemoryChunk(boolean writeAggregate, boolean flush) throws IOException {
        boolean saveMemoryChunk = true;
        if (!this.saveIsRequired) {
            saveMemoryChunk = false;
        }
        if (saveMemoryChunk && !this.memoryChunk.isEmpty()) {
            if (this.chunkFilePointer == -1L) {
                this.chunkFilePointer = (long)IndexList.getIndexListChunkSize() + this.startOffset;
                this.index.setNextPointer(this.startOffset);
            }
            this.seekFilePointer(this.chunkFilePointer);
            this.chunkFilePointer = this.checkIndexFull(this.chunkFilePointer);
            this.seekTempFilePointer(0L);
            this.memoryChunk.toStream(this.tempOutStream);
            this.tempOutStream.flush();
            IndexElement memoryElement = new IndexElement(true, this.chunkFilePointer, this.index.getChunkCount(), this.memoryChunk.getStartTime(), this.memoryChunk.getEndTime());
            this.index.writeNextElement(memoryElement, true);
            this.seekFilePointer(this.chunkFilePointer);
            this.memoryChunk.toStream(this.outStream);
            this.outStream.flush();
            long tempFilePointer = this.getFilePointer();
            memoryElement.setIsTemporary(false);
            this.index.writeNextElement(memoryElement, flush);
            if (!flush) {
                this.chunkFilePointer = tempFilePointer;
            }
        } else {
            this.memoryChunk.setChunkIndex(this.memoryChunk.chunkIndex + 1L);
        }
        if (!flush && writeAggregate && IndexHelper.isAggregateChunk(this.index.getChunkCount())) {
            this.seekFilePointer(this.chunkFilePointer);
            this.aggregateChunk.toStream(this.outStream, this.index.getChunkCount());
            this.outStream.flush();
            IndexElement aggregateElement = new IndexElement(false, this.chunkFilePointer, this.index.getChunkCount(), this.aggregateChunk.getStartTime(), this.aggregateChunk.getEndTime());
            this.chunkFilePointer = this.getFilePointer();
            this.chunkFilePointer = this.checkIndexFull(this.chunkFilePointer);
            this.index.writeNextElement(aggregateElement, flush);
        }
        if (!flush) {
            this.memoryChunk.setChunkIndex(this.index.getChunkCount());
            this.memoryChunk.resetMemoryChunk();
        }
        this.saveIsRequired = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkIndexFull(long fp) throws IOException {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            if (this.index.isFull()) {
                this.index.setNextPointer(fp);
                return fp += (long)IndexList.getIndexListChunkSize();
            }
            return fp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEvent(long eventIndex) throws IOException {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            if (eventIndex >= this.getSize() || eventIndex < 0L) {
                return null;
            }
            if (this.memoryChunk.containsEvent(eventIndex)) {
                return this.memoryChunk.getRecord(eventIndex);
            }
            long elementIndex = this.index.lookUpIndex(eventIndex);
            IndexElement indexElement = this.index.fetchIndexElement(elementIndex);
            DiskChunk chunk = (DiskChunk)this.readChunkCache.getFromCache(indexElement);
            if (chunk == null) {
                this.seekFilePointer(indexElement.getFilePointerPosition());
                chunk = DiskChunk.fromStream(this.inStream, elementIndex);
                this.readChunkCache.addToCache(indexElement, chunk);
                this.readChunkCacheSizeBytes += chunk.getSize();
                this.trimOldReadCacheChunks();
            }
            return chunk.getEvent(eventIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimOldReadCacheChunks() {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            long readChunkCacheMaximumByteSize;
            if (this.cacheSizePolicy != null && (readChunkCacheMaximumByteSize = this.cacheSizePolicy.getMaximumReadCacheSizeBytes(this)) >= 0L) {
                if (this.cacheSizePolicy.keepAtLeastOneChunk() && this.readChunkCache.size() == 1) {
                    return;
                }
                while (this.readChunkCacheSizeBytes > readChunkCacheMaximumByteSize && this.readChunkCache.size() > 0) {
                    DiskChunk tmp = (DiskChunk)this.readChunkCache.removeFirstFromCache();
                    if (tmp == null) continue;
                    this.readChunkCacheSizeBytes -= tmp.getSize();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            if (this.memoryChunk == null) {
                return 0L;
            }
            return (long)this.memoryChunk.getRecordCount() + this.index.getTotalPersistedEventCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            if (this.memoryChunk.getRecordCount() > 0) {
                this.writeMemoryChunk(false, false);
            }
            try {
                this.index.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                PooledRAFile.close(this.file);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                PooledRAFile.close(this.tempFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.tempOutStream.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.tempInStream.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.outStream.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.inStream.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.tempFile.delete();
            this.index = null;
            this.file = null;
            this.tempFile = null;
            this.tempOutStream = null;
            this.tempInStream = null;
            this.outStream = null;
            this.inStream = null;
            this.chunkFilePointer = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            if (this.memoryChunk.getRecordCount() > 0) {
                this.writeMemoryChunk(false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getAggregateValue(DataList list, long startEvent, long endEvent, byte[] aggTypes, AggregateQueryMetadata metadata) throws IOException {
        Object previousEvent = null;
        if (startEvent > 0L) {
            previousEvent = list.getValue(startEvent - 1L);
        }
        Object object = this.LIST_LOCK;
        synchronized (object) {
            int i;
            Aggregator[] aggregators = new Aggregator[aggTypes.length];
            for (i = 0; i < aggTypes.length; ++i) {
                aggregators[i] = Aggregator.getAggregator(aggTypes[i], 0, previousEvent);
            }
            if (startEvent <= endEvent) {
                this.updateAggregators(list, aggregators, startEvent, endEvent);
            }
            for (i = 0; i < aggTypes.length; ++i) {
                aggregators[i].finished(metadata);
            }
            Object[] results = new Object[aggregators.length];
            for (int j = 0; j < aggregators.length; ++j) {
                results[j] = aggregators[j].getValue();
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAggregators(DataList list, Aggregator[] aggregators, long startEvent, long endEvent) throws IOException {
        Object previousObject = null;
        double previousTime = Double.NaN;
        while (startEvent <= endEvent) {
            long startChunk = this.index.lookUpIndex(startEvent);
            IndexElement aggregateElement = null;
            long aggSpan = 0L;
            long nextAggregateChunk = 0L;
            long eventSpan = 0L;
            boolean found = false;
            long endAggEvent = 0L;
            if (this.USE_AGGREGATE_DATA) {
                for (int i = AggregateChunk.AGGREGATE_CHUNK_SPANS.length - 1; i >= 0 && !found; --i) {
                    aggSpan = AggregateChunk.AGGREGATE_CHUNK_SPANS[i];
                    eventSpan = AggregateChunk.AGGREGATE_EVENT_SPANS[i];
                    nextAggregateChunk = IndexHelper.getNextAggregateChunk(startChunk, aggSpan);
                    aggregateElement = this.index.fetchIndexElement(nextAggregateChunk);
                    if (aggregateElement == null) continue;
                    long startAggEvent = IndexHelper.getAggregateStartIndex(nextAggregateChunk, eventSpan);
                    endAggEvent = IndexHelper.getAggregateEndIndex(nextAggregateChunk);
                    if (startEvent == startAggEvent && endAggEvent < endEvent) {
                        found = true;
                        continue;
                    }
                    if (found || i != 0) continue;
                    int levels = AggregateChunk.SUB_EVENT_SPAN.length;
                    for (int j = levels - 1; j >= 0 && !found; --j) {
                        eventSpan = AggregateChunk.SUB_EVENT_SPAN[j];
                        if (startEvent % eventSpan != 0L || (endAggEvent = startEvent + eventSpan) >= endEvent) continue;
                        found = true;
                    }
                }
            }
            if (found) {
                long seekFP = aggregateElement.getFilePointerPosition();
                if (this.previousChunk == null || seekFP != this.previousChunkFP) {
                    this.seekFilePointer(seekFP);
                    this.previousChunkFP = seekFP;
                    Object object = this.LIST_LOCK;
                    synchronized (object) {
                        this.previousChunk = AggregateChunk.fromStream(this.inStream);
                    }
                }
                for (int j = 0; j < aggregators.length; ++j) {
                    Aggregator agg = aggregators[j];
                    byte type = agg.getAggregatorType();
                    Aggregator chunkAggregator = this.previousChunk.getAggregator(type, (int)aggSpan);
                    aggregators[j].addAggregateValue(chunkAggregator, startEvent, eventSpan);
                }
                startEvent = endAggEvent;
            }
            if (found) continue;
            double time = list.getTime(startEvent);
            Object val = list.getValue(startEvent);
            if (previousObject == null && startEvent > 0L) {
                previousTime = list.getTime(startEvent - 1L);
                previousObject = list.getValue(startEvent - 1L);
            }
            for (int j = 0; j < aggregators.length; ++j) {
                aggregators[j].addValue(time, val, previousTime, previousObject);
            }
            previousTime = time;
            previousObject = val;
            ++startEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readLastAggregate(DataList list) throws IOException {
        if (!this.useAggregates) {
            return;
        }
        Object object = this.LIST_LOCK;
        synchronized (object) {
            System.out.println("Reading aggregates from list (list size = " + this.getSize() + ")");
            int[] spans = AggregateChunk.AGGREGATE_CHUNK_SPANS;
            for (int i = spans.length - 1; i >= 0; --i) {
                ArrayList<Aggregator> listAggregators;
                long endIndex;
                long previousChunk = IndexHelper.getPreviousAggregateChunk(this.index.getChunkCount(), spans[i]);
                long startIndex = IndexHelper.getChunkStartIndex(previousChunk + 1L);
                if (startIndex == (endIndex = list.size()) || (listAggregators = this.aggregateChunk.getAggregators(spans[i])).size() > 0) continue;
                Aggregator[] aggs = new Aggregator[listAggregators.size()];
                listAggregators.toArray(aggs);
                this.updateAggregators(list, aggs, startIndex, endIndex);
            }
            if (IndexHelper.isAggregateChunk(this.index.getChunkCount())) {
                this.writeMemoryChunk(true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getChunkForTimestamp(double timestamp) {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            if (this.memoryChunk.getRecordCount() != 0 && timestamp >= this.memoryChunk.getStartTime()) {
                return -1L;
            }
            long ret = this.index.getChunkForTimestamp(timestamp);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMemoryChunkStart() {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            return this.memoryChunk.getStartIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTimestamp(double timestamp) {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            double start = this.index.getStartTime();
            double end = this.memoryChunk.getEndTime();
            if (end == -1.0) {
                end = this.index.getLastElementEndTime();
            }
            return start <= timestamp && end >= timestamp;
        }
    }

    public long debugGetCachedMemoryBytes() {
        Object[] o = this.readChunkCache.getAllCacheObjects();
        long total = 0L;
        for (Object oo : o) {
            DiskChunk d = (DiskChunk)oo;
            total += (long)d.payload.length;
        }
        return total;
    }
}

