/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import jwrapper.updater.GenericUpdater;

public class VersionUtil {
    public static long GRANULARITY_MS = 4000L;

    public static void main(String[] args) {
        long ver = Long.parseLong("00039593564");
        long tim = VersionUtil.getTimeForVersion(ver);
        System.out.println(ver + " = " + new Date(tim));
    }

    public static long getTimeForVersion(long ver) {
        ver = 4000L * (322000000L + ver);
        return ver;
    }

    public static int getVersionForNow() {
        int ver = (int)(System.currentTimeMillis() / 4000L - 322000000L);
        return ver;
    }

    public static String padVersion(int version) {
        String ver = "" + version;
        while (ver.length() < 11) {
            ver = "0" + ver;
        }
        return ver;
    }

    public static void writeAppVersionFile(File dir, String app, int version) throws IOException {
        VersionUtil.writeAppVersionFile(dir, app, VersionUtil.padVersion(version));
    }

    public static void writeAppVersionFile(File dir, String app, String version) throws IOException {
        File ver = new File(dir, GenericUpdater.getVersionFileNameFor(app));
        FileOutputStream fout = new FileOutputStream(ver);
        fout.write(version.getBytes("ASCII"));
        fout.close();
    }

    public static void deleteAppVersionFile(File dir, String app) throws IOException {
        File ver = new File(dir, GenericUpdater.getVersionFileNameFor(app));
        ver.delete();
    }
}

