/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.wmi;

import java.util.ArrayList;
import java.util.Properties;
import utils.osstats.winutils.WMIResults;

public class JWWmiQueryResult
implements WMIResults {
    private ArrayList<String> propertyNames = new ArrayList();
    private ArrayList<Properties> results = new ArrayList();
    private Properties lastResult;

    public void addPropertyValue(String name, String value) {
        this.lastResult.setProperty(name, value);
    }

    public void newResult() {
        this.lastResult = new Properties();
        this.results.add(this.lastResult);
    }

    public void addPropertyName(String propertyName) {
        this.propertyNames.add(propertyName);
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        int[] columnWidths = new int[this.propertyNames.size()];
        for (int i2 = 0; i2 < this.propertyNames.size(); ++i2) {
            columnWidths[i2] = this.propertyNames.get(i2).length();
        }
        for (Properties props : this.results) {
            for (i = 0; i < this.propertyNames.size(); ++i) {
                String value = props.getProperty(this.propertyNames.get(i));
                if (value == null) continue;
                columnWidths[i] = Math.max(columnWidths[i], value.length());
            }
        }
        for (int i3 = 0; i3 < this.propertyNames.size(); ++i3) {
            String propertyName = this.propertyNames.get(i3);
            int length = propertyName.length();
            int max = columnWidths[i3];
            builder.append(propertyName);
            for (int ii = length; ii < max; ++ii) {
                builder.append(" ");
            }
        }
        builder.append("\n");
        for (Properties props : this.results) {
            for (i = 0; i < this.propertyNames.size(); ++i) {
                String value = props.getProperty(this.propertyNames.get(i));
                if (value == null) {
                    value = "";
                }
                int length = value.length();
                int max = columnWidths[i];
                builder.append(value);
                for (int ii = length; ii < max; ++ii) {
                    builder.append(" ");
                }
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public String[] getPropertyNames() {
        return this.propertyNames.toArray(new String[0]);
    }

    public Properties[] getProperties() {
        return this.results.toArray(new Properties[0]);
    }

    public boolean hasProperties() {
        return this.results != null && this.results.size() > 0;
    }
}

