/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.service;

import com.simplehelp.linux.LinuxServiceManager;
import com.simplehelp.macos.MacOSServiceManager;
import com.simplehelp.windows.WindowsServiceManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWApp;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.mappedfile.MFMessageHandler;
import utils.message.mappedfile.MessageHandler;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.stream.MappedChannel;

public class ManageService
implements MessageHandler {
    public static final int COMMAND_COMPLETE = 655361;
    public static final int COMMAND_ERROR = 655362;
    public static String PROPERTY_SERVICE_NAME = "ServiceName";
    public static String PROPERTY_SERVICE_PID = "ServicePid";
    public static String PROPERTY_SERVICE_NEEDS_UI = "ServiceNeedsUI";
    public static String PROPERTY_START_LAUNCHER_PATH = "ServiceStartLauncherPath";
    public static String PROPERTY_STOP_LAUNCHER_PATH = "ServiceStopLauncherPath";
    public static String PROPERTY_SERVICE_DIR = "ServiceTargetDir";
    public static String PROPERTY_ACTION = "ServiceAction";
    public static String PROPERTY_CHANNEL_SERVER = "ServiceChannelServer";
    public static String PROPERTY_CHANNEL_CLIENT = "ServiceChannelClient";
    public static String PROPERTY_POSTINSTALL_MAIN = "ServicePostInstallMain";
    public static String VALUE_ACTION_INSTALL = "ServiceInstall";
    public static String VALUE_ACTION_REINSTALL = "ServiceReinstall";
    public static String VALUE_ACTION_REMOVE = "ServiceRemove";
    private MFMessageHandler messenger = null;

    private void println(String s) {
        if (this.messenger != null) {
            this.messenger.println(s);
        } else {
            System.out.println(s);
        }
    }

    private void printStackTrace(Throwable t) {
        if (this.messenger != null) {
            this.messenger.printStackTrace(t);
        } else {
            t.printStackTrace();
        }
    }

    public ManageService() {
        String server = JWSystem.getAppLaunchProperty(PROPERTY_CHANNEL_SERVER);
        String client = JWSystem.getAppLaunchProperty(PROPERTY_CHANNEL_CLIENT);
        if (server.length() == 0 && client.length() == 0) {
            System.out.println("[ManageService] Initialised with no communication");
        } else {
            File serverFile = new File(server);
            File clientFile = new File(client);
            System.out.println("[ManageService] ServerFile = " + serverFile.getAbsolutePath() + " (exists = " + serverFile.exists() + ")");
            System.out.println("[ManageService] ClientFile = " + clientFile.getAbsolutePath() + " (exists = " + clientFile.exists() + ")");
            try {
                System.out.println("[ManageService] Initialising communication channel as client");
                MappedChannel mappedFile = MappedChannel.openAsClient(serverFile, clientFile, 30000L);
                System.out.println("[ManageService] Initialising message handler");
                this.messenger = new MFMessageHandler(mappedFile, this);
            }
            catch (Throwable t) {
                System.out.println("[ManageService] messenger failed:");
                t.printStackTrace();
            }
        }
        this.println("[ManageService] Starting up service manager");
        String action = JWSystem.getAppLaunchProperty(PROPERTY_ACTION);
        this.println("[ManageService] Action is '" + action + "'. Processing...");
        if (action == null) {
            this.println("[ManageService] No action specified. Returning.");
            return;
        }
        if (action.equals(VALUE_ACTION_INSTALL) || action.equals(VALUE_ACTION_REINSTALL)) {
            if (action.equals(VALUE_ACTION_REINSTALL)) {
                try {
                    this.removeService();
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
            }
            String needsUIString = JWSystem.getAppLaunchProperty(PROPERTY_SERVICE_NEEDS_UI);
            boolean needsUI = false;
            if (needsUIString != null) {
                needsUI = Boolean.parseBoolean(needsUIString);
            }
            this.println("[ManageService] Service needsUI is " + needsUI);
            this.installService(needsUI);
        } else if (action.equals(VALUE_ACTION_REMOVE)) {
            this.removeService();
        }
        this.println("[ManageService] Checking for elevated postinstall class");
        String postinstall = JWSystem.getAppLaunchProperty(PROPERTY_POSTINSTALL_MAIN);
        if (postinstall == null) {
            this.println("[ManageService] No postinstall class specified.");
        } else {
            try {
                this.println("[ManageService] Loading postinstall class " + postinstall);
                Class<?> clazz = Class.forName(postinstall);
                Method main = clazz.getDeclaredMethod("main", String[].class);
                this.println("[ManageService] Invoking postinstall class " + postinstall);
                main.invoke(null, new Object[]{new String[0]});
                this.println("[ManageService] Postinstall class done");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.println("[ManageService] Finished. Sending complete notification.");
        this.messenger.sendMessage(new Message(655361));
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new ManageService();
        System.exit(0);
    }

    public static File getSimpleServiceExe() {
        File master = JWSystem.getAppFolder().getParentFile();
        File shared = JWApp.getJWAppsFolder(master);
        File targetFile = new File(shared, "SimpleService.exe");
        File simpleServiceFile = GenericUpdater.getSimpleServiceExe(master);
        try {
            FileUtil.copy(simpleServiceFile, targetFile);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return targetFile;
    }

    private static String getShortName() {
        String serviceName = JWSystem.getAppLaunchProperty(PROPERTY_SERVICE_NAME);
        return serviceName.replace(" ", "").toLowerCase();
    }

    private static String getDotName() {
        String serviceName = JWSystem.getAppLaunchProperty(PROPERTY_SERVICE_NAME);
        return serviceName.replace(" ", ".").toLowerCase();
    }

    private static String getFullName() {
        return JWSystem.getAppLaunchProperty(PROPERTY_SERVICE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeService() {
        block13: {
            this.println("[ManageService] Removing service");
            String serviceDir = JWSystem.getAppLaunchProperty(PROPERTY_SERVICE_DIR);
            try {
                if (OS.isWindows()) {
                    File dotServiceFile = new File(serviceDir, ManageService.getShortName() + ".service");
                    File simpleServiceFile = ManageService.getSimpleServiceExe();
                    WindowsServiceManager manager = new WindowsServiceManager(simpleServiceFile);
                    manager.removeService(dotServiceFile);
                    dotServiceFile.delete();
                    break block13;
                }
                if (OS.isMacOS()) {
                    try {
                        MacOSServiceManager.unloadAgent(ManageService.getDotName(), System.out);
                        break block13;
                    }
                    finally {
                        MacOSServiceManager.removeAgent(ManageService.getDotName(), System.out);
                    }
                }
                LinuxServiceManager manager = new LinuxServiceManager("2 3 4 5", "0 1 6", "99", "0");
                try {
                    manager.stop(ManageService.getShortName());
                }
                finally {
                    manager.remove(ManageService.getShortName());
                }
            }
            catch (Throwable t) {
                this.printStackTrace(t);
            }
        }
        try {
            String pid = JWSystem.getAppLaunchProperty(PROPERTY_SERVICE_PID);
            if (!OS.isWindows()) {
                System.out.println("[ManageService] Service pid is " + pid);
                System.out.println("[ManageService] Attempting to terminate process...");
                System.out.println("[ManageService] Did terminate complete? " + JWGenericOS.terminateProcess(Integer.parseInt(pid)));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static File getLivenessFile() {
        File livenessFile = new File(JWApp.getJWAppsFolder(JWSystem.getAppFolder().getParentFile()), "servicealive");
        if (!livenessFile.exists()) {
            try {
                livenessFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return livenessFile;
    }

    private void installService(boolean needsUI) {
        try {
            this.println("[ManageService] Installing service");
            String starterPath = JWSystem.getAppLaunchProperty(PROPERTY_START_LAUNCHER_PATH);
            String stopperPath = JWSystem.getAppLaunchProperty(PROPERTY_STOP_LAUNCHER_PATH);
            String serviceDir = JWSystem.getAppLaunchProperty(PROPERTY_SERVICE_DIR);
            ManageService.installService(starterPath, stopperPath, serviceDir, null, needsUI);
        }
        catch (Throwable t) {
            this.printStackTrace(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uninstallService(String serviceDir) throws Exception {
        if (OS.isWindows()) {
            File dotServiceFile = new File(serviceDir, ManageService.getShortName() + ".service");
            File simpleServiceFile = ManageService.getSimpleServiceExe();
            WindowsServiceManager manager = new WindowsServiceManager(simpleServiceFile);
            manager.removeService(dotServiceFile);
        } else if (OS.isMacOS()) {
            File master = JWSystem.getAppFolder().getParentFile();
            RunCommandGetOutput.runCommandGetOutput(new String[]{"chmod", "-R", "777", master.getCanonicalPath()});
            try {
                MacOSServiceManager.removeAgent(ManageService.getDotName(), System.out);
            }
            finally {
                MacOSServiceManager.removeDaemon(ManageService.getDotName(), System.out);
            }
        } else {
            LinuxServiceManager manager = new LinuxServiceManager("2 3 4 5", "0 1 6", "99", "0");
            manager.stop(ManageService.getShortName());
            manager.remove(ManageService.getShortName());
        }
    }

    private static void installService(String launcherPath, String stopPath, String serviceDir, File livenessFile, boolean needsUI) throws Exception {
        if (OS.isWindows()) {
            File dotServiceFile = new File(serviceDir, ManageService.getShortName() + ".service");
            File simpleServiceFile = ManageService.getSimpleServiceExe();
            WindowsServiceManager manager = new WindowsServiceManager(simpleServiceFile);
            manager.writeDotServiceFile(dotServiceFile, ManageService.getShortName(), ManageService.getFullName(), new File(serviceDir), launcherPath, new File(serviceDir), stopPath, false, false, livenessFile);
            try {
                System.out.println("[ManageService] Removing any existing Windows service");
                manager.removeService(dotServiceFile);
                System.out.println("[ManageService] Done removing any existing Windows service");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("[ManageService] Installing Windows service");
            manager.installService(dotServiceFile);
            System.out.println("[ManageService] Done installing Windows service");
        } else if (OS.isMacOS()) {
            System.out.println("[ManageService] Installing OSX agent");
            if (needsUI) {
                MacOSServiceManager.installAgent(ManageService.getDotName(), new String[]{"open", "-W", "-a", launcherPath}, new File(serviceDir), new String[]{"Aqua", "LoginWindow"}, System.out, false);
                System.out.println("[ManageService] Loading OSX agent");
                MacOSServiceManager.loadAgent(ManageService.getDotName(), System.out);
                System.out.println("[ManageService] Loaded OSX agent");
            } else {
                MacOSServiceManager.installDaemon(ManageService.getDotName(), new String[]{"open", "-W", "-a", launcherPath}, new File(serviceDir), null, System.out);
                System.out.println("[ManageService] Loading OSX daemon");
                MacOSServiceManager.loadDaemon(ManageService.getDotName(), System.out);
                System.out.println("[ManageService] Loaded OSX daemon");
            }
        } else {
            File waitForXLauncherScript;
            try {
                waitForXLauncherScript = needsUI ? ManageService.createWaitForXScript(serviceDir, launcherPath) : ManageService.createLaunchScriptWithoutWaitForX(serviceDir, launcherPath);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                waitForXLauncherScript = new File(launcherPath);
            }
            System.out.println("[ManageService] Installing Linux service");
            LinuxServiceManager manager = new LinuxServiceManager("2 3 4 5", "0 1 6", "99", "0");
            manager.installAndStart(ManageService.getShortName(), ManageService.getShortName(), "\"" + waitForXLauncherScript.getAbsolutePath() + "\"", null, "\"" + serviceDir + "\"", false);
            System.out.println("[ManageService] Installed Linux service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createWaitForXScript(String serviceDir, String startExec) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("#!/bin/bash\n");
        buffer.append("##############\n");
        buffer.append("# Pick up the X server pid, and sleep if it not up yet\n");
        buffer.append("##############\n");
        buffer.append("\n");
        buffer.append("oldXPid=\"-1\"\n");
        buffer.append("newXPid=\"\"\n");
        buffer.append("\n");
        buffer.append("getXPid()\n");
        buffer.append("{\n");
        buffer.append("\tXPid=` `\n");
        buffer.append("\tcounter=0\n");
        buffer.append("\twhile [  -z \"$XPid\" ]\n");
        buffer.append("\tdo \n");
        buffer.append("\t\tXPid=`ps ww -C X,Xorg | grep auth | awk '{ print $1 }'`\n");
        buffer.append("\t\t\n");
        buffer.append("\t\t##############\n");
        buffer.append("\t\t# Timeout after 3 minutes\n");
        buffer.append("\t\t##############\n");
        buffer.append("\t\tcounter=$(( $counter + 1 ))\n");
        buffer.append("\t\tif [ \"$counter\" -eq 180 ]\n");
        buffer.append("\t\tthen\n");
        buffer.append("\t\t\tbreak\n");
        buffer.append("\t\tfi\n");
        buffer.append("\t\tsleep 1\n");
        buffer.append("\tdone\n");
        buffer.append("\tsleep 1\n");
        buffer.append("\techo $XPid\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("getXAuthority()\n");
        buffer.append("{\n");
        buffer.append("\t##############\n");
        buffer.append("\t# Pickup the auth magic cookie from a ps scan\n");
        buffer.append("\t##############\n");
        buffer.append("\txauthority=`ps ww -C X,Xorg -o args= --sort=-stime | grep -m 1 -o '\\B[-]auth\\s*/\\S*' |  cut -d ' ' -f 2`\n");
        buffer.append("\techo $xauthority\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("getDisplay()\n");
        buffer.append("{\n");
        buffer.append("\tdisplay=`ps ww -C X,Xorg -o args= --sort=-stime | grep -m 1 '\\B[-]auth\\s*/\\S*' | grep -o '\\B[:][0-9]*' | head -n 1`\n");
        buffer.append("\techo $display\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("while [ 1 ]\n");
        buffer.append("do\n");
        buffer.append("\tnewXPid=`getXPid`\n");
        buffer.append("\t\t\t\n");
        buffer.append("\texport XAUTHORITY=`getXAuthority`\n");
        buffer.append("\tif [ \"A$newXPid\" = \"A$oldXPid\" ]\n");
        buffer.append("\tthen\n");
        buffer.append("\t\techo \"Sleeping '$newXPid' '$oldXPid'\"\n");
        buffer.append("\t\tsleep 5\n");
        buffer.append("\telse\n");
        buffer.append("\t\toldXPid=$newXPid\n");
        buffer.append("\t\t\t\t\n");
        buffer.append("\t\techo \"Detected XAuthority as $XAUTHORITY\"\n");
        buffer.append("\t\t\n");
        buffer.append("\t\t##############\n");
        buffer.append("\t\t# Export to connect to correct display\n");
        buffer.append("\t\t##############\n");
        buffer.append("\t\texport DISPLAY=`getDisplay`\n");
        buffer.append("\t\t\t\t\n");
        buffer.append("\t\t\"" + startExec + "\"\n");
        buffer.append("\tfi\n");
        buffer.append("done\n");
        File serviceDirectory = new File(serviceDir);
        File launcherFile = new File(serviceDirectory, "service_launch.sh");
        FileOutputStream fout = new FileOutputStream(launcherFile);
        try {
            fout.write(buffer.toString().getBytes("ISO-8859-1"));
        }
        finally {
            fout.close();
        }
        JWGenericOS.setReadableForAllUsers(launcherFile, false);
        return launcherFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createLaunchScriptWithoutWaitForX(String serviceDir, String startExec) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("#/bin/sh\n");
        buffer.append("\n");
        buffer.append("\"" + startExec + "\"");
        buffer.append("\n");
        File serviceDirectory = new File(serviceDir);
        File launcherFile = new File(serviceDirectory, "service_launch.sh");
        FileOutputStream fout = new FileOutputStream(launcherFile);
        try {
            fout.write(buffer.toString().getBytes("ISO-8859-1"));
        }
        finally {
            fout.close();
        }
        JWGenericOS.setReadableForAllUsers(launcherFile, false);
        return launcherFile;
    }

    public void handleMessage(Message bytesToMessage) {
    }

    public void closed() {
        if (this.messenger != null) {
            this.messenger.close();
        }
        this.messenger = null;
    }
}

