/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.network;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.URL;
import java.util.ArrayList;
import jwrapper.jwutils.network.JWSocketsListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWSockets {
    private Object LOCK = new Object();
    private ArrayList<JWSocketsListener> listeners = new ArrayList();
    private SockStats stats = new SockStats();
    private NotifyThread notify;
    private ArrayList<JWSockImpl> tracking = new ArrayList();
    private boolean printAll = false;
    static JWSockets INSTANCE = null;

    public void printAllSocketActivity(boolean print) {
        this.printAll = print;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JWSocketsListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JWSocketsListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    public ArrayList<Socket> getLiveSockets() {
        return this.stats.getLiveSockets();
    }

    public ArrayList<Socket> getClosedSockets() {
        return this.stats.getClosedSockets();
    }

    public void clearLiveSockets() {
        this.stats.clearLiveSockets();
    }

    public void clearClosedSockets() {
        this.stats.clearClosedSockets();
    }

    public void retainLiveSockets(boolean keep) {
        this.stats.retainLiveSockets(keep);
    }

    public void retainClosedSockets(boolean keep) {
        this.stats.retainClosedSockets(keep);
    }

    public int getLiveSocketCount() {
        return this.stats.getLiveSocketCount();
    }

    public int getOpenedSocketCount() {
        return this.stats.getOpenedSocketCount();
    }

    public int getClosedSocketCount() {
        return this.stats.getClosedSocketCount();
    }

    private JWSockets() throws Exception {
        Field field = Socket.class.getDeclaredField("factory");
        field.setAccessible(true);
        Socket sock = new Socket();
        sock.close();
        JWSockImplFactory jws = new JWSockImplFactory();
        field.set(null, jws);
        this.addListener(this.stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNotifyIfNecessary() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.notify == null) {
                this.notify = new NotifyThread();
                this.notify.start();
            }
        }
    }

    public static JWSockets interceptSockets() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new JWSockets();
        }
        return INSTANCE;
    }

    public static void main(String[] args) throws Exception {
        JWSockets socks = JWSockets.interceptSockets();
        socks.retainLiveSockets(true);
        socks.retainClosedSockets(true);
        socks.printAllSocketActivity(true);
        URL url = new URL("http://google.com");
        url.openStream();
        url = new URL("http://myhttp.info");
        url.openStream();
        Thread.sleep(500L);
        System.out.println("[JWSockets] " + socks.getLiveSocketCount() + " live sockets");
        ArrayList<Socket> list = socks.getLiveSockets();
        for (Socket sock : list) {
            System.out.println("[JWSockets] Open: " + sock);
        }
        list = socks.getClosedSockets();
        for (Socket sock : list) {
            System.out.println("[JWSockets] Closed: " + sock);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SockStats
    implements JWSocketsListener {
        int socksOpened = 0;
        int socksClosed = 0;
        ArrayList<Socket> live = new ArrayList();
        ArrayList<Socket> closed = new ArrayList();
        boolean keepLive = false;
        boolean keepClosed = false;

        SockStats() {
        }

        public void retainLiveSockets(boolean b) {
            this.keepLive = b;
            if (!b) {
                this.clearLiveSockets();
            }
        }

        public void retainClosedSockets(boolean b) {
            this.keepClosed = b;
            if (!b) {
                this.clearClosedSockets();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearLiveSockets() {
            Object object = JWSockets.this.LOCK;
            synchronized (object) {
                this.live = new ArrayList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearClosedSockets() {
            Object object = JWSockets.this.LOCK;
            synchronized (object) {
                this.closed = new ArrayList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<Socket> getLiveSockets() {
            Object object = JWSockets.this.LOCK;
            synchronized (object) {
                return (ArrayList)this.live.clone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<Socket> getClosedSockets() {
            Object object = JWSockets.this.LOCK;
            synchronized (object) {
                return (ArrayList)this.closed.clone();
            }
        }

        private String getStats() {
            return "(live=" + this.getLiveSocketCount() + " opened=" + this.getOpenedSocketCount() + " closed=" + this.getClosedSocketCount() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void socketConnected(Socket sock) {
            Object object = JWSockets.this.LOCK;
            synchronized (object) {
                ++this.socksOpened;
                if (this.keepLive && !this.live.contains(sock)) {
                    this.live.add(sock);
                }
            }
            if (JWSockets.this.printAll) {
                System.out.println("[JWSockets] Socket connected => " + sock + " " + this.getStats());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void socketClosed(Socket sock) {
            Object object = JWSockets.this.LOCK;
            synchronized (object) {
                ++this.socksClosed;
                if (this.keepLive) {
                    this.live.remove(sock);
                }
                if (this.keepClosed && !this.closed.contains(sock)) {
                    this.closed.add(sock);
                }
            }
            if (JWSockets.this.printAll) {
                System.out.println("[JWSockets] Socket closed    => " + sock + " " + this.getStats());
            }
        }

        public int getLiveSocketCount() {
            return this.socksOpened - this.socksClosed;
        }

        public int getOpenedSocketCount() {
            return this.socksOpened;
        }

        public int getClosedSocketCount() {
            return this.socksClosed;
        }
    }

    private class JWSockImpl
    extends SocketImpl {
        Class clazz;
        SocketImpl impl;

        JWSockImpl(SocketImpl impl) {
            this.impl = impl;
            this.clazz = SocketImpl.class;
        }

        public Socket getUnderlyingSocket() {
            try {
                Field field = SocketImpl.class.getDeclaredField("socket");
                field.setAccessible(true);
                Socket sock = (Socket)field.get(this.impl);
                if (sock == null) {
                    sock = (Socket)field.get(this);
                }
                if (sock == null) {
                    sock = this.getSocket();
                }
                return sock;
            }
            catch (Exception x) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startTrackingConnect() {
            Object object = JWSockets.this.LOCK;
            synchronized (object) {
                JWSockets.this.tracking.add(this);
                JWSockets.this.startNotifyIfNecessary();
            }
        }

        protected void accept(SocketImpl arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("accept", SocketImpl.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        protected int available() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("available", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return 0;
            }
        }

        protected void bind(InetAddress arg0, int arg1) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("bind", InetAddress.class, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0, arg1);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("close", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            Object object = JWSockets.this.LOCK;
            synchronized (object) {
                Socket s = this.getUnderlyingSocket();
                for (JWSocketsListener l : JWSockets.this.listeners) {
                    l.socketClosed(s);
                }
            }
        }

        protected void connect(SocketAddress arg0, int arg1) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("connect", SocketAddress.class, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0, arg1);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.startTrackingConnect();
        }

        protected void connect(String arg0, int arg1) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("connect", String.class, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0, arg1);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.startTrackingConnect();
        }

        protected void connect(InetAddress arg0, int arg1) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("connect", InetAddress.class, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0, arg1);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.startTrackingConnect();
        }

        protected void create(boolean arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("create", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        protected FileDescriptor getFileDescriptor() {
            try {
                Method method = this.clazz.getDeclaredMethod("getFileDescriptor", new Class[0]);
                method.setAccessible(true);
                return (FileDescriptor)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }

        protected InetAddress getInetAddress() {
            try {
                Method method = this.clazz.getDeclaredMethod("getInetAddress", new Class[0]);
                method.setAccessible(true);
                return (InetAddress)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }

        protected InputStream getInputStream() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("getInputStream", new Class[0]);
                method.setAccessible(true);
                return (InputStream)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }

        protected int getLocalPort() {
            try {
                Method method = this.clazz.getDeclaredMethod("getLocalPort", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return -1;
            }
        }

        public Object getOption(int optID) throws SocketException {
            return this.impl.getOption(optID);
        }

        protected OutputStream getOutputStream() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("getOutputStream", new Class[0]);
                method.setAccessible(true);
                return (OutputStream)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }

        protected int getPort() {
            try {
                Method method = this.clazz.getDeclaredMethod("getPort", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return -1;
            }
        }

        public ServerSocket getServerSocket() {
            try {
                Method method = this.clazz.getDeclaredMethod("getServerSocket", new Class[0]);
                method.setAccessible(true);
                return (ServerSocket)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }

        public Socket getSocket() {
            try {
                Method method = this.clazz.getDeclaredMethod("getSocket", new Class[0]);
                method.setAccessible(true);
                return (Socket)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }

        protected void listen(int arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("listen", Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        protected void reset() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("reset", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        protected void sendUrgentData(int arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("sendUrgentData", Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        public void setOption(int optID, Object value) throws SocketException {
            this.impl.setOption(optID, value);
        }

        public void setServerSocket(ServerSocket sock) {
            try {
                Method method = this.clazz.getDeclaredMethod("setServerSocket", ServerSocket.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, sock);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        public void setSocket(Socket sock) {
            try {
                Method method = this.clazz.getDeclaredMethod("setSocket", Socket.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, sock);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        protected void shutdownInput() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("shutdownInput", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        protected void shutdownOutput() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("shutdownOutput", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        protected boolean supportsUrgentData() {
            try {
                Method method = this.clazz.getDeclaredMethod("supportsUrgentData", new Class[0]);
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
                return false;
            }
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private class NotifyThread
    extends Thread {
        public NotifyThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = JWSockets.this.LOCK;
                synchronized (object) {
                    if (JWSockets.this.tracking.size() == 0) {
                        JWSockets.this.notify = null;
                        break;
                    }
                }
                object = JWSockets.this.LOCK;
                synchronized (object) {
                    for (int i = 0; i < JWSockets.this.tracking.size(); ++i) {
                        JWSockImpl jwsock = (JWSockImpl)JWSockets.this.tracking.get(i);
                        Socket sock = jwsock.getUnderlyingSocket();
                        if (sock == null || !sock.isConnected()) continue;
                        JWSockets.this.tracking.remove(i--);
                        for (JWSocketsListener l : JWSockets.this.listeners) {
                            l.socketConnected(sock);
                        }
                    }
                }
            }
        }
    }

    private class JWSockImplFactory
    implements SocketImplFactory {
        private JWSockImplFactory() {
        }

        public SocketImpl createSocketImpl() {
            try {
                Class<?> psi = Class.forName("java.net.PlainSocketImpl");
                Constructor<?> con = psi.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                JWSockImpl impl = new JWSockImpl((SocketImpl)con.newInstance(new Object[0]));
                return impl;
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }
    }
}

