/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.network;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import jwrapper.jwutils.network.JWDatagramSocketsListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWDatagramSockets {
    private Object LOCK = new Object();
    private ArrayList<JWDatagramSocketsListener> listeners = new ArrayList();
    private SockStats stats = new SockStats();
    private boolean printAll = false;
    private boolean traceBinds = false;
    private boolean traceClosures = false;
    static JWDatagramSockets INSTANCE = null;
    static Class implClass;

    public void printAllSocketActivity(boolean print) {
        this.printAll = print;
    }

    public void traceAllSocketClosures(boolean trace) {
        this.traceClosures = trace;
    }

    public void traceAllSocketBinds(boolean trace) {
        this.traceBinds = trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JWDatagramSocketsListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JWDatagramSocketsListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    public ArrayList<DatagramSocket> getLiveSockets() {
        return this.stats.getLiveSockets();
    }

    public ArrayList<DatagramSocket> getClosedSockets() {
        return this.stats.getClosedSockets();
    }

    public void clearLiveSockets() {
        this.stats.clearLiveSockets();
    }

    public void clearClosedSockets() {
        this.stats.clearClosedSockets();
    }

    public void retainLiveSockets(boolean keep) {
        this.stats.retainLiveSockets(keep);
    }

    public void retainClosedSockets(boolean keep) {
        this.stats.retainClosedSockets(keep);
    }

    public int getLiveSocketCount() {
        return this.stats.getLiveSocketCount();
    }

    public int getOpenedSocketCount() {
        return this.stats.getOpenedSocketCount();
    }

    public int getClosedSocketCount() {
        return this.stats.getClosedSocketCount();
    }

    private JWDatagramSockets() throws Exception {
        DatagramSocket sock = new DatagramSocket();
        sock.close();
        Field field = DatagramSocket.class.getDeclaredField("impl");
        field.setAccessible(true);
        DatagramSocketImpl impl = (DatagramSocketImpl)field.get(sock);
        implClass = impl.getClass();
        System.out.println("[JWDatagramSockets] Impl class is " + implClass);
        field = DatagramSocket.class.getDeclaredField("factory");
        field.setAccessible(true);
        JWDatagramSockImplFactory jws = new JWDatagramSockImplFactory();
        field.set(null, jws);
        jws.printTest = true;
        sock = new DatagramSocket();
        sock.close();
        jws.printTest = false;
        this.addListener(this.stats);
    }

    public static JWDatagramSockets interceptSockets() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new JWDatagramSockets();
        }
        return INSTANCE;
    }

    public static void main(String[] args) throws Exception {
        JWDatagramSockets socks = JWDatagramSockets.interceptSockets();
        socks.retainLiveSockets(true);
        socks.retainClosedSockets(true);
        socks.printAllSocketActivity(true);
        URL url = new URL("http://google.com");
        url.openStream();
        url = new URL("http://myhttp.info");
        url.openStream();
        Thread.sleep(500L);
        System.out.println("[JWDatagramSockets] " + socks.getLiveSocketCount() + " live sockets");
        ArrayList<DatagramSocket> list = socks.getLiveSockets();
        for (DatagramSocket sock : list) {
            System.out.println("[JWDatagramSockets] Open: " + sock);
        }
        list = socks.getClosedSockets();
        for (DatagramSocket sock : list) {
            System.out.println("[JWDatagramSockets] Closed: " + sock);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SockStats
    implements JWDatagramSocketsListener {
        int socksOpened = 0;
        int socksClosed = 0;
        ArrayList<DatagramSocketImpl> live = new ArrayList();
        ArrayList<DatagramSocketImpl> closed = new ArrayList();
        boolean keepLive = false;
        boolean keepClosed = false;

        SockStats() {
        }

        public void retainLiveSockets(boolean b) {
            this.keepLive = b;
            if (!b) {
                this.clearLiveSockets();
            }
        }

        public void retainClosedSockets(boolean b) {
            this.keepClosed = b;
            if (!b) {
                this.clearClosedSockets();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearLiveSockets() {
            Object object = JWDatagramSockets.this.LOCK;
            synchronized (object) {
                this.live = new ArrayList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearClosedSockets() {
            Object object = JWDatagramSockets.this.LOCK;
            synchronized (object) {
                this.closed = new ArrayList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<DatagramSocket> getLiveSockets() {
            Object object = JWDatagramSockets.this.LOCK;
            synchronized (object) {
                return (ArrayList)this.live.clone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<DatagramSocket> getClosedSockets() {
            Object object = JWDatagramSockets.this.LOCK;
            synchronized (object) {
                return (ArrayList)this.closed.clone();
            }
        }

        private String getStats() {
            return "(live=" + this.getLiveSocketCount() + " opened=" + this.getOpenedSocketCount() + " closed=" + this.getClosedSocketCount() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void socketBound(DatagramSocketImpl sock) {
            Object object = JWDatagramSockets.this.LOCK;
            synchronized (object) {
                ++this.socksOpened;
                if (this.keepLive && !this.live.contains(sock)) {
                    this.live.add(sock);
                }
            }
            if (JWDatagramSockets.this.printAll) {
                System.out.println("[JWDatagramSockets] DatagramSocket bound => " + sock + " " + this.getStats());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void socketClosed(DatagramSocketImpl sock) {
            Object object = JWDatagramSockets.this.LOCK;
            synchronized (object) {
                ++this.socksClosed;
                if (this.keepLive) {
                    this.live.remove(sock);
                }
                if (this.keepClosed && !this.closed.contains(sock)) {
                    this.closed.add(sock);
                }
            }
            if (JWDatagramSockets.this.printAll) {
                System.out.println("[JWDatagramSockets] DatagramSocket closed    => " + sock + " " + this.getStats());
            }
        }

        public int getLiveSocketCount() {
            return this.socksOpened - this.socksClosed;
        }

        public int getOpenedSocketCount() {
            return this.socksOpened;
        }

        public int getClosedSocketCount() {
            return this.socksClosed;
        }
    }

    private class JWDatagramSockImpl
    extends DatagramSocketImpl {
        Class clazz;
        DatagramSocketImpl impl;
        InetAddress bound_inet;
        int bound_port;

        JWDatagramSockImpl(DatagramSocketImpl impl) throws ClassNotFoundException {
            this.impl = impl;
            this.clazz = DatagramSocketImpl.class;
        }

        public String toString() {
            return this.impl.toString() + " (" + this.bound_inet + ":" + this.bound_port + ")";
        }

        public Object getOption(int optID) throws SocketException {
            return this.impl.getOption(optID);
        }

        public void setOption(int optID, Object value) throws SocketException {
            this.impl.setOption(optID, value);
        }

        void rethrowSocketException(Throwable t) throws SocketException {
            if (t instanceof InvocationTargetException) {
                InvocationTargetException inv = (InvocationTargetException)t;
                t = inv.getTargetException();
            }
            if (t instanceof SocketException) {
                throw (SocketException)t;
            }
        }

        void rethrowIOException(Throwable t) throws IOException {
            if (t instanceof InvocationTargetException) {
                InvocationTargetException inv = (InvocationTargetException)t;
                t = inv.getTargetException();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void bind(int arg0, InetAddress arg1) throws SocketException {
            try {
                Method method = this.clazz.getDeclaredMethod("bind", Integer.TYPE, InetAddress.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0, arg1);
                this.bound_inet = arg1;
                this.bound_port = arg0;
                if (JWDatagramSockets.this.traceBinds) {
                    new Throwable("JWDatagramSocket " + this + " bound (" + this.bound_inet + ":" + this.bound_port + ")").printStackTrace(System.out);
                }
                Object object = JWDatagramSockets.this.LOCK;
                synchronized (object) {
                    for (JWDatagramSocketsListener l : JWDatagramSockets.this.listeners) {
                        l.socketBound(this);
                    }
                }
            }
            catch (Exception x) {
                this.rethrowSocketException(x);
                x.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            if (JWDatagramSockets.this.traceClosures) {
                new Throwable("JWDatagramSocket " + this + " closed (" + this.bound_inet + ":" + this.bound_port + ")").printStackTrace(System.out);
            }
            try {
                Method method = this.clazz.getDeclaredMethod("close", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            Object object = JWDatagramSockets.this.LOCK;
            synchronized (object) {
                for (JWDatagramSocketsListener l : JWDatagramSockets.this.listeners) {
                    l.socketClosed(this);
                }
            }
        }

        protected void connect(InetAddress address, int port) throws SocketException {
            try {
                Method method = this.clazz.getDeclaredMethod("connect", InetAddress.class, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, address, port);
            }
            catch (Exception x) {
                this.rethrowSocketException(x);
                x.printStackTrace();
            }
        }

        protected void create() throws SocketException {
            try {
                Method method = this.clazz.getDeclaredMethod("create", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                this.rethrowSocketException(x);
                x.printStackTrace();
            }
        }

        protected byte getTTL() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("getTTL", new Class[0]);
                method.setAccessible(true);
                return (Byte)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
                return -1;
            }
        }

        protected int getTimeToLive() throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("getTimeToLive", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.impl, new Object[0]);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
                return -1;
            }
        }

        protected void join(InetAddress arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("join", InetAddress.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
            }
        }

        protected void joinGroup(SocketAddress arg0, NetworkInterface arg1) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("joinGroup", SocketAddress.class, NetworkInterface.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0, arg1);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
            }
        }

        protected void leave(InetAddress arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("leave", InetAddress.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
            }
        }

        protected void leaveGroup(SocketAddress arg0, NetworkInterface arg1) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("leaveGroup", SocketAddress.class, NetworkInterface.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0, arg1);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
            }
        }

        protected int peek(InetAddress arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("peek", InetAddress.class);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
                return -1;
            }
        }

        protected int peekData(DatagramPacket arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("peekData", DatagramPacket.class);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
                return -1;
            }
        }

        protected void receive(DatagramPacket arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("receive", DatagramPacket.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
            }
        }

        protected void send(DatagramPacket arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("send", DatagramPacket.class);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
            }
        }

        protected void setTTL(byte arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("setTTL", Byte.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
            }
        }

        protected void setTimeToLive(int arg0) throws IOException {
            try {
                Method method = this.clazz.getDeclaredMethod("setTimeToLive", Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.impl, arg0);
            }
            catch (Exception x) {
                this.rethrowIOException(x);
                x.printStackTrace();
            }
        }
    }

    private class JWDatagramSockImplFactory
    implements DatagramSocketImplFactory {
        boolean printTest = false;

        private JWDatagramSockImplFactory() {
        }

        public DatagramSocketImpl createDatagramSocketImpl() {
            try {
                JWDatagramSockImpl impl;
                if (this.printTest) {
                    System.out.println("[JWDatagramSockets] Creating new test socket");
                }
                Class psi = implClass;
                if (this.printTest) {
                    System.out.println("[JWDatagramSockets] Have plain impl " + psi);
                }
                try {
                    Constructor con = psi.getDeclaredConstructor(new Class[0]);
                    con.setAccessible(true);
                    impl = new JWDatagramSockImpl((DatagramSocketImpl)con.newInstance(new Object[0]));
                }
                catch (NoSuchMethodException x) {
                    Constructor con = psi.getDeclaredConstructor(Boolean.TYPE);
                    con.setAccessible(true);
                    impl = new JWDatagramSockImpl((DatagramSocketImpl)con.newInstance(true));
                }
                if (this.printTest) {
                    System.out.println("[JWDatagramSockets] Created impl, returning " + impl);
                }
                return impl;
            }
            catch (Exception x) {
                if (this.printTest) {
                    System.out.println("[JWDatagramSockets] Error creating impl: " + x);
                }
                x.printStackTrace();
                return null;
            }
        }
    }
}

