/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import jwrapper.JWConstants;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.hidden.events.JWMacOSEventManager;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWLinuxOS;
import jwrapper.jwutils.JWOSXEventListener;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.ostools.osx.OSXAdapter;
import utils.stream.StreamUtils;
import utils.string.CharStack;

public class JWMacOS
extends JWGenericOS {
    public static JWMacOS getMacOSInstance() {
        return JWGenericOS.macInstance;
    }

    public static void registerURLSchemeForVirtualApp(String schemeProtocol, final String virtualApp) throws IOException, InterruptedException {
        String appBundle = JWSystem.getAppBundleName();
        String bundleID = JWConstants.buildOsxDomainFromBundle(appBundle);
        JWMacOS.registerAppAsURLHandler(schemeProtocol, bundleID);
        JWMacOS.setOSXEventListener(new JWOSXEventListener(){

            public void openURL(String url) {
                Properties properties = JWLaunchProperties.getAsProperties();
                properties.put("urlhandler", url);
                try {
                    JWSystem.forkVirtualApp(virtualApp, properties, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public String getOSNameWithBitness() {
        String arch = System.getProperty("os.arch");
        if (arch.equals("x86_64")) {
            return this.getOSName() + " " + System.getProperty("os.version") + " x64";
        }
        if (arch.equals("x86")) {
            return this.getOSName() + " " + System.getProperty("os.version") + " x86";
        }
        return this.getOSName() + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
    }

    public String getOSBuild() {
        RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"sw_vers", "-buildVersion"});
        if (commandResponse != null && commandResponse.returnCode == 0) {
            return commandResponse.stdout.trim();
        }
        return null;
    }

    public String getOSName() {
        return "macOS " + System.getProperty("os.version");
    }

    public static boolean registerAppAsURLHandler(String scheme, String bundleID) {
        return JWNativeAPI.getInstance().registerURLHandler(scheme, bundleID);
    }

    public static File getDotAppLauncher() {
        String launcherPath = JWLaunchProperties.getProperty("launched_from_dynprops");
        if (launcherPath == null || launcherPath.length() == 0) {
            return null;
        }
        File launcher = new File(launcherPath);
        try {
            return launcher.getParentFile().getParentFile().getParentFile();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static File getParameterisationFile(File dotApp) {
        File newFile = new File(dotApp, "Contents/Resources/params.lproj/locversion.plist");
        if (newFile.exists()) {
            return newFile;
        }
        File oldFile = new File(dotApp, "Contents/Resources/AppParams.excludefromsigning");
        if (oldFile.exists()) {
            return oldFile;
        }
        return newFile;
    }

    public static boolean canRunLauncher64() {
        return OS.isMacOS() && OS.isMacOS64bit() && OS.isMacOS1073OrLater();
    }

    public static String getJvmUserAccount() {
        return RunCommandGetOutput.runCommandGetOutput("whoami")[0];
    }

    public static boolean haveSudoPermissions() {
        return JWLinuxOS.haveSudoPermissions();
    }

    public String[] getAllConsoleUsers() {
        String output = RunCommandGetOutput.runCommandGetOutput(new String[]{"w", "-h"})[0];
        String[] lines = output.split("\n");
        ArrayList<String> users = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            CharStack cs = new CharStack(lines[i]);
            cs.popWhitespace();
            String user = cs.popText(true);
            cs.popWhitespace();
            String console = cs.popText(true);
            if (!console.toLowerCase().startsWith("console")) continue;
            users.add(user);
        }
        return users.toArray(new String[0]);
    }

    public static void setMyOSXAppName(String name) {
        OSXAdapter.setAppName(name);
    }

    public static void setMyOSXAppBadge(String text) {
        OSXAdapter.setDockIconBadge(text);
    }

    public static void requestUserAttention(boolean isCritical) {
        OSXAdapter.requestUserAttention(isCritical);
    }

    public String getHostname() {
        String[] output = RunCommandGetOutput.runCommandGetOutput(new String[]{"hostname"});
        if (output == null || output[0] == null || output[0].trim().length() == 0) {
            return super.getHostname();
        }
        return output[0].trim();
    }

    public static File getNativeLauncherForDotApp(File dotApp) {
        if (!dotApp.getName().toLowerCase().endsWith(".app")) {
            return null;
        }
        File contents = new File(dotApp, "Contents");
        File macos = new File(contents, "MacOS");
        File osxwrapper = new File(macos, "osxwrapper");
        File stub = new File(macos, "JavaApplicationStub");
        if (stub.exists()) {
            return stub;
        }
        if (osxwrapper.exists()) {
            return osxwrapper;
        }
        if (macos.exists()) {
            File[] children = macos.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getName().startsWith(".")) continue;
                return children[i];
            }
        }
        return null;
    }

    public boolean killProcess(int pid) {
        String command = "kill -9 " + pid;
        try {
            Process proc = Runtime.getRuntime().exec(command);
            new IgnoreInputStream(proc.getInputStream());
            String error = StreamUtils.readAllAsString(proc.getErrorStream());
            int code = 0;
            try {
                code = proc.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return code == 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void setOSXEventListener(JWOSXEventListener listener) {
        JWMacOSEventManager.INSTANCE.setOSXEventListener(listener);
    }

    public static String getRequestedURL() {
        return JWLaunchProperties.getPropertyPossiblyNull("urlhandler");
    }

    public String getOSProductName() {
        String version = System.getProperty("os.version");
        return JWMacOS.macOSVersionName(version);
    }

    public static String macOSVersionName(String version) {
        if (version.startsWith("10.10")) {
            return "Yosemite";
        }
        if (version.startsWith("10.11")) {
            return "El Capitan";
        }
        if (version.startsWith("10.12")) {
            return "Sierra";
        }
        if (version.startsWith("10.13")) {
            return "High Sierra";
        }
        if (version.startsWith("10.0")) {
            return "Cheetah";
        }
        if (version.startsWith("10.1")) {
            return "Puma";
        }
        if (version.startsWith("10.2")) {
            return "Jaguar";
        }
        if (version.startsWith("10.3")) {
            return "Panther";
        }
        if (version.startsWith("10.4")) {
            return "Tiger";
        }
        if (version.startsWith("10.5")) {
            return "Leopard";
        }
        if (version.startsWith("10.6")) {
            return "Snow Leopard";
        }
        if (version.startsWith("10.7")) {
            return "Lion";
        }
        if (version.startsWith("10.8")) {
            return "Mountain Lion";
        }
        if (version.startsWith("10.9")) {
            return "Mavericks";
        }
        return null;
    }

    public boolean is64Bit() {
        return OS.isMacOS64bit();
    }

    public static class IgnoreInputStream
    extends Thread {
        InputStream in;

        public IgnoreInputStream(InputStream in) {
            this.in = in;
            this.start();
        }

        public void run() {
            try {
                int n = this.in.read();
                while (n != -1) {
                    System.err.print((char)n);
                    n = this.in.read();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

