/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.compression.splitcompressor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import jwrapper.compression.splitcompressor.ByteArrayStruct;
import jwrapper.compression.splitcompressor.ByteArraySubIndexer;
import jwrapper.compression.splitcompressor.EmptySubFile;
import jwrapper.compression.splitcompressor.FilePart;
import jwrapper.compression.splitcompressor.FileSegment;
import jwrapper.compression.splitcompressor.SearchConfig;
import jwrapper.compression.splitcompressor.SubFile;
import jwrapper.compression.splitcompressor.SubstitutionPacker;
import utils.files.FileUtil;
import utils.stream.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WholeFile {
    Object segments_LOCK = new Object();
    ArrayList<FileSegment> segments = new ArrayList();
    File file;
    long totalDeleted = 0L;
    long originalFileSize = 0L;
    private static final String SPEC_FILENAME = "JWPackSpec";
    private final Object searchesLock = new Object();
    private int searchesStillToRun = 0;
    private Throwable error;
    private static final int SEARCH_WINDOW = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePackSpecTo(WholeFile[] spec, File deploy) throws IOException {
        File target = new File(deploy, SPEC_FILENAME);
        if (target.exists()) {
            target.delete();
        }
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(target));
        try {
            if (spec == null) {
                StreamUtils.writeInt(bout, 0);
                return;
            }
            StreamUtils.writeInt(bout, spec.length);
            for (WholeFile wholeFile : spec) {
                wholeFile.writeTo(bout, deploy);
            }
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeTo(BufferedOutputStream bout, File baseDir) throws IOException {
        StreamUtils.writeStringUTF8(bout, SubstitutionPacker.getChildPath(baseDir, this.file));
        StreamUtils.writeLong(bout, this.originalFileSize);
        StreamUtils.writeInt(bout, this.segments.size());
        for (FileSegment segment : this.segments) {
            segment.writeTo(bout, baseDir);
        }
    }

    public static boolean needsExtracting(File folder) {
        File target = new File(folder, SPEC_FILENAME);
        return target.exists();
    }

    public static void deletePackSpecFrom(File deploy) {
        File target = new File(deploy, SPEC_FILENAME);
        if (target.exists()) {
            target.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WholeFile[] loadPackSpecFrom(File deploy) throws IOException {
        File target = new File(deploy, SPEC_FILENAME);
        if (!target.exists()) {
            return null;
        }
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(target));
        try {
            ArrayList<WholeFile> spec = new ArrayList<WholeFile>();
            int count = StreamUtils.readInt(bin);
            for (int i = 0; i < count; ++i) {
                WholeFile wholeFile = WholeFile.readFrom(bin, deploy);
                if (wholeFile.segments.size() <= 0) continue;
                spec.add(wholeFile);
            }
            WholeFile[] wholeFileArray = spec.toArray(new WholeFile[0]);
            return wholeFileArray;
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WholeFile readFrom(BufferedInputStream bin, File baseDir) throws IOException {
        WholeFile file = new WholeFile();
        file.file = new File(baseDir, StreamUtils.readStringUTF8(bin));
        file.originalFileSize = StreamUtils.readLong(bin);
        int count = StreamUtils.readInt(bin);
        for (int i = 0; i < count; ++i) {
            FileSegment segment = new FileSegment();
            segment.wholeFile = file;
            segment.readFrom(bin, baseDir);
            Object object = file.segments_LOCK;
            synchronized (object) {
                file.segments.add(segment);
                continue;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileSegment segment) throws IOException {
        int bytesToRemove = segment.segmentLength;
        String filename = segment.wholeFile.file.getParentFile().getName() + "/" + segment.wholeFile.file.getName();
        int tailLen = (int)(this.file.length() - (long)(segment.wholeFileSegmendStartIndex + segment.segmentLength));
        byte[] tail = new byte[tailLen];
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        try {
            int originalSize = (int)this.file.length();
            raf.seek(segment.wholeFileSegmendStartIndex + segment.segmentLength);
            raf.readFully(tail);
            raf.seek(segment.wholeFileSegmendStartIndex);
            raf.setLength(originalSize - bytesToRemove);
            raf.write(tail);
        }
        finally {
            raf.close();
        }
    }

    public long getOriginalFileSize() {
        return this.originalFileSize;
    }

    public boolean containsPartFile(File partFile) {
        for (FileSegment segment : this.segments) {
            FilePart part = segment.parts.get(0);
            if (!part.subFile.file.equals(partFile)) continue;
            return true;
        }
        return false;
    }

    public void unpackSegments() throws IOException {
        if (this.file.length() == this.getOriginalFileSize()) {
            System.out.println("[WholeFile] " + this.file.getName() + " does not need unpacking...");
            return;
        }
        boolean ALWAYS_USE_IN_MEMORY_STRUCT = true;
        System.out.println("[FileSegment] WholeFile is " + this.file.getName());
        byte[] data = FileUtil.readFile(this.file);
        ByteArrayStruct bStruct = new ByteArrayStruct();
        bStruct.insert(data, 0);
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            FileSegment seg = this.segments.get(i);
            seg.unpackParts(bStruct);
        }
        bStruct.writeToFile(this.file);
    }

    public void dumpDebug() {
        System.out.println("WholeFile: " + this.file.getParentFile().getName() + "/" + this.file.getName() + " [" + this.segments.size() + " segments]");
        for (FileSegment seg : this.segments) {
            seg.dumpDebug();
        }
    }

    public void deleteMatchedSegments() throws IOException {
        Collections.sort(this.segments);
        this.checkForOverlaps();
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            FileSegment segment = this.segments.get(i);
            if (segment.deleted) continue;
            this.delete(segment);
            segment.wholeFileSizeBeforeUnpack = this.file.length();
            segment.deleted = true;
            this.totalDeleted += (long)segment.segmentLength;
        }
    }

    private void checkForOverlaps() {
        ArrayList<FileSegment> segmentsToRemove = new ArrayList<FileSegment>();
        boolean overlap = false;
        for (int i = 0; i < this.segments.size(); ++i) {
            FileSegment seg1 = this.segments.get(i);
            for (int j = i + 1; j < this.segments.size(); ++j) {
                FileSegment seg2 = this.segments.get(j);
                int seg1Start = seg1.wholeFileSegmendStartIndex;
                int seg2Start = seg2.wholeFileSegmendStartIndex;
                int seg1End = seg1.wholeFileSegmendStartIndex + seg1.segmentLength;
                int seg2End = seg2.wholeFileSegmendStartIndex + seg2.segmentLength;
                if (Math.max(seg1End, seg2End) - Math.min(seg1Start, seg2Start) >= seg2End - seg2Start + (seg1End - seg1Start)) continue;
                if (seg1.contains(seg2)) {
                    segmentsToRemove.add(seg2);
                    continue;
                }
                if (seg2.contains(seg1)) {
                    segmentsToRemove.add(seg1);
                    continue;
                }
                System.out.println("OVERLAP DETECTED");
                System.out.println("\t" + seg1.wholeFileSegmendStartIndex + " len:" + seg1.segmentLength + " sub:" + seg1.parts.get((int)0).subFile.file.getName());
                System.out.println("\t" + seg2.wholeFileSegmendStartIndex + " len:" + seg2.segmentLength + " sub:" + seg2.parts.get((int)0).subFile.file.getName());
                System.out.flush();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(1);
            }
        }
        this.segments.removeAll(segmentsToRemove);
    }

    public void searchForSubstitutions(ArrayList<File> partFileCandidates) throws IOException {
        boolean isLinuxArm;
        String wholeFileNameLowercase = this.file.getName().toLowerCase();
        boolean isLinux = wholeFileNameLowercase.contains("-linux") || wholeFileNameLowercase.startsWith("linuxwrapper");
        boolean bl = isLinuxArm = wholeFileNameLowercase.contains("-linuxarm") || wholeFileNameLowercase.contains("-linux32arm");
        if (isLinuxArm) {
            isLinux = false;
        }
        boolean isWindows = wholeFileNameLowercase.contains("-windows");
        boolean isMac = wholeFileNameLowercase.contains("-mac");
        boolean is32BitFile = SearchConfig.is32Bit(wholeFileNameLowercase);
        boolean is64BitFile = SearchConfig.is64Bit(wholeFileNameLowercase);
        boolean isAuxFile = SearchConfig.isAUXArchive(wholeFileNameLowercase);
        System.out.println("[WholeFile] Analysing " + this.file.getParentFile().getName() + "/" + this.file.getName() + " (x" + partFileCandidates.size() + ")...");
        for (File partFileCandidate : partFileCandidates) {
            SubstitutionPacker.odp.runAsync(new SearchJob(partFileCandidate, isLinux, isLinuxArm, isMac, isWindows, isAuxFile, is64BitFile, is32BitFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() throws IOException {
        Object object = this.searchesLock;
        synchronized (object) {
            while (this.searchesStillToRun > 0) {
                try {
                    this.searchesLock.wait(100L);
                }
                catch (Exception exception) {}
            }
        }
        if (this.error != null) {
            throw new IOException(this.error);
        }
    }

    private void searchPartFileCandidate(File partFileCandidate, boolean isLinux, boolean isLinuxArm, boolean isMac, boolean isWindows, boolean isAuxFile, boolean is64BitFile, boolean is32BitFile) throws IOException {
        SubFile subFile;
        if (partFileCandidate.equals(this.file)) {
            return;
        }
        if (partFileCandidate.exists()) {
            subFile = new SubFile();
            subFile.file = partFileCandidate;
        } else {
            subFile = new EmptySubFile();
        }
        String partFilename = partFileCandidate.getName();
        boolean is32JREArchive = partFilename.endsWith(".p2.l2") && partFilename.contains("32JRE-");
        boolean is64JREArchive = partFilename.endsWith(".p2.l2") && partFilename.contains("64JRE-");
        boolean is64Bit = this.file.getName().contains("64-");
        boolean is32Bit = this.file.getName().contains("32-");
        if (!(is32JREArchive && is64Bit || is64JREArchive && is32Bit)) {
            boolean isSubMac;
            boolean isSubLinuxArm;
            String subNameLowerCase = subFile.file.getName().toLowerCase();
            boolean isSubLinux = subNameLowerCase.contains("-linux") || subNameLowerCase.contains("os_jwlin") || subNameLowerCase.startsWith("linuxwrapper");
            boolean bl = isSubLinuxArm = subNameLowerCase.contains("-linuxarm") || subNameLowerCase.contains("os_jwarm");
            if (isSubLinuxArm) {
                isSubLinux = false;
            }
            boolean isSubWindows = subNameLowerCase.contains("-windows") || subNameLowerCase.contains("os_jwwin");
            boolean bl2 = isSubMac = subNameLowerCase.contains("-mac") || subNameLowerCase.contains("os_jwmac");
            if (isLinuxArm && (isSubWindows || isSubMac || isSubLinux)) {
                return;
            }
            if (isLinux && (isSubLinuxArm || isSubWindows || isSubMac)) {
                return;
            }
            if (isMac && (isSubLinuxArm || isSubWindows || isSubLinux)) {
                return;
            }
            if (isWindows && (isSubLinuxArm || isSubLinux || isSubMac)) {
                return;
            }
            boolean is32BitSubFile = SearchConfig.is32Bit(subNameLowerCase);
            boolean is64BitSubFile = SearchConfig.is64Bit(subNameLowerCase);
            boolean isSubAuxFile = SearchConfig.isAUXArchive(subNameLowerCase);
            if (isSubAuxFile && !isAuxFile) {
                return;
            }
            if (isAuxFile && !isSubAuxFile) {
                return;
            }
            if ((!is32JREArchive || is64JREArchive) && (is32BitSubFile && is64BitFile || is64BitSubFile && is32BitFile)) {
                return;
            }
            long s = System.currentTimeMillis();
            this.searchForMatch(subFile, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean searchForMatch(SubFile subFile, boolean fullMatchesOnly) throws IOException {
        int SIZE = (int)Math.min(1000L, subFile.getFileLength());
        if (subFile instanceof EmptySubFile) {
            SIZE = 1000;
        }
        byte[] buffer = new byte[SIZE];
        byte[] sourceBytes = subFile.readFile();
        byte[] targetBytes = FileUtil.readFile(this.file);
        ArrayList<FilePart> foundFileParts = new ArrayList<FilePart>();
        ArrayList<FileSegment> foundFileSegments = new ArrayList<FileSegment>();
        int iteration = 0;
        int totalProcessed = 0;
        int sourceIndex = 0;
        int index = -1;
        while (sourceIndex < sourceBytes.length) {
            int maxCanRead = Math.min(buffer.length, sourceBytes.length - sourceIndex);
            System.arraycopy(sourceBytes, sourceIndex, buffer, 0, maxCanRead);
            int searchAfterIndex = 0;
            if (index >= 0 && subFile instanceof EmptySubFile) {
                searchAfterIndex = index + 1;
            }
            if ((index = WholeFile.indexOf(targetBytes, buffer, searchAfterIndex)) < 0) {
                if (totalProcessed > 0) {
                    if (!fullMatchesOnly) break;
                    return false;
                }
                if (subFile instanceof EmptySubFile) {
                    return false;
                }
                if (iteration < 2) {
                    sourceIndex += 1000;
                } else {
                    if (iteration != 2) break;
                    sourceIndex = sourceBytes.length;
                }
                ++iteration;
                continue;
            }
            int thisMatchLength = buffer.length;
            totalProcessed += buffer.length;
            int sourcePosition = sourceIndex + thisMatchLength;
            int targetPosition = index + thisMatchLength;
            while (sourcePosition < sourceBytes.length && targetPosition < targetBytes.length && sourceBytes[sourcePosition] == targetBytes[targetPosition]) {
                ++sourcePosition;
                ++targetPosition;
                ++totalProcessed;
                ++thisMatchLength;
            }
            while (sourceIndex - 1 > 0 && targetPosition - 1 > 0 && sourceBytes[sourceIndex - 1] == targetBytes[index - 1]) {
                --sourceIndex;
                --index;
                ++totalProcessed;
                ++thisMatchLength;
            }
            FilePart filePart = new FilePart();
            filePart.subFile = subFile;
            filePart.partIndex = sourceIndex;
            filePart.length = thisMatchLength;
            foundFileParts.add(filePart);
            FileSegment segment = new FileSegment();
            segment.wholeFile = this;
            segment.wholeFileSegmendStartIndex = index;
            segment.segmentLength = thisMatchLength;
            segment.parts.add(filePart);
            filePart.segment = segment;
            foundFileSegments.add(segment);
            sourceIndex += thisMatchLength;
            index += thisMatchLength;
        }
        if (foundFileParts.size() == 0) {
            return false;
        }
        subFile.fileParts.addAll(foundFileParts);
        int matchCount = 0;
        String matchFilename = null;
        Collections.sort(foundFileSegments);
        for (int i = foundFileSegments.size() - 1; i >= 0; --i) {
            FileSegment seg = (FileSegment)foundFileSegments.get(i);
            Object object = this.segments_LOCK;
            synchronized (object) {
                this.segments.add(seg);
            }
            if (matchFilename == null) {
                matchCount = 1;
                matchFilename = seg.parts.get((int)0).subFile.file.getName();
                continue;
            }
            if (matchFilename.equals(seg.parts.get((int)0).subFile.file.getName())) {
                ++matchCount;
                continue;
            }
            if (matchCount == 1) {
                System.out.println("[WholeFile] \t found " + matchCount + " match in " + matchFilename);
            } else {
                System.out.println("[WholeFile] \t found " + matchCount + " matches in " + matchFilename);
            }
            matchCount = 1;
            matchFilename = seg.parts.get((int)0).subFile.file.getName();
        }
        if (matchCount == 1) {
            System.out.println("[WholeFile] \t found " + matchCount + " match in " + matchFilename);
        } else {
            System.out.println("[WholeFile] \t found " + matchCount + " matches in " + matchFilename);
        }
        return true;
    }

    public static int indexOf(ByteArraySubIndexer subIndexer, byte[] outerArray, byte[] smallerArray, int afterOuterIndex) {
        int[] originsFor;
        int[] nArray = originsFor = subIndexer.getOriginsFor(smallerArray);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer index = nArray[i];
            if (index < afterOuterIndex || index + smallerArray.length > outerArray.length) continue;
            boolean found = true;
            for (int j = 0; j < smallerArray.length; ++j) {
                if (outerArray[index + j] == smallerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return index;
        }
        return -1;
    }

    public static int indexOf(byte[] outerArray, byte[] smallerArray, int afterOuterIndex) {
        for (int i = afterOuterIndex; i < outerArray.length - smallerArray.length + 1; ++i) {
            boolean found = true;
            if (i + smallerArray.length > outerArray.length) break;
            if (outerArray[i] != smallerArray[0] || outerArray[i + smallerArray.length - 1] != smallerArray[smallerArray.length - 1]) {
                found = false;
            } else {
                for (int j = 0; j < smallerArray.length; ++j) {
                    if (outerArray[i + j] == smallerArray[j]) continue;
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    class SearchJob
    implements Runnable {
        File partFileCandidate;
        boolean isLinux;
        boolean isLinuxArm;
        boolean isMac;
        boolean isWindows;
        boolean isAuxFile;
        boolean is64BitFile;
        boolean is32BitFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SearchJob(File partFileCandidate, boolean isLinux, boolean isLinuxArm, boolean isMac, boolean isWindows, boolean isAuxFile, boolean is64BitFile, boolean is32BitFile) {
            this.partFileCandidate = partFileCandidate;
            this.isLinux = isLinux;
            this.isLinuxArm = isLinuxArm;
            this.isMac = isMac;
            this.isWindows = isWindows;
            this.isAuxFile = isAuxFile;
            this.is64BitFile = is64BitFile;
            this.is32BitFile = is32BitFile;
            Object object = WholeFile.this.searchesLock;
            synchronized (object) {
                WholeFile.this.searchesStillToRun++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    WholeFile.this.searchPartFileCandidate(this.partFileCandidate, this.isLinux, this.isLinuxArm, this.isMac, this.isWindows, this.isAuxFile, this.is64BitFile, this.is32BitFile);
                }
                catch (IOException x) {
                    x.printStackTrace();
                    WholeFile.this.error = x;
                }
            }
            finally {
                Object object = WholeFile.this.searchesLock;
                synchronized (object) {
                    WholeFile.this.searchesStillToRun--;
                }
            }
        }
    }

    public static class WriteInstruction {
        byte[] source;
        int sourceOffset;
        int targetIndex;
        int length;

        public String toString() {
            return "WI: " + this.length + " bytes from " + this.sourceOffset + " to " + this.targetIndex;
        }
    }
}

