/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.compression.splitcompressor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import jwrapper.compression.splitcompressor.EmptySubFile;
import jwrapper.compression.splitcompressor.FilePart;
import jwrapper.compression.splitcompressor.FileSegment;
import jwrapper.compression.splitcompressor.WholeFile;
import utils.files.FileUtil;
import utils.progtools.Cache;
import utils.progtools.streams.ClearableBufferedInputStream;
import utils.progtools.streams.RandomAccessFileInputStream;

public class SubstitutionStreamer {
    private WholeFile[] wholeFiles = null;
    final Cache<String, byte[]> dataCache = new Cache("", 2);

    private static String getNiceName(File f) {
        return f.getParentFile().getName() + "/" + f.getName();
    }

    public SubstitutionStreamer(File deploy) {
        try {
            if (deploy.exists()) {
                this.wholeFiles = WholeFile.loadPackSpecFrom(deploy);
                System.out.println("[SubstitutionStreamer] Detected a compressed build");
            } else {
                this.wholeFiles = null;
            }
        }
        catch (IOException ex) {
            System.out.println("[SubstitutionStreamer] Detected an uncompressed build");
            this.wholeFiles = null;
        }
    }

    public void dumpDebug() {
        for (WholeFile file : this.wholeFiles) {
            file.dumpDebug();
        }
    }

    private WholeFile getWholeFileFor(File file) {
        if (this.wholeFiles == null) {
            return null;
        }
        for (WholeFile wholeFile : this.wholeFiles) {
            if (!wholeFile.file.equals(file)) continue;
            return wholeFile;
        }
        return null;
    }

    public InputStream getInputStreamFor(File file, long offset) throws IOException {
        WholeFile wholeFile = this.getWholeFileFor(file);
        if (wholeFile == null) {
            RandomAccessFileInputStream rafStream = new RandomAccessFileInputStream(file);
            rafStream.seek(offset);
            return new ClearableBufferedInputStream(rafStream, 8192);
        }
        return new BufferedInputStream(new SubstitutionInputStream(wholeFile, offset));
    }

    public long getLength(File file) {
        WholeFile wholeFile = this.getWholeFileFor(file);
        if (wholeFile != null) {
            return wholeFile.getOriginalFileSize();
        }
        return file.length();
    }

    class FilePartInputStream
    extends InputStream {
        private FilePart filePart;
        private File previousRAFFile;
        private InputStream partInputStream;
        private int readBytes = 0;

        FilePartInputStream() {
        }

        public void init(FilePart filePart) throws IOException {
            this.filePart = filePart;
            if (filePart.subFile instanceof EmptySubFile) {
                if (this.partInputStream != null) {
                    try {
                        this.partInputStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.partInputStream = null;
            } else {
                boolean reopen;
                boolean bl = reopen = this.partInputStream == null || !(this.partInputStream instanceof ClearableBufferedInputStream) || this.previousRAFFile == null || !this.previousRAFFile.equals(filePart.subFile.file);
                if (reopen) {
                    if (this.partInputStream != null) {
                        try {
                            this.partInputStream.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.previousRAFFile = filePart.subFile.file;
                    this.partInputStream = SubstitutionStreamer.this.getInputStreamFor(this.previousRAFFile, filePart.partIndex);
                } else {
                    ClearableBufferedInputStream bufferedStream = (ClearableBufferedInputStream)this.partInputStream;
                    RandomAccessFileInputStream rafis = (RandomAccessFileInputStream)bufferedStream.getInnerStream();
                    rafis.seek(filePart.partIndex);
                    bufferedStream.clearBuffer();
                }
                this.readBytes = 0;
            }
        }

        public long skip(long bytes) throws IOException {
            ClearableBufferedInputStream bufferedStream = (ClearableBufferedInputStream)this.partInputStream;
            RandomAccessFileInputStream rafis = (RandomAccessFileInputStream)bufferedStream.getInnerStream();
            rafis.seek((long)(this.filePart.partIndex + this.readBytes) + bytes);
            bufferedStream.clearBuffer();
            this.readBytes = (int)((long)this.readBytes + bytes);
            return bytes;
        }

        public int read() throws IOException {
            if (this.filePart.length == this.readBytes) {
                return -1;
            }
            if (this.partInputStream == null) {
                ++this.readBytes;
                return 0;
            }
            ++this.readBytes;
            return this.partInputStream.read();
        }

        public void close() throws IOException {
            try {
                if (this.partInputStream != null) {
                    this.partInputStream.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SegmentInputStream
    extends InputStream {
        private final FileSegment fileSegment;
        private final FilePartInputStream partInputStream;
        private LinkedList<FilePart> parts;

        public SegmentInputStream(FileSegment fileSegment, FilePartInputStream partInputStream) throws IOException {
            this.fileSegment = fileSegment;
            this.parts = this.getParts(fileSegment);
            this.partInputStream = partInputStream;
            partInputStream.init(this.parts.removeFirst());
        }

        public int getStartIndex() {
            return this.fileSegment.wholeFileSegmendStartIndex;
        }

        private LinkedList<FilePart> getParts(FileSegment currentSegment) {
            LinkedList<FilePart> parts = new LinkedList<FilePart>(currentSegment.parts);
            Collections.reverse(parts);
            return parts;
        }

        @Override
        public long skip(long bytesToSkip) throws IOException {
            return this.partInputStream.skip(bytesToSkip);
        }

        @Override
        public int read() throws IOException {
            if (this.partInputStream == null) {
                return -1;
            }
            int result = this.partInputStream.read();
            while (result == -1) {
                if (this.parts.size() == 0) {
                    return -1;
                }
                this.partInputStream.init(this.parts.removeFirst());
                result = this.partInputStream.read();
            }
            return result;
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }

    class SubstitutionInputStream
    extends InputStream {
        private final WholeFile wholeFile;
        private final FilePartInputStream commonPartInputStream;
        private SegmentInputStream segmentInputStream = null;
        private byte[] mainFileBytes;
        private int mainFilesIndex;
        private long totalReadBytes = 0L;
        private LinkedList<FileSegment> segments;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubstitutionInputStream(WholeFile wholeFile, long offset) throws IOException {
            this.wholeFile = wholeFile;
            this.segments = new LinkedList<FileSegment>(wholeFile.segments);
            this.commonPartInputStream = new FilePartInputStream();
            this.segmentInputStream = new SegmentInputStream(this.segments.removeFirst(), this.commonPartInputStream);
            Cache<String, byte[]> cache = SubstitutionStreamer.this.dataCache;
            synchronized (cache) {
                this.mainFileBytes = SubstitutionStreamer.this.dataCache.getFromCache(wholeFile.file.getPath());
                if (this.mainFileBytes == null) {
                    this.mainFileBytes = FileUtil.readFile(wholeFile.file);
                    SubstitutionStreamer.this.dataCache.addToCache(wholeFile.file.getPath(), this.mainFileBytes);
                }
            }
            this.totalReadBytes = 0L;
            while (this.totalReadBytes < offset) {
                if (this.segmentInputStream != null) {
                    long start = this.segmentInputStream.getStartIndex();
                    long end = start + (long)((SegmentInputStream)this.segmentInputStream).fileSegment.segmentLength;
                    if (end <= offset) {
                        this.totalReadBytes += (long)((SegmentInputStream)this.segmentInputStream).fileSegment.segmentLength;
                        this.segmentInputStream.close();
                        this.segmentInputStream = null;
                        if (this.segments.size() <= 0) continue;
                        FileSegment newSegment = this.segments.removeFirst();
                        this.segmentInputStream = new SegmentInputStream(newSegment, this.commonPartInputStream);
                        continue;
                    }
                    if (start < offset) {
                        this.mainFilesIndex = (int)((long)this.mainFilesIndex + (start - this.totalReadBytes));
                        this.segmentInputStream.skip(offset - start);
                        this.totalReadBytes = offset;
                        continue;
                    }
                    if (offset > start) continue;
                    this.mainFilesIndex = (int)((long)this.mainFilesIndex + (offset - this.totalReadBytes));
                    this.totalReadBytes = offset;
                    continue;
                }
                this.mainFilesIndex = (int)((long)this.mainFilesIndex + (offset - this.totalReadBytes));
                this.totalReadBytes = offset;
            }
        }

        public int read() throws IOException {
            if (this.totalReadBytes >= this.wholeFile.getOriginalFileSize()) {
                return -1;
            }
            if (this.segmentInputStream == null || this.totalReadBytes < (long)this.segmentInputStream.getStartIndex()) {
                return this.readFromMain();
            }
            int result = this.segmentInputStream.read();
            if (result == -1) {
                if (this.segments.size() == 0) {
                    return this.readFromMain();
                }
                this.segmentInputStream.close();
                this.segmentInputStream = new SegmentInputStream(this.segments.removeFirst(), this.commonPartInputStream);
                if (this.totalReadBytes < (long)this.segmentInputStream.getStartIndex()) {
                    return this.readFromMain();
                }
                result = this.segmentInputStream.read();
                ++this.totalReadBytes;
                return result;
            }
            ++this.totalReadBytes;
            return result;
        }

        public void close() throws IOException {
            try {
                this.commonPartInputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            super.close();
        }

        private int readFromMain() {
            ++this.totalReadBytes;
            return 0xFF & this.mainFileBytes[this.mainFilesIndex++];
        }
    }
}

