/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.compression.splitcompressor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import jwrapper.compression.splitcompressor.FileSegment;
import jwrapper.compression.splitcompressor.SubstitutionStreamer;
import jwrapper.compression.splitcompressor.WholeFile;
import utils.files.FileMD5;
import utils.files.FileUtil;
import utils.progtools.DataUtil;
import utils.progtools.OnDemandThreadPool;
import utils.stream.StreamUtils;
import utils.string.DirHash;
import utils.string.HexData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstitutionPacker {
    public static final boolean PARALLEL_SEARCHES = true;
    public static final int THREAD_COUNT = 48;
    public static final OnDemandThreadPool odp = new OnDemandThreadPool("SubstitutionPackerJobs", 48, 99999999, 5);
    private static final String[] coreapps = new String[]{"customer", "technician", "access"};
    private static long totalDeleted = 0L;
    public static final boolean DEBUG = false;

    private static boolean isCoreApp(String filename) {
        for (String s : coreapps) {
            if (!s.equals(filename)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCoreApp(File file) {
        if (file.isDirectory()) {
            return SubstitutionPacker.isCoreApp(file.getName());
        }
        return SubstitutionPacker.isCoreApp(file.getParentFile().getName());
    }

    private static boolean isCommon(File file) {
        if (file.isDirectory()) {
            return SubstitutionPacker.isCommon(file.getName());
        }
        return SubstitutionPacker.isCommon(file.getParentFile().getName());
    }

    private static boolean isCommon(String filename) {
        return filename.equals("common");
    }

    private static boolean isCompressedAlready(File file, Iterator<WholeFile> it) {
        while (it.hasNext()) {
            WholeFile wholeFile = it.next();
            if (!wholeFile.file.equals(file) || wholeFile.segments.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isPartOfCompressedFile(File file, Iterator<WholeFile> it) {
        return true;
    }

    private static boolean ignoreFile(File f) {
        File parent = f.getParentFile();
        String parentName = parent.getName();
        String parentParentName = parent.getParentFile().getName();
        String name = f.getName();
        return name.endsWith(".js") || name.endsWith(".css") || name.equals(".DS_Store") || parentName.equals("html") || parentName.equals("legacy") || parentParentName.equals("lightweightfiles") || parentName.equals("lightweightfiles") || parentName.equals("translations");
    }

    private static String getNiceName(File f) {
        return f.getParentFile().getName() + "/" + f.getName();
    }

    public static boolean needsExtracting(File folder) {
        return WholeFile.needsExtracting(folder);
    }

    private static ArrayList<File> filterOutCommonAndAppFiles(ArrayList<File> allFiles, File appDir) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : allFiles) {
            if (!f.getParentFile().getName().equals("common") && !f.getParentFile().equals(appDir)) continue;
            files.add(f);
        }
        return files;
    }

    private static ArrayList<File> filterFilesInApp(ArrayList<File> allFiles, File appDir) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : allFiles) {
            if (f.getParentFile().equals(appDir)) continue;
            files.add(f);
        }
        return files;
    }

    public static boolean isPartOfAnother(File partFile, WholeFile[] existingWholeFiles) {
        for (WholeFile wholeFile : existingWholeFiles) {
            if (!wholeFile.containsPartFile(partFile)) continue;
            return true;
        }
        return false;
    }

    private static void phase1_apps(File[] allFiles, TreeMap<File, WholeFile> fileToWholeFileMap) throws IOException {
        WholeFile wholeFile;
        ArrayList<File> targetCandidates = new ArrayList<File>();
        ArrayList<File> partFileCandidates = new ArrayList<File>();
        SubstitutionPacker.populateWholePartList(allFiles, targetCandidates, partFileCandidates);
        for (File wholeFileCandidate : targetCandidates) {
            wholeFile = SubstitutionPacker.getOrInitWholeFile(wholeFileCandidate, fileToWholeFileMap);
            wholeFile.searchForSubstitutions(SubstitutionPacker.filterOutCommonAndAppFiles(partFileCandidates, wholeFile.file.getParentFile()));
        }
        for (File wholeFileCandidate : targetCandidates) {
            wholeFile = SubstitutionPacker.getOrInitWholeFile(wholeFileCandidate, fileToWholeFileMap);
            wholeFile.waitUntilFinished();
            if (wholeFile.segments.size() <= 0) continue;
            partFileCandidates.remove(wholeFile.file);
        }
    }

    private static void phase2_jres(File[] allFiles, TreeMap<File, WholeFile> fileToWholeFileMap) throws IOException {
        WholeFile wholeFile;
        ArrayList<File> targetCandidates = new ArrayList<File>();
        ArrayList<File> partFileCandidates = new ArrayList<File>();
        SubstitutionPacker.populatePartialPartList(allFiles, targetCandidates, partFileCandidates);
        for (WholeFile wholeFile2 : fileToWholeFileMap.values()) {
            if (wholeFile2.segments.size() <= 0) continue;
            partFileCandidates.remove(wholeFile2.file);
        }
        for (File wholeFileCandidate : targetCandidates) {
            wholeFile = SubstitutionPacker.getOrInitWholeFile(wholeFileCandidate, fileToWholeFileMap);
            wholeFile.searchForSubstitutions(SubstitutionPacker.filterOutCommonAndAppFiles(partFileCandidates, wholeFile.file.getParentFile()));
        }
        for (File wholeFileCandidate : targetCandidates) {
            wholeFile = SubstitutionPacker.getOrInitWholeFile(wholeFileCandidate, fileToWholeFileMap);
            wholeFile.waitUntilFinished();
            if (wholeFile.segments.size() <= 0) continue;
            System.out.println("[SubstitutionPacker] Removing " + wholeFile.file.getName() + " from part list");
            partFileCandidates.remove(wholeFile.file);
        }
    }

    private static void phase3_appProfiles(File[] allFiles, TreeMap<File, WholeFile> fileToWholeFileMap) throws IOException {
        WholeFile wholeFile;
        ArrayList<File> targetCandidates = new ArrayList<File>();
        ArrayList<File> partFileCandidates = new ArrayList<File>();
        SubstitutionPacker.populateCrossAppLists(allFiles, targetCandidates, partFileCandidates);
        for (WholeFile wholeFile2 : fileToWholeFileMap.values()) {
            if (wholeFile2.segments.size() <= 0) continue;
            targetCandidates.remove(wholeFile2.file);
        }
        for (File wholeFileCandidate : targetCandidates) {
            wholeFile = SubstitutionPacker.getOrInitWholeFile(wholeFileCandidate, fileToWholeFileMap);
            wholeFile.searchForSubstitutions(partFileCandidates);
        }
        for (File wholeFileCandidate : targetCandidates) {
            wholeFile = SubstitutionPacker.getOrInitWholeFile(wholeFileCandidate, fileToWholeFileMap);
            wholeFile.waitUntilFinished();
            if (wholeFile.segments.size() <= 0) continue;
            partFileCandidates.remove(wholeFile.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WholeFile[] pack(File folder) throws IOException {
        System.out.println("[SubsitutionPacker] Packing " + folder.getName());
        long start = System.currentTimeMillis();
        File[] files = FileUtil.deepList(folder);
        TreeMap<File, WholeFile> fileToWholeFileMap = new TreeMap<File, WholeFile>();
        SubstitutionPacker.phase1_apps(files, fileToWholeFileMap);
        SubstitutionPacker.phase2_jres(files, fileToWholeFileMap);
        SubstitutionPacker.phase3_appProfiles(files, fileToWholeFileMap);
        long deleteStart = System.currentTimeMillis();
        final DeleteJobs deleteJobs = new DeleteJobs();
        for (final WholeFile wholeFile : fileToWholeFileMap.values()) {
            DeleteJobs deleteJobs2 = deleteJobs;
            synchronized (deleteJobs2) {
                ++deleteJobs.count;
            }
            odp.runAsync(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        try {
                            wholeFile.deleteMatchedSegments();
                        }
                        catch (IOException e) {
                            deleteJobs.error = e;
                            e.printStackTrace();
                        }
                        totalDeleted = totalDeleted + wholeFile.totalDeleted;
                        System.out.println("[" + wholeFile.file.getName() + "] Deleted " + wholeFile.totalDeleted + " so remainder is " + wholeFile.file.length());
                    }
                    finally {
                        DeleteJobs deleteJobs2 = deleteJobs;
                        synchronized (deleteJobs2) {
                            --deleteJobs.count;
                        }
                    }
                }
            });
        }
        DeleteJobs deleteJobs3 = deleteJobs;
        synchronized (deleteJobs3) {
            while (deleteJobs.count > 0L) {
                try {
                    deleteJobs.wait(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (deleteJobs.error != null) {
            throw new IOException(deleteJobs.error);
        }
        System.out.println(System.currentTimeMillis() - deleteStart + "ms to delete all data.");
        ArrayList<WholeFile> list = new ArrayList<WholeFile>();
        list.addAll(fileToWholeFileMap.values());
        System.out.println("[SubsitutionPacker] Pack complete. Took " + (System.currentTimeMillis() - start) + "ms to save " + totalDeleted);
        WholeFile[] result = list.toArray(new WholeFile[0]);
        WholeFile.savePackSpecTo(result, folder);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(File folder) throws IOException {
        try {
            long start = System.currentTimeMillis();
            WholeFile[] wholeFiles = WholeFile.loadPackSpecFrom(folder);
            if (wholeFiles == null) {
                return;
            }
            ArrayList reversedWholeFileList = new ArrayList();
            Collections.addAll(reversedWholeFileList, wholeFiles);
            Collections.reverse(reversedWholeFileList);
            for (WholeFile wholeFile : reversedWholeFileList) {
                wholeFile.dumpDebug();
            }
            System.out.println();
            System.out.println();
            for (WholeFile wholeFile : reversedWholeFileList) {
                wholeFile.unpackSegments();
            }
            WholeFile.deletePackSpecFrom(folder);
            System.out.println("[SubsitutionPacker] Unpack took " + (System.currentTimeMillis() - start) + "ms");
        }
        finally {
            FileSegment.clearCachedFile();
        }
    }

    static String getChildPath(File parent, File child) {
        if (parent.equals(child)) {
            return "";
        }
        String path = SubstitutionPacker.getChildPath(parent, child.getParentFile());
        if (path.length() > 0) {
            path = path + "/";
        }
        return path + child.getName();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 10) {
            System.out.println("UNPACKO");
            File deploy = new File("/Users/gchristelis/Desktop/DEPLOY");
            SubstitutionPacker.unpack(deploy);
            long newHash = SubstitutionPacker.getHashOf(deploy);
            System.out.println(newHash);
            System.exit(0);
        } else if (args.length == 0) {
            File deployOrig = new File("/Users/gchristelis/Desktop/DEPLOY-uncompressed");
            File deploy = new File("/Users/gchristelis/Desktop/DEPLOY");
            File deployCompressed = new File("/Users/gchristelis/Desktop/DEPLOY-compressed");
            FileUtil.deleteDir(deploy);
            FileUtil.copyFileOrDir(deployOrig, deploy);
            long originalHash = SubstitutionPacker.getHashOf(deploy);
            System.out.println("[SubstitutionPacker] Source has a hash of " + originalHash);
            SubstitutionPacker.pack(deploy);
            SubstitutionStreamer streamer = new SubstitutionStreamer(deploy);
            File[] allFiles = FileUtil.deepList(deploy);
            long allStart = 0L;
            for (File compressed : allFiles) {
                if (compressed.getName().equals(".DS_Store")) continue;
                System.out.print("Verifying " + compressed.getName() + " ... ");
                long start = System.currentTimeMillis();
                byte[] result = StreamUtils.readAll(streamer.getInputStreamFor(compressed, 0L));
                long end = System.currentTimeMillis();
                allStart += end - start;
                String path = compressed.getPath().substring(deploy.getPath().length());
                File orig = new File(deployOrig, path);
                if (!orig.exists()) {
                    System.out.println("The original of " + orig.getName() + " does not exist. Skipping...");
                    continue;
                }
                byte[] origMD5 = FileMD5.getMD5Sum(orig);
                byte[] newMD5 = FileMD5.getMD5Sum(result);
                if (!HexData.byteArrayToHexString(origMD5).equals(HexData.byteArrayToHexString(newMD5))) {
                    System.out.println("MISMATCH:" + result.length + " vs orig:" + orig.length());
                    byte[] origData = FileUtil.readFile(orig);
                    for (int i = 0; i < result.length; ++i) {
                        if (result[i] == origData[i]) continue;
                        System.out.println(i);
                        System.exit(1);
                    }
                    continue;
                }
                System.out.println("\tVerified! in (" + (end - start) + "ms)");
            }
            System.out.println("All Done! - " + allStart);
            System.exit(1);
            File compressed = new File(deploy, "technician/SimpleHelp Technician-macos32-offline.dmg");
            File orig = new File(deployOrig, "technician/SimpleHelp Technician-macos32-offline.dmg");
            long l = System.currentTimeMillis();
        } else {
            File deploy = new File(args[0]);
            SubstitutionPacker.pack(deploy);
        }
    }

    private static long getHashOf(File deploy) throws IOException {
        long result = 0L;
        File[] files = deploy.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isDirectory()) continue;
                result += DirHash.hashLong(f, false);
            }
        }
        return result;
    }

    private static void populateWholePartList(File[] files, ArrayList<File> targetCandidates, ArrayList<File> partFileCandidates) {
        for (File f : files) {
            if (SubstitutionPacker.ignoreFile(f)) continue;
            String name = f.getName();
            boolean isCommon = SubstitutionPacker.isCommon(f);
            boolean isLargeEnough = f.length() > 3000L;
            boolean isJRE = name.contains("JRE-");
            if (isLargeEnough && !isCommon && !isJRE && (name.contains("-windows") || name.contains("-linux") || name.contains("-macos"))) {
                targetCandidates.add(f);
                continue;
            }
            if (!isLargeEnough || name.endsWith(".tar") || name.endsWith(".exe") || name.endsWith(".dmg")) continue;
            partFileCandidates.add(f);
        }
    }

    private static void populateCrossAppLists(File[] files, ArrayList<File> targetCandidates, ArrayList<File> partFileCandidates) {
        for (File f : files) {
            boolean isLargeEnough;
            if (SubstitutionPacker.ignoreFile(f)) continue;
            boolean isCommon = SubstitutionPacker.isCommon(f);
            boolean bl = isLargeEnough = f.length() > 3000L;
            if (isCommon || !isLargeEnough) continue;
            if (SubstitutionPacker.isCoreApp(f)) {
                partFileCandidates.add(f);
                continue;
            }
            targetCandidates.add(f);
        }
    }

    private static void populatePartialPartList(File[] files, ArrayList<File> targetCandidates, ArrayList<File> partFileCandidates) {
        for (File f : files) {
            if (SubstitutionPacker.ignoreFile(f)) continue;
            boolean isLargeEnough = f.length() > 3000L;
            boolean isJRE = f.getName().contains("JRE-");
            if (!isLargeEnough || !isJRE) continue;
            targetCandidates.add(f);
            partFileCandidates.add(f);
        }
    }

    private static WholeFile getOrInitWholeFile(File file, TreeMap<File, WholeFile> fileToWholeFileMap) {
        WholeFile wholeFile = fileToWholeFileMap.get(file);
        if (wholeFile == null) {
            wholeFile = new WholeFile();
            wholeFile.file = file;
            wholeFile.originalFileSize = file.length();
            fileToWholeFileMap.put(file, wholeFile);
        }
        return wholeFile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Range
    implements Comparable<Range> {
        public int start;
        public int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "[ " + this.start + " -> " + this.end + " )";
        }

        public boolean equals(Object o) {
            Range r = (Range)o;
            return r.start == this.start && r.end == this.end;
        }

        @Override
        public int compareTo(Range o) {
            if (o.start == this.start) {
                return DataUtil.compare(this.end, o.end);
            }
            return DataUtil.compare(this.start, o.start);
        }
    }

    static class MemoryMonitor
    extends Thread {
        long max = 0L;

        MemoryMonitor() {
        }

        public void run() {
            Runtime r = Runtime.getRuntime();
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("[MemoryMonitor] Used: " + (r.totalMemory() - r.freeMemory()) / 0x100000L);
            }
        }
    }

    static class DeleteJobs {
        long count;
        Throwable error = null;

        DeleteJobs() {
        }
    }
}

