/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.compression.splitcompressor;

import java.util.Random;
import utils.progtools.time.TimeHierarchy;

public class ByteArraySubIndexer {
    private final int depth;
    private final byte[] source;
    private final IndexNode root = new IndexNode(0);
    TimeHierarchy times = new TimeHierarchy();

    public ByteArraySubIndexer(byte[] source, int depth) {
        this.depth = depth;
        this.source = source;
        this.index();
    }

    private void index() {
        this.times.start("index");
        for (int i = 0; i < this.source.length - this.depth; ++i) {
            if (i % 100000 == 0) {
                System.out.println(i);
            }
            IndexNode node = this.root.getNextIndexNode(this.source[i]);
            this.index(node, i, i + 1, this.depth - 1);
        }
        this.times.stop("index");
    }

    private void index(IndexNode parent, int origin, int start, int length) {
        while (length > 0) {
            parent = parent.getNextIndexNode(this.source[start]);
            --length;
            ++start;
        }
        if (parent != null) {
            this.times.start("addFinalIndex");
            parent.addFinalIndex(origin);
            this.times.stop("addFinalIndex");
        }
    }

    public static void main(String[] args) {
        Random r = new Random();
        byte[] testSource = new byte[0x100000];
        r.nextBytes(testSource);
        ByteArraySubIndexer indexer = new ByteArraySubIndexer(testSource, 1);
        System.out.println(indexer.times.dumpStats());
    }

    public int[] getOriginsFor(byte[] search) {
        return this.getOriginsFor(search, this.root, 0);
    }

    private int[] getOriginsFor(byte[] search, IndexNode parent, int searchIndex) {
        if (searchIndex == search.length) {
            return parent.finalNodes;
        }
        IndexNode nextIndexNodeOrNull = parent.getNextIndexNodeOrNull(search[searchIndex]);
        if (nextIndexNodeOrNull == null) {
            return null;
        }
        return this.getOriginsFor(search, nextIndexNodeOrNull, searchIndex + 1);
    }

    class IndexNode {
        private byte value;
        private IndexNode[] next = null;
        private int[] finalNodes = null;
        private int finalNodesLength = 0;

        public IndexNode(byte value) {
            this.value = value;
        }

        public IndexNode getNextIndexNode(byte value) {
            if (this.next == null) {
                this.next = new IndexNode[256];
            }
            if (this.next[0xFF & value] == null) {
                this.next[0xFF & value] = new IndexNode(value);
            }
            return this.next[0xFF & value];
        }

        public IndexNode getNextIndexNodeOrNull(byte value) {
            if (this.next == null) {
                return null;
            }
            return this.next[0xFF & value];
        }

        public void addFinalIndex(int origin) {
            if (this.finalNodes == null) {
                this.finalNodes = new int[5];
                this.finalNodesLength = 0;
            }
            if (this.finalNodesLength == this.finalNodes.length) {
                int[] newFinal = new int[this.finalNodes.length * 2];
                System.arraycopy(this.finalNodes, 0, newFinal, 0, this.finalNodes.length);
                this.finalNodes = newFinal;
            }
            this.finalNodes[this.finalNodesLength++] = origin;
        }
    }
}

