/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.compression.splitcompressor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import utils.files.AtomicFileOutputStream;

public class ByteArrayStruct {
    LinkedList<byte[]> arrayList = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) throws IOException {
        AtomicFileOutputStream fout = new AtomicFileOutputStream(file);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        try {
            for (byte[] bArray : this.arrayList) {
                bout.write(bArray);
            }
        }
        finally {
            bout.close();
        }
    }

    public long getLength() {
        long size = 0L;
        for (byte[] bArray : this.arrayList) {
            size += (long)bArray.length;
        }
        return size;
    }

    public void insert(byte[] newData, int offset) {
        long start = this.getLength();
        int currentIndex = 0;
        for (int i = 0; i < this.arrayList.size(); ++i) {
            byte[] arr = this.arrayList.get(i);
            if (offset >= currentIndex && offset < currentIndex + arr.length) {
                if (offset == currentIndex) {
                    this.arrayList.add(i, newData);
                } else if (offset == currentIndex + arr.length - 1) {
                    this.arrayList.add(i + 1, newData);
                } else {
                    int inArrayOffset = offset - currentIndex;
                    byte[] part1 = new byte[inArrayOffset];
                    byte[] part2 = newData;
                    byte[] part3 = new byte[arr.length - inArrayOffset];
                    System.arraycopy(arr, 0, part1, 0, inArrayOffset);
                    System.arraycopy(arr, inArrayOffset, part3, 0, arr.length - inArrayOffset);
                    this.arrayList.set(i, part3);
                    this.arrayList.add(i, part2);
                    this.arrayList.add(i, part1);
                }
                return;
            }
            currentIndex += arr.length;
        }
        this.arrayList.add(newData);
    }
}

