/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.archive;

import bcutil.BCUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import jwrapper.SzUtil;
import jwrapper.XZUtil;
import jwrapper.archive.ArchiveSignature;
import jwrapper.archive.ArchiveSpecialBlock;
import jwrapper.archive.FileStripper;
import jwrapper.crypt.JarProtector;
import jwrapper.pack200.Pack200Compressor;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import utils.files.FileUtil;
import utils.jarbuilder.utils.JarClassVersionChecker;
import utils.progtools.OnDemandThreadPool;
import utils.stream.CFriendlyStreamUtils;
import utils.stream.OpenByteArrayOutputStream;
import utils.stream.StreamPiper;
import utils.switches.Switches;
import utils.sync.UnqueuedSemaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Archive {
    public static final int TYPE_FILE = 0;
    public static final int TYPE_FOLDER = 1;
    public static final int TYPE_FILE_P200 = 2;
    public static final String ASB_PREFIX = "jwArcSpBlock_";
    public static final String ASB_DIGSIG1 = "DigitalSignature1";
    public static final JarClassVersionChecker versionChecker = new JarClassVersionChecker();
    boolean pack200allowed = true;
    long preP200;
    long postP200;
    File dest;
    OutputStream out;
    private String[] filesToKeep;
    private String[] filesToNotPack200;
    private int pack200Effort;
    private byte[] buf = new byte[200000];
    static long totalCompressionTime = 0L;
    static long totalArchiveSigningTime = 0L;
    static PrintStream always;
    private static boolean THREADED_P200;
    private static OpenByteArrayOutputStream compressbuf;

    public Archive(File dest, String[] filesToKeep, String[] filesToNotPack200, int pack200Effort) throws IOException {
        this.filesToKeep = filesToKeep;
        this.filesToNotPack200 = filesToNotPack200;
        this.dest = dest;
        this.pack200Effort = pack200Effort;
        this.out = new BufferedOutputStream(new FileOutputStream(dest), 10240);
    }

    public static long getTotalLZMATime() {
        return totalCompressionTime;
    }

    public static long getTotalArchiveSigningTime() {
        return totalArchiveSigningTime;
    }

    public void setPack200Allowed(boolean b) {
        this.pack200allowed = b;
    }

    public static void mergeAndFinishCompressed(Archive[] archives, File outputFile, boolean compression, AsymmetricCipherKeyPair signKeys, OnDemandThreadPool odp) throws Exception {
        Archive.concatenateBeforeFinish(archives, outputFile);
        if (signKeys != null) {
            always.println("NOTE: Signing");
            long start = System.currentTimeMillis();
            Archive.signSingle(outputFile, signKeys);
            long signDiff = System.currentTimeMillis() - start;
            always.println("[Archive] Signed. (took " + signDiff + " / " + (totalArchiveSigningTime += signDiff) + ")");
        }
        if (compression) {
            always.println("NOTE: Compressing " + outputFile);
        } else {
            always.println("NOTE: NOT Compressing " + outputFile);
        }
        long len = outputFile.length();
        long start = System.currentTimeMillis();
        if (!Switches.JW_skipLZMAForNoCompression || compression) {
            if (odp != null && Switches.JW_parallel_LZMA) {
                final File myOutputFile = outputFile;
                final boolean myCompression = compression;
                odp.runAsync(new Runnable(){

                    public void run() {
                        try {
                            SzUtil.compress(myOutputFile, myCompression);
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                });
            } else {
                SzUtil.compress(outputFile, compression);
            }
        }
        long diff = System.currentTimeMillis() - start;
        long nlen = outputFile.length();
        always.println("[Archive] Post processing " + outputFile);
        always.println("[Archive] L2 - compressed from " + len + " to " + nlen + " (took " + diff + " / " + (totalCompressionTime += diff) + ")");
    }

    public void cancelAndDelete() {
        try {
            this.out.close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        always.println("Deleting archive: " + this.dest);
        this.dest.delete();
    }

    public void finishAndCompress(boolean compression, AsymmetricCipherKeyPair signKeys, OnDemandThreadPool odp) throws Exception {
        this.out.close();
        if (signKeys != null) {
            always.println("[Archive] NOTE: Signing");
            long start = System.currentTimeMillis();
            Archive.signSingle(this.dest, signKeys);
            long signDiff = System.currentTimeMillis() - start;
            always.println("[Archive] Signed. (took " + signDiff + " / " + (totalArchiveSigningTime += signDiff) + ")");
        }
        if (compression) {
            always.println("[Archive] NOTE: Compressing");
        } else {
            always.println("[Archive] NOTE: NOT Compressing");
        }
        long len = this.dest.length();
        long start = System.currentTimeMillis();
        if (!Switches.JW_skipLZMAForNoCompression || compression) {
            final File myDest = this.dest;
            final boolean myCompression = compression;
            if (odp != null && Switches.JW_parallel_LZMA) {
                odp.runAsync(new Runnable(){

                    public void run() {
                        try {
                            SzUtil.compress(myDest, myCompression);
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                });
            } else {
                SzUtil.compress(this.dest, compression);
            }
        }
        long diff = System.currentTimeMillis() - start;
        long nlen = this.dest.length();
        always.println("[Archive] Post processing " + this.dest);
        always.println("[Archive] P2 - compressed from " + this.preP200 + " to " + this.postP200);
        always.println("[Archive] L2 - compressed from " + len + " to " + nlen + " (took " + diff + " / " + (totalCompressionTime += diff) + ")");
    }

    public static void setAlwaysPrintstream(PrintStream always) {
        Archive.always = always;
    }

    public ArrayList<String> addFile(File f, String relpath) throws IOException {
        return this.addFile(f, relpath, (JarProtector)null);
    }

    public ArrayList<String> addFile(File f, String relpath, JarProtector crypt) throws IOException {
        return this.addFile(f, relpath, null, crypt);
    }

    public ArrayList<String> addFile(File f, String relpath, FileStripper[] fs) throws IOException {
        return this.addFile(f, relpath, fs, null);
    }

    public ArrayList<String> addFile(File f, String relpath, FileStripper[] fs, JarProtector crypt) throws IOException {
        if (fs == null) {
            fs = new FileStripper[]{};
        }
        long[] p200info = new long[2];
        ArrayList tempjars = new ArrayList();
        ArrayList<String> allFiles = new ArrayList<String>();
        Archive.addFileToStream(this.dest.getName(), this.pack200allowed, p200info, this.out, this.buf, f, relpath, fs, tempjars, this.filesToKeep, this.filesToNotPack200, this.pack200Effort, crypt, allFiles);
        if (THREADED_P200) {
            int i;
            UnqueuedSemaphore sem = new UnqueuedSemaphore(Runtime.getRuntime().availableProcessors() + 1);
            ArrayList<P2Thread> list = new ArrayList<P2Thread>();
            for (i = 0; i < tempjars.size(); ++i) {
                System.out.println("Processing postponed file: " + tempjars.get(i));
                Object[] all = (Object[])tempjars.get(i);
                String jrelpath = (String)all[0];
                File jf = (File)all[1];
                P2Thread thread = new P2Thread(sem, i, jf, jrelpath, fs);
                thread.start();
                list.add(thread);
            }
            for (i = 0; i < list.size(); ++i) {
                P2Thread thread = (P2Thread)list.get(i);
                try {
                    thread.join();
                }
                catch (InterruptedException xx) {
                    IOException fail = new IOException("Failed to join with p2 processing thread");
                    fail.initCause(xx);
                    throw fail;
                }
                System.out.println("Adding postponed file: " + thread.jrelpath);
                try {
                    thread.copyTo(this.out, this.buf, p200info);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new IOException("Failed to add postponed file to archive because of previous failure " + t);
                }
            }
        } else {
            for (int i = 0; i < tempjars.size(); ++i) {
                Object[] all = (Object[])tempjars.get(i);
                String jrelpath = (String)all[0];
                File jf = (File)all[1];
                System.out.println("Adding postponed file: " + jrelpath + ", " + jf.getAbsolutePath());
                Archive.addFileToStream(this.dest.getName(), this.pack200allowed, p200info, this.out, this.buf, jf, jrelpath, fs, null, this.filesToKeep, this.filesToNotPack200, this.pack200Effort, crypt, allFiles);
            }
        }
        this.preP200 += p200info[0];
        this.postP200 += p200info[1];
        for (FileStripper f1 : fs) {
            System.out.println("Stripping " + f1.getName() + " saved " + f1.getStrippedTotal() + " bytes");
        }
        return allFiles;
    }

    private static boolean filenameIncludedIn(String path, String[] matches) {
        if (matches == null) {
            return false;
        }
        path = path.toLowerCase().replace('\\', '/');
        for (int i = 0; i < matches.length; ++i) {
            String match = matches[i].toLowerCase().replace('\\', '/');
            if (!path.endsWith(match)) continue;
            return true;
        }
        return false;
    }

    public static void addFileToStream(String arcname, OutputStream out, byte[] buf, File f, String relpath, FileStripper[] fs, String[] filesToKeep, String[] filesToNotPack200, int pack200Effort) throws IOException {
        long[] tmp = new long[2];
        Archive.addFileToStream(arcname, true, tmp, out, buf, f, relpath, fs, null, filesToKeep, filesToNotPack200, pack200Effort, null, new ArrayList<String>());
    }

    public static void concatenateBeforeFinish(Archive[] archives, File outFile) throws IOException {
        always.println("[Archive] Merging into " + outFile);
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(outFile));
        for (Archive archive : archives) {
            archive.out.flush();
            always.println("[Archive] Merging " + archive.dest.length() + " from " + archive.dest);
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(archive.dest));
            StreamPiper.pipe(bin, bout, true, false, false);
            bin.close();
        }
        bout.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signSingle(File archive, AsymmetricCipherKeyPair rsakeys) throws IOException {
        int len = (int)archive.length();
        System.out.println("[Archive] Signing " + archive + " from 0 to " + len);
        if (archive.length() > Integer.MAX_VALUE) {
            throw new IOException("JW Signatures currently only support files up to 2147483647 bytes");
        }
        byte[] archiveData = new byte[len];
        DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(archive)));
        din.readFully(archiveData);
        din.close();
        byte[] signature = BCUtil.createSignature(archiveData, BCUtil.getPrivateKey(rsakeys));
        String signatureHex = BCUtil.getSignatureToHex(signature);
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(archive, true));
        try {
            ArchiveSpecialBlock asb = new ArchiveSpecialBlock(ASB_DIGSIG1);
            CFriendlyStreamUtils.writeInt(asb, len);
            CFriendlyStreamUtils.writeString(asb, signatureHex);
            asb.writeSpecialBlockTo(fout);
        }
        finally {
            FileUtil.robustClose(fout);
        }
        if (!Switches.JW_noVerifyArchiveSignatures) {
            try {
                if (!Archive.printArchive(archive, BCUtil.getPublicKeyToHex(rsakeys), false)) {
                    throw new IOException("Unable to verify signature");
                }
            }
            catch (Exception x) {
                x.printStackTrace(always);
                throw new IOException("Unable to verify signature");
            }
        }
    }

    private static void addFileToStream(String arcname, boolean pack200allowed, long[] p200, OutputStream out, byte[] buf, File f, String relpath, FileStripper[] fs, ArrayList tempjars, String[] filesToKeep, String[] filesToNotPack200, int pack200Effort, JarProtector crypt, ArrayList<String> allFiles) throws IOException {
        boolean usePack200;
        if (pack200Effort == 0) {
            pack200allowed = false;
        }
        PrintStream outmain = System.out;
        if (always != null) {
            outmain = always;
        }
        for (int i = 0; i < fs.length; ++i) {
            if (!fs[i].canLeaveOutFile(f, filesToKeep)) continue;
            fs[i].addToStrippedTotal(f.length());
            System.out.println("SKIPPING file (" + f.length() + ") " + f);
            return;
        }
        if ((relpath = relpath.replace('\\', '/')).startsWith("/")) {
            throw new IOException("Illegal relative path: " + relpath);
        }
        if (relpath.startsWith("./")) {
            throw new IOException("Illegal relative path: " + relpath);
        }
        if (relpath.startsWith("../")) {
            throw new IOException("Illegal relative path: " + relpath);
        }
        if (relpath.endsWith("/")) {
            relpath = relpath.substring(0, relpath.length() - 1);
        }
        if (f.isDirectory()) {
            outmain.println("[Archive][" + arcname + "] Adding folder (" + f.length() + ") (" + relpath + ") " + f);
        } else {
            outmain.println("[Archive][" + arcname + "] Adding file (" + f.length() + ") (" + relpath + ") " + f);
        }
        if (f.isDirectory()) {
            CFriendlyStreamUtils.writeInt(out, 1);
            CFriendlyStreamUtils.writeString(out, relpath);
            System.out.println("Adding FOLDER (1) " + relpath);
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Archive.addFileToStream(arcname, pack200allowed, p200, out, buf, files[i], relpath + "/" + files[i].getName(), fs, tempjars, filesToKeep, filesToNotPack200, pack200Effort, crypt, allFiles);
            }
            return;
        }
        allFiles.add(relpath);
        p200[0] = p200[0] + f.length();
        if (pack200allowed) {
            boolean isJar = relpath.toLowerCase().endsWith(".jar");
            if (isJar) {
                boolean containsClass = Pack200Compressor.jarContainsAClass(f);
                boolean filenameOK = !Archive.filenameIncludedIn(relpath, filesToNotPack200);
                boolean bl = usePack200 = containsClass && filenameOK;
                if (!containsClass) {
                    outmain.println("[Archive] Did not pack200 " + relpath + " since the jar is empty");
                } else if (!filenameOK) {
                    outmain.println("[Archive] Did not pack200 " + relpath + " it was specifically excluded");
                } else {
                    outmain.println("[Archive] Will pack200 " + relpath);
                }
            } else {
                usePack200 = false;
            }
        } else {
            usePack200 = false;
        }
        if (crypt != null) {
            usePack200 = false;
        }
        if (f.exists() && f.length() > 0L) {
            try {
                versionChecker.check(f);
            }
            catch (ZipException x) {
                outmain.println("[Archive] Unable to check class versions on " + f + " :" + x);
                x.printStackTrace();
            }
        }
        if (usePack200) {
            if (tempjars != null) {
                tempjars.add(new Object[]{relpath, f});
                return;
            }
            CFriendlyStreamUtils.writeInt(out, 2);
            CFriendlyStreamUtils.writeString(out, relpath);
            long MAX_MEM = 10240000L;
            if (f.length() > MAX_MEM) {
                File compressTo = File.createTempFile("JWArchiveCompression", "p2");
                BufferedOutputStream cout = new BufferedOutputStream(new FileOutputStream(compressTo), 10240);
                Pack200Compressor.initForEffort(pack200Effort).compressFileToOutputStream(new JarFile(f), cout);
                try {
                    ((OutputStream)cout).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CFriendlyStreamUtils.writeLong(out, compressTo.length());
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(compressTo), 10240);
                int n = 0;
                while (n != -1) {
                    n = ((InputStream)in).read(buf);
                    if (n <= 0) continue;
                    out.write(buf, 0, n);
                }
                ((InputStream)in).close();
                p200[1] = p200[1] + compressTo.length();
                compressTo.delete();
            } else {
                compressbuf.reset();
                Pack200Compressor.initMaxCompression().compressFileToOutputStream(new JarFile(f), compressbuf);
                CFriendlyStreamUtils.writeLong(out, (long)compressbuf.size());
                out.write(compressbuf.getByteArray(), 0, compressbuf.size());
                p200[1] = p200[1] + (long)compressbuf.size();
            }
            System.out.println("Added P200-FILE " + relpath + " (" + compressbuf.size() + ")");
        } else {
            CFriendlyStreamUtils.writeInt(out, 0);
            CFriendlyStreamUtils.writeString(out, relpath);
            if (crypt != null) {
                byte[] enc = crypt.encryptFile(f, relpath, true);
                CFriendlyStreamUtils.writeLong(out, (long)enc.length);
                System.out.println("Added PROTECTED FILE " + relpath + " (" + f.length() + " -> " + enc.length + ")");
                out.write(enc, 0, enc.length);
                System.out.println("Wrote PROTECTED FILE " + relpath + " (" + enc.length + ")");
                p200[1] = p200[1] + (long)enc.length;
            } else {
                CFriendlyStreamUtils.writeLong(out, f.length());
                System.out.println("Added FILE " + relpath + " (" + f.length() + ")");
                int NB = 0;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f), 10240);
                int n = 0;
                while (n != -1) {
                    n = ((InputStream)in).read(buf);
                    if (n <= 0) continue;
                    out.write(buf, 0, n);
                    NB += n;
                }
                ((InputStream)in).close();
                System.out.println("Wrote FILE " + relpath + " (" + NB + ")");
                p200[1] = p200[1] + f.length();
            }
        }
    }

    private static void skip(InputStream in, long bytes) throws IOException {
        for (long N = 0L; N < bytes; ++N) {
            in.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enumerateArchive(File f, boolean decompress, ArchiveListener listener) throws Exception {
        boolean decompressed = false;
        if (decompress) {
            File decompressedFile = new File(f.getAbsolutePath() + ".decompressed");
            try {
                f = XZUtil.decompress(f, decompressedFile);
                decompressed = true;
            }
            catch (EOFException ex) {
                decompressedFile.delete();
                System.out.println("[Archive] Archive appears to not be compressed? (" + ex.getClass().getName() + ": " + ex.getMessage() + ")");
            }
        }
        System.out.println("[Archive] Reading archive " + f.getName());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f), 51200);
        try {
            while (true) {
                long len;
                String path;
                int type;
                try {
                    type = CFriendlyStreamUtils.readInt(in);
                }
                catch (EOFException x) {
                    break;
                }
                catch (NumberFormatException x) {
                    x.printStackTrace();
                    break;
                }
                if (type == 2) {
                    path = CFriendlyStreamUtils.readString(in);
                    len = CFriendlyStreamUtils.readLong(in);
                    listener.p200Archive(path, len);
                    Archive.skip(in, len);
                    continue;
                }
                if (type == 0) {
                    path = CFriendlyStreamUtils.readString(in);
                    if (path.startsWith(ASB_PREFIX)) {
                        path = path.substring(ASB_PREFIX.length());
                        len = CFriendlyStreamUtils.readLong(in);
                        if (path.equals(ASB_DIGSIG1)) {
                            int siglen = CFriendlyStreamUtils.readInt(in);
                            String sig = CFriendlyStreamUtils.readString(in);
                            break;
                        }
                        Archive.skip(in, len);
                        continue;
                    }
                    len = CFriendlyStreamUtils.readLong(in);
                    listener.file(path, len);
                    Archive.skip(in, len);
                    continue;
                }
                if (type != 1) continue;
                listener.folder(CFriendlyStreamUtils.readString(in));
            }
        }
        finally {
            FileUtil.robustClose(in);
            if (decompressed) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean printArchive(File f, String pubkeyHex, boolean decompress) throws Exception {
        if (decompress) {
            f = XZUtil.decompress(f, new File(f.getAbsolutePath() + ".decompressed"));
        }
        PSSSigner signer = null;
        if (pubkeyHex != null) {
            RSAKeyParameters pubkey = BCUtil.getPublicKeyFromHex(pubkeyHex);
            signer = BCUtil.initStreamSigner(pubkey);
        }
        ArchiveSignature archiveSignature = null;
        CFriendlyStreamUtils.ReadCache readCache = new CFriendlyStreamUtils.ReadCache();
        System.out.println("Reading archive " + f.getName());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f), 10240);
        try {
            block6: while (true) {
                int type;
                if (signer != null) {
                    signer.update(readCache.getByteArray(), 0, readCache.getLength());
                }
                readCache.clear();
                try {
                    type = CFriendlyStreamUtils.readInt(in, readCache);
                }
                catch (EOFException x) {
                    break;
                }
                catch (NumberFormatException x) {
                    x.printStackTrace();
                    break;
                }
                if (type == 0 || type == 2) {
                    long len;
                    String path = CFriendlyStreamUtils.readString(in, readCache);
                    if (path.startsWith(ASB_PREFIX)) {
                        path = path.substring(ASB_PREFIX.length());
                        len = CFriendlyStreamUtils.readLong(in, readCache);
                        System.out.print("Special Block  : ");
                        System.out.print("type=" + path);
                        System.out.print(", len=" + len);
                        System.out.println();
                        if (path.equals(ASB_DIGSIG1)) {
                            System.out.println("Signature : ");
                            int siglen = CFriendlyStreamUtils.readInt(in, readCache);
                            String sig = CFriendlyStreamUtils.readString(in, readCache);
                            System.out.print(len + "b = ");
                            System.out.println(sig);
                            archiveSignature = new ArchiveSignature(siglen, sig);
                            break;
                        }
                        Archive.skip(in, len);
                        continue;
                    }
                    if (type == 2) {
                        System.out.print("File (P200) : ");
                    } else {
                        System.out.print("File  : ");
                    }
                    System.out.print("path=" + path);
                    len = CFriendlyStreamUtils.readLong(in, readCache);
                    System.out.print(", len=" + len);
                    System.out.println();
                    if (signer != null) {
                        signer.update(readCache.getByteArray(), 0, readCache.getLength());
                    }
                    readCache.clear();
                    int i = 0;
                    while (true) {
                        if ((long)i >= len) continue block6;
                        int b = ((InputStream)in).read();
                        if (signer != null) {
                            signer.update((byte)b);
                        }
                        ++i;
                    }
                }
                if (type != 1) continue;
                System.out.print("Folder: ");
                System.out.print("path=" + CFriendlyStreamUtils.readString(in, readCache));
                System.out.println();
            }
        }
        finally {
            FileUtil.robustClose(in);
        }
        if (pubkeyHex != null && archiveSignature != null) {
            byte[] signature = BCUtil.getSignatureFromHex(archiveSignature.sig);
            return BCUtil.finishStreamSigner(signer, signature);
        }
        System.out.println("[Archive] Archive UNSIGNED and UNCHECKED");
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: Archive <file> [signature pubkey]");
        } else if (args.length == 1) {
            Archive.printArchive(new File(args[0]), null, true);
        } else {
            Archive.printArchive(new File(args[0]), args[1], true);
        }
    }

    static {
        THREADED_P200 = false;
        compressbuf = new OpenByteArrayOutputStream();
    }

    public static interface ArchiveListener {
        public void p200Archive(String var1, long var2);

        public void file(String var1, long var2);

        public void folder(String var1);
    }

    private class P2Thread
    extends Thread {
        UnqueuedSemaphore sem;
        File target;
        Throwable error;
        long[] p200info = new long[2];
        File jf;
        String jrelpath;
        FileStripper[] fs;
        ArrayList<String> allFiles = new ArrayList();

        public P2Thread(UnqueuedSemaphore sem, int index, File jf, String jrelpath, FileStripper[] fs) {
            this.sem = sem;
            this.jf = jf;
            this.jrelpath = jrelpath;
            this.fs = fs;
            this.target = new File(Archive.this.dest.getAbsolutePath() + "p2-" + index);
        }

        public void run() {
            OutputStream out = null;
            this.sem.doWait(1);
            try {
                out = new BufferedOutputStream(new FileOutputStream(this.target), 50000);
                Archive.addFileToStream(Archive.this.dest.getName(), Archive.this.pack200allowed, this.p200info, out, Archive.this.buf, this.jf, this.jrelpath, this.fs, null, Archive.this.filesToKeep, Archive.this.filesToNotPack200, Archive.this.pack200Effort, null, this.allFiles);
                out.close();
            }
            catch (Throwable x) {
                this.error = x;
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.sem.doSignal(1);
        }

        public void copyTo(OutputStream stream, byte[] buf, long[] p200) throws Throwable {
            if (this.error != null) {
                throw this.error;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.target));
            int n = 0;
            while (n != -1) {
                n = ((InputStream)in).read(buf);
                if (n <= 0) continue;
                Archive.this.out.write(buf, 0, n);
            }
            ((InputStream)in).close();
            this.target.delete();
            for (int i = 0; i < p200.length; ++i) {
                int n2 = i;
                p200[n2] = p200[n2] + this.p200info[i];
            }
        }
    }
}

