/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.security.Security;
import java.util.Properties;
import jwrapper.HeadlessOsxUtil;
import jwrapper.failover.FailoverMonitor;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWOsType;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.jwutils.network.JWNet;
import jwrapper.logging.StdLogging;
import jwrapper.proxy.JWDetectedProxy;
import jwrapper.updater.JWApp;
import jwrapper.updater.JWLaunchProperties;
import jwrapper.updater.LaunchFile;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.stream.CFriendlyStreamUtils;
import utils.stream.SSLHelper;
import utils.swing.EventThreadExceptionPrinter;
import utils.switches.LocalSwitches;

public class JWrapper {
    public static void main(String[] args) throws Exception {
        int i;
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        try {
            Security.setProperty("networkaddress.cache.ttl", "30");
            Security.setProperty("networkaddress.cache.negative.ttl", "10");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            JWNet.tryForceHttpAgentUnrestrictive();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (LocalSwitches.hardcode_debugAcceptAllSslCerts) {
            try {
                SSLHelper.setupSslAndHttpsToAcceptAllCerts(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        args = JWLaunchProperties.argsToNormalArgs(args);
        System.out.println("[JWrapper] About to set up logging to file (if configured)");
        if (JWLaunchProperties.getProperty("debug_logging").length() > 0 || StdLogging.beforeDebugLogUntil(JWLaunchProperties.getProperty("debug_logging_until"))) {
            StdLogging.startLogging(JWSystem.getAppFolder().getParentFile(), JWSystem.getAppBundleName() + "-" + JWSystem.getMyAppName());
        }
        StdLogging.startDebugLogging(JWSystem.getAppFolder().getParentFile(), JWSystem.getAppBundleName() + "-" + JWSystem.getMyAppName());
        try {
            JWNativeAPI.loadLibraryFrom(JWSystem.getAppFolder());
        }
        catch (Throwable t) {
            System.out.println("[JWrapper] ---------------------");
            System.out.println("[JWrapper] Loading native library failed (" + t.getMessage() + ")");
            System.out.println("[JWrapper] ---------------------");
            t.printStackTrace();
        }
        try {
            System.out.println("[JWrapper] Process ID: " + JWGenericOS.getInstance().getCurrentProcessID());
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (OS.isWindows()) {
                int mySessionID = JWNativeAPI.getInstance().getTsMySessionId();
                int consoleID = JWNativeAPI.getInstance().getTsConsoleSessionId();
                System.out.println("[JWrapper] The console session ID is " + consoleID);
                System.out.println("[JWrapper] Session ID: " + mySessionID + " (Console ID: " + consoleID + ")");
            }
        }
        catch (Throwable mySessionID) {
            // empty catch block
        }
        try {
            System.out.print("Launch Properties:\n" + JWLaunchProperties.getAsString());
        }
        catch (Throwable mySessionID) {
            // empty catch block
        }
        if (JWLaunchProperties.getBooleanProperty("headless_jvm_sysprop", false)) {
            System.out.println("[JWrapper] Headless Sysprop required");
            System.setProperty("java.awt.headless", "true");
        }
        try {
            if (JWOsType.isMacOS()) {
                if (JWLaunchProperties.getProperty("auto_disable_appnap").equalsIgnoreCase("false")) {
                    System.out.println("[JWrapper] App Nap NOT disabled");
                } else {
                    System.out.println("[JWrapper] Disabling App Nap");
                    Runtime.getRuntime().exec("defaults write " + JWSystem.getOsxAppDomainName() + " NSAppSleepDisabled -bool YES");
                }
            }
        }
        catch (Throwable mySessionID) {
            // empty catch block
        }
        if (JWLaunchProperties.getProperty("launch_prepare_only").equals("true")) {
            Object[] all;
            System.out.println("[JWrapper] Preparatory virtual app, waiting for instructions");
            JWLaunchProperties.deleteProperty("launch_prepare_only");
            Class<?> clazz = Class.forName("jwrapper.JWPrepare");
            Object inst = clazz.newInstance();
            Object[] ret = (Object[])clazz.getDeclaredMethod("waitForInstructions", new Class[0]).invoke(inst, new Object[0]);
            Properties nprops = (Properties)ret[0];
            args = (String[])ret[1];
            JWLaunchProperties.deleteProperty("launch_expect_appversion");
            JWLaunchProperties.deleteProperty("launch_expect_appname");
            System.out.println("[JWrapper] Instructions received, ready to start");
            for (Object one : all = nprops.keySet().toArray()) {
                String key = (String)one;
                String value = nprops.getProperty(key);
                if (key.toLowerCase().contains("password")) {
                    System.out.println("[JWrapper] " + key + "=xxxxxxxx");
                } else {
                    System.out.println("[JWrapper] " + key + "=" + value);
                }
                JWLaunchProperties.overrideDynamicProperty(key, value);
            }
            String shouldShowUI = JWLaunchProperties.getProperty("post_prep_show_ui");
            JWLaunchProperties.overrideDynamicProperty("show_no_ui", shouldShowUI);
            System.out.println("[JWrapper] Prepared app should show UI: " + shouldShowUI);
        }
        try {
            for (int i2 = 0; i2 < args.length; ++i2) {
                String arg = args[i2];
                if (arg.startsWith("/") || arg.startsWith("-")) {
                    arg = arg.substring(1);
                }
                if (!arg.startsWith("JW_")) continue;
                arg = arg.substring(3);
                System.out.println("[JWrapper] DynProp ARG [" + arg + "]");
                int eq = arg.indexOf(61);
                if (eq == -1) continue;
                String key = arg.substring(0, eq);
                String value = arg.substring(eq + 1);
                System.out.println("[JWrapper] DynProp ARG <" + key + ">=(" + value + ")");
                JWLaunchProperties.overrideDynamicProperty(key, value);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            System.out.println("[JWrapper] App Bundle Name:    " + JWSystem.getAppBundleName());
            System.out.println("[JWrapper] App Bundle Version: " + JWSystem.getAppBundleVersion());
            System.out.println("[JWrapper] Virtual App:        " + JWSystem.getMyAppName());
            System.out.println("[JWrapper] Update URL:         " + JWSystem.getUpdateURL());
            System.out.println("[JWrapper] App Folder:         " + JWSystem.getAppFolder());
            System.out.println("[JWrapper] JRE:                " + JWSystem.getMyJreHome());
            System.out.println("[JWrapper] JRE Version:        " + System.getProperty("java.version"));
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.out.println("[JWrapper] Proxy:              " + JWSystem.getJWrapperProxy());
            System.out.println("[JWrapper] Proxy Host:         " + JWSystem.getJWrapperProxy().address());
        }
        catch (Throwable t) {
            // empty catch block
        }
        boolean SHOW_NO_UI = JWLaunchProperties.hideUI();
        try {
            EventThreadExceptionPrinter.setup();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            String requestURL;
            if (OS.isMacOS() && (requestURL = JWLaunchProperties.getProperty("url_req")).length() > 0) {
                JWLaunchProperties.overrideProperty("url_req", "");
                JWLaunchProperties.overrideDynamicProperty("url_req", "");
                JWLaunchProperties.overrideDynamicProperty("urlhandler", requestURL);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (OS.isWindows()) {
                System.out.println("[JWrapper] Is Process DPI Aware: " + JWNativeAPI.getInstance().isProcessDPIAware());
            }
            System.out.println("[JWrapper] sun.java2d.dpiaware: " + System.getProperty("sun.java2d.dpiaware"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            String id;
            if (OS.isWindowsVistaOrAbove() && (id = JWLaunchProperties.getProperty("windows_app_id")) != null && id.length() > 0) {
                System.out.println("[JWrapper] Setting app ID to " + id);
                JWWindowsOS windowsOS = new JWWindowsOS();
                windowsOS.setWindowsAppID(id);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            JWDetectedProxy.loadLastDetectedProxy();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (OS.isWindows()) {
                if (JWLaunchProperties.getProperty("procpri_normal").equalsIgnoreCase("true")) {
                    new JWWindowsOS().makeCurrentProcessNormalPriority();
                } else if (JWLaunchProperties.getProperty("procpri_high").equalsIgnoreCase("true")) {
                    new JWWindowsOS().makeCurrentProcessHighPriority();
                } else if (JWLaunchProperties.getProperty("procpri_low").equalsIgnoreCase("true")) {
                    new JWWindowsOS().makeCurrentProcessLowPriority();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            String prop = JWLaunchProperties.getProperty("exit_timebomb");
            if (prop.length() > 0) {
                long ms = Long.parseLong(prop);
                System.out.println("[JWrapper] JW Timebomb set - will exit in " + ms + "ms");
                TimedExit tx = new TimedExit();
                tx.ms = ms;
                tx.start();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            String[] my_options;
            try {
                int njvmProps = Integer.parseInt(JWLaunchProperties.getProperty("jvm_options_count"));
                my_options = new String[njvmProps];
                for (int i3 = 0; i3 < my_options.length; ++i3) {
                    my_options[i3] = JWLaunchProperties.getProperty("jvm_options_" + i3);
                    System.out.println("JVM Option: " + my_options[i3]);
                }
            }
            catch (NumberFormatException x) {
                my_options = new String[]{};
            }
            String jvm_home = System.getProperty("java.home");
            System.out.println("[JWrapper] JVM Home: " + jvm_home);
            File lso = LaunchFile.getJvmLastSuccessfulOptionsFile(JWSystem.getAppFolder().getParentFile(), new File(jvm_home));
            FileOutputStream out = null;
            try {
                out = FileUtil.repeatAttemptOpenFromForWriting(lso, 10, 200);
                CFriendlyStreamUtils.writeInt(out, my_options.length);
                for (int i4 = 0; i4 < my_options.length; ++i4) {
                    CFriendlyStreamUtils.writeString(out, my_options[i4]);
                }
            }
            catch (Throwable t) {
                System.out.println("Failed to write JVM Options: " + t);
            }
            FileUtil.robustClose(out);
            JWGenericOS.setWritableForAllUsers(lso, false);
            System.out.println("[JWrapper] Wrote JVM Options OK");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        JWApp jwapp = JWApp.getMyVirtualApp();
        try {
            if (JWOsType.isMacOS()) {
                System.out.println("[JWrapper] Set app name to " + jwapp.getUserVisibleName());
                HeadlessOsxUtil.setOSXAppName(jwapp.getUserVisibleName());
                if (!SHOW_NO_UI) {
                    JWrapper.setAppVisibleOSX(jwapp);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            FailoverMonitor.checkSetup(true);
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
        String[] nargs = new String[jwapp.args.size() + args.length];
        for (i = 0; i < jwapp.args.size(); ++i) {
            nargs[i] = jwapp.args.get(i);
        }
        for (i = 0; i < args.length; ++i) {
            nargs[jwapp.args.size() + i] = args[i];
        }
        Class<?> cl = Class.forName(jwapp.mainClass);
        Method method = cl.getMethod("main", String[].class);
        method.invoke(null, new Object[]{nargs});
    }

    private static void setAppVisibleOSX(JWApp jwapp) {
        System.out.println("[JWrapper] Loading virtual app");
        System.out.println("[JWrapper] Got virtual app " + jwapp.getUserVisibleName());
        System.out.println("[JWrapper] Setting OS dock info");
        Object logoPNG = HeadlessOsxUtil.loadImageFromJWApp(jwapp);
        System.out.println("[JWrapper] Image: " + logoPNG);
        HeadlessOsxUtil.setOSXAppDockImage(logoPNG);
        JWNativeAPI.getInstance().showApplication();
        HeadlessOsxUtil.requestForeground();
    }

    private static class TimedExit
    extends Thread {
        long ms;

        private TimedExit() {
        }

        public void run() {
            try {
                Thread.sleep(this.ms);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("[JWrapper] Timebomb timer has finished (" + this.ms + "ms), exiting now");
            System.exit(0);
        }
    }
}

