/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSockIPCListener;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.ostools.OS;
import utils.string.StringUtil;

public class JWPrepare
implements JWSockIPCListener {
    private boolean ready = false;
    private int consoleSessionID;

    private boolean areSessionsOKToLaunch() {
        int newID = JWNativeAPI.getInstance().getTsConsoleSessionId();
        if (newID == this.consoleSessionID) {
            System.out.println("[JWPrepare] Console session ID has not changed. OK to launch.");
            return true;
        }
        System.out.println("[JWPrepare] Console session ID has changed (initial: " + this.consoleSessionID + " current: " + newID + ")");
        return false;
    }

    public Object[] waitForInstructions() {
        try {
            boolean isConsoleConnection;
            boolean launchInSession;
            String reqVersion;
            JWSockIPC ipc = JWSockIPC.connectChild("JWVappPreparation");
            ipc.setupMultipleChannels();
            ipc.setupPingsAndReportClosure(this, (short)99, 10000L);
            String reqVapp = JWLaunchProperties.getProperty("launch_expect_appname");
            if (reqVapp.length() > 0) {
                System.out.println("[JWPrepare] Required virtual app is " + reqVapp);
                if (!reqVapp.equals(JWSystem.getMyAppName())) {
                    System.out.println("[JWPrepare] Actual virtual app is " + JWSystem.getMyAppName() + ", exiting...");
                    ipc.close();
                    System.exit(0);
                }
            }
            if ((reqVersion = JWLaunchProperties.getProperty("launch_expect_appversion")).length() > 0) {
                System.out.println("[JWPrepare] Required app version is " + reqVersion);
                if (!reqVersion.equals(JWSystem.getAppBundleVersion())) {
                    System.out.println("[JWPrepare] Actual version is " + JWSystem.getAppBundleVersion() + ", exiting...");
                    ipc.close();
                    System.exit(0);
                }
            }
            boolean checkSessionIDs = false;
            if (OS.isWindows() && (launchInSession = StringUtil.stringIsTrue(JWLaunchProperties.getProperty("launch_in_session"))) && (isConsoleConnection = StringUtil.stringIsFalse(JWLaunchProperties.getProperty("launch_in_specific_session")))) {
                checkSessionIDs = true;
                this.consoleSessionID = JWNativeAPI.getInstance().getTsConsoleSessionId();
                System.out.println("[JWPrepare] Checking session IDs (current: " + this.consoleSessionID + ")");
            }
            long T = System.currentTimeMillis();
            try {
                Class.forName("com.jw.Preload").newInstance();
            }
            catch (Throwable t) {
                System.out.println("[JWPrepare] Preload class com.jw.Preload not found " + t);
                t.printStackTrace();
            }
            T = System.currentTimeMillis() - T;
            System.out.println("[JWPrepare] Preload took " + T + "ms, waiting for instructions on " + ipc);
            DataInputStream din = new DataInputStream(ipc.getInChannel((short)0));
            int len = din.readInt();
            byte[] buf = new byte[len];
            int tot = 0;
            while (tot < len) {
                int N = din.read(buf, tot, len - tot);
                if (N > 0) {
                    tot += N;
                    continue;
                }
                if (N != -1) continue;
                this.ipcClosed();
            }
            String[] args = new String[din.readInt()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = din.readUTF();
            }
            boolean reportFailure = false;
            if (checkSessionIDs) {
                reportFailure = !this.areSessionsOKToLaunch();
            }
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(buf));
            System.out.println("[JWPrepare] Received launch properties, ready to launch now");
            this.ready = true;
            DataOutputStream out = new DataOutputStream(ipc.getOutChannel((short)0));
            if (reportFailure) {
                out.writeInt(999999);
                out.flush();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                throw new IOException("Cancelling prelaunched processes due to session ID mismatch");
            }
            out.writeInt(123456);
            out.flush();
            System.out.println("[JWPrepare] Sent notification of IPC launch success");
            Object[] ret = new Object[]{props, args};
            return ret;
        }
        catch (IOException x) {
            x.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public void ipcClosed() {
        if (!this.ready) {
            System.out.println("[JWPrepare] Quitting");
            System.exit(0);
        }
    }
}

