/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import jwrapper.JWStreamParameteriser;
import utils.stream.GenericParameteriser;
import utils.string.HexData;

public class JWParameteriser
extends GenericParameteriser {
    static final byte[] start = new byte[]{89, -67, -55, 82, -86, 53, -83, -69, 16, -17, -34, 103, 44, 71, -32, -75, -44, -126, 31, -127, 82, -95, 2, 68, 42, -21, -86, 123, 121, 59, -109, 69, -82, -46, 9, 122, 62, 47, 46, -6, -1, 29, -16, -101, 25, 124, 21, -72, 30, 109, -58, 16, 65, 126, 92, -19, 81, -79, 25, 28, 60, -30, -108, -40};
    static final byte[] end = new byte[]{-40, -108, -30, 60, 28, 25, -79, 81, -19, 92, 126, 65, 16, -58, 109, 30, -72, 21, 124, 25, -101, -16, 29, -1, -6, 46, 47, 62, 122, 9, -46, -82, 69, -109, 59, 121, 123, -86, -21, 42, 68, 2, -95, 82, -127, 31, -126, -44, -75, -32, 71, 44, 103, -34, -17, 16, -69, -83, 53, -86, 82, -55, -67, 89};

    public byte[] getStartMarker() {
        return start;
    }

    public byte[] getEndMarker() {
        return end;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: JWParameteriser <file> <command> [other options]");
            System.out.println("Commands:");
            System.out.println("  validate                  validate that an unparameterised file has a correct and uncorrupted parameterisation block");
            System.out.println("  length                    print the length of the current parameters as a block (interpreted as C code would)");
            System.out.println("  print                     print any properties stored in a files parameterisation block");
            System.out.println("  remove                    remove all properties from a file's paramterisation block");
            System.out.println("  store <props file>        overwrite properties from a properties file into the target file's paramterisation block");
            System.exit(0);
        }
        File f = new File(args[0]);
        String cmd = args[1];
        if (cmd.equals("validate")) {
            JWParameteriser jwparams = new JWParameteriser();
            if (jwparams.validateUnparameterised(f)) {
                System.out.println("Parameter block is VALID");
            } else {
                System.out.println("Parameter block is NOT VALID");
            }
        } else if (cmd.equals("conctest")) {
            ArrayList<ReadThread> threads = new ArrayList<ReadThread>();
            for (int i = 0; i < 200; ++i) {
                ReadThread rt = new ReadThread(f);
                rt.start();
                threads.add(rt);
            }
            Thread.sleep(5000L);
            System.out.println("Will check results now:");
            String orig = null;
            for (int i = 0; i < 200; ++i) {
                ReadThread rt = (ReadThread)threads.get(i);
                rt.join();
                String mine = rt.props.toString();
                if (orig == null) {
                    orig = mine;
                    System.out.println("Original: " + orig);
                    continue;
                }
                if (mine.equals(orig)) continue;
                System.out.println("PROBLEM: " + mine);
            }
            System.out.println("Done");
        } else if (cmd.equals("length")) {
            JWParameteriser jwparams = new JWParameteriser();
            Properties props = jwparams.getParameters(f);
            if (jwparams.validateCLength(f)) {
                System.out.println("Parameter block is VALID");
            } else {
                System.out.println("Parameter block is NOT VALID");
            }
        } else if (cmd.equals("print")) {
            JWParameteriser jwparams = new JWParameteriser();
            Properties props = jwparams.getParameters(f);
            System.out.println(props);
        } else if (cmd.equals("remove")) {
            JWParameteriser jwparams = new JWParameteriser();
            jwparams.setParameters(new Properties(), f, true);
        } else if (cmd.equals("store")) {
            Properties props = new Properties();
            props.load(new FileInputStream(args[2]));
            Object[] keys = props.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                String value = props.getProperty(key);
                if (!value.startsWith("HEXENCODE:")) continue;
                System.out.println("Hex encoding " + key);
                props.put(key, HexData.stringToHexString(value));
            }
            System.out.println(props);
            JWParameteriser jwparams = new JWParameteriser();
            jwparams.setParameters(props, f, true);
        } else {
            System.out.println("Unrecognised command " + cmd);
        }
    }

    public JWStreamParameteriser newStreamParameteriser(Properties props) throws IOException {
        return new JWStreamParameteriser(super.newStreamParametiser(props));
    }

    public JWStreamParameteriser newStreamParameteriser(String[] names, String[] values) throws IOException {
        return new JWStreamParameteriser(super.newStreamParametiser(names, values));
    }

    public void setParameters(Properties props, File file, boolean overwrite) throws IOException {
        super.setParameters(props, file, overwrite);
    }

    public void setParameters(String[] names, String[] values, File file, boolean overwrite) throws IOException {
        super.setParameters(names, values, file, overwrite);
    }

    public Properties getParameters(File file) throws IOException {
        return super.getParameters(file);
    }

    private static class ReadThread
    extends Thread {
        File f;
        Properties props;

        public ReadThread(File f) {
            this.f = f;
        }

        public void run() {
            try {
                JWParameteriser jwparams = new JWParameteriser();
                this.props = jwparams.getParameters(this.f);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

