/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.util.LinkedList;
import jwrapper.updater.GenericUpdater;

public class AsyncAuxDownloader {
    private static final Object LOCK = new Object();
    private static LinkedList<AuxiliaryDownloader> downloaders = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAuxiliaryArchiveFetch(String auxiliaryArchiveName) {
        if (auxiliaryArchiveName == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            AuxiliaryDownloader existingDownloader = AsyncAuxDownloader.getDownloaderFor(auxiliaryArchiveName);
            if (existingDownloader == null) {
                existingDownloader = new AuxiliaryDownloader(auxiliaryArchiveName);
                downloaders.add(existingDownloader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockUntilDownloaderFinishes(String auxiliaryArchiveName) throws NoSuchDownloaderException {
        if (auxiliaryArchiveName == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            AuxiliaryDownloader existingDownloader = AsyncAuxDownloader.getDownloaderFor(auxiliaryArchiveName);
            if (existingDownloader == null) {
                throw new NoSuchDownloaderException("No downloader for '" + auxiliaryArchiveName + "' found");
            }
            while (!existingDownloader.finished) {
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static AuxiliaryDownloader getDownloaderFor(String auxiliaryArchiveName) {
        for (AuxiliaryDownloader downloader : downloaders) {
            if (!downloader.auxiliaryArchiveName.equals(auxiliaryArchiveName)) continue;
            return downloader;
        }
        return null;
    }

    static final class AuxiliaryDownloader
    extends Thread {
        private final String auxiliaryArchiveName;
        private Exception error = null;
        private boolean finished = false;

        public AuxiliaryDownloader(String auxiliaryArchiveName) {
            super("AuxiliaryDownloader-" + auxiliaryArchiveName);
            this.auxiliaryArchiveName = auxiliaryArchiveName;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                GenericUpdater.fetchAuxiliaryArchive(this.auxiliaryArchiveName, false);
            }
            catch (Exception t) {
                this.error = t;
                t.printStackTrace();
            }
            finally {
                this.finished = true;
                Object object = LOCK;
                synchronized (object) {
                    LOCK.notifyAll();
                }
            }
        }
    }

    public static class NoSuchDownloaderException
    extends Exception {
        private NoSuchDownloaderException(String msg) {
            super(msg);
        }
    }
}

