/*
 * Decompiled with CFR 0.152.
 */
package com.simplehelp.macos;

public class PListCreator {
    public static String getPList(String uniqueLabel, String programName, String[] arguments, boolean keepAlive, String workingDir, String[] limitToSessionType, boolean abandonProcessGroup) {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\" >\n");
        buffer.append("<plist version=\"1.0\">\n");
        buffer.append("<dict>\n");
        buffer.append("\t<key>Label</key>\n");
        buffer.append("\t<string>" + uniqueLabel + "</string>\n");
        buffer.append("\t<key>ProgramArguments</key>\n");
        buffer.append("\t<array>\n");
        if (programName != null) {
            buffer.append("\t\t<string>" + programName + "</string>\n");
        }
        if (arguments != null) {
            for (i = 0; i < arguments.length; ++i) {
                buffer.append("\t\t<string>" + arguments[i] + "</string>\n");
            }
        }
        buffer.append("\t</array>\n");
        buffer.append("\t<key>OnDemand</key>\n");
        buffer.append("\t<true/>\n");
        buffer.append("\t<key>Disabled</key>\n");
        buffer.append("\t<false/>\n");
        buffer.append("\t<key>KeepAlive</key>\n");
        if (keepAlive) {
            buffer.append("\t<true/>\n");
        } else {
            buffer.append("\t<false/>\n");
        }
        if (workingDir != null) {
            buffer.append("\t<key>WorkingDirectory</key>\n");
            buffer.append("\t<string>" + workingDir + "</string>\n");
        }
        if (limitToSessionType != null) {
            buffer.append("\t<key>LimitLoadToSessionType</key>\n");
            buffer.append("\t<array>\n");
            for (i = 0; i < limitToSessionType.length; ++i) {
                buffer.append("\t\t<string>" + limitToSessionType[i] + "</string>\n");
            }
            buffer.append("\t</array>\n");
        }
        buffer.append("\t<key>RunAtLoad</key>\n");
        buffer.append("\t<true/>\n");
        if (abandonProcessGroup) {
            buffer.append("\t<key>AbandonProcessGroup</key>\n");
            buffer.append("\t<true/>\n");
        }
        buffer.append("</dict>\n");
        buffer.append("</plist>\n");
        return buffer.toString();
    }
}

