/*
 * Decompiled with CFR 0.152.
 */
package com.grahamedgecombe.jterminal.vt100;

import com.grahamedgecombe.jterminal.AbstractTerminalModel;
import com.grahamedgecombe.jterminal.TerminalCell;
import com.grahamedgecombe.jterminal.bell.BellStrategy;
import com.grahamedgecombe.jterminal.bell.NopBellStrategy;
import com.grahamedgecombe.jterminal.vt100.AnsiControlSequence;
import com.grahamedgecombe.jterminal.vt100.AnsiControlSequenceListener;
import com.grahamedgecombe.jterminal.vt100.AnsiControlSequenceParser;
import com.grahamedgecombe.jterminal.vt100.SgrColor;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import utils.swing.simplelist.SimpleLock;

public class Vt100TerminalModel
extends AbstractTerminalModel {
    private TerminalScroller terminalScroller;
    private SimpleLock PAINT_LOCK = new SimpleLock();
    private static final int DEFAULT_COLUMNS = 80;
    private static final int DEFAULT_ROWS = 25;
    private static final int TAB_WIDTH = 8;
    private static final boolean DEFAULT_FOREGROUND_BOLD = true;
    private static final boolean DEFAULT_BACKGROUND_BOLD = false;
    private static final int DEFAULT_FOREGROUND_COLOR = 7;
    private static final int DEFAULT_BACKGROUND_COLOR = 0;
    private final AnsiControlSequenceListener listener = new Vt100Listener();
    private final AnsiControlSequenceParser parser = new AnsiControlSequenceParser(this.listener);
    private BellStrategy bellStrategy = new NopBellStrategy();
    private TerminalCell[][] cells;
    private int columns;
    private int rows;
    private int bufferSize;
    private int cursorRow = 0;
    private int cursorColumn = 0;
    private boolean foregroundBold = true;
    private boolean backgroundBold = false;
    private int foregroundColor = 7;
    private int backgroundColor = 0;

    public void setTerminalScroller(TerminalScroller scroller) {
        this.terminalScroller = scroller;
    }

    public Vt100TerminalModel() {
        this(80, 25);
    }

    public Vt100TerminalModel(int columns, int rows) {
        this(columns, rows, rows);
    }

    public Vt100TerminalModel(int columns, int rows, int bufferSize) {
        if (columns < 0 || rows < 0 || bufferSize < 0) {
            throw new IllegalArgumentException("Zero or positive values only allowed for columns, rows and buffer size.");
        }
        if (bufferSize < rows) {
            throw new IllegalArgumentException("The buffer is too small");
        }
        this.columns = columns;
        this.rows = rows;
        this.bufferSize = bufferSize;
        this.init();
    }

    private void init() {
        this.cells = new TerminalCell[this.bufferSize][this.columns];
    }

    @Override
    public int getCursorRow() {
        return this.cursorRow;
    }

    @Override
    public void setCursorRow(int row) {
        if (row < 0 || row >= this.bufferSize) {
            throw new IllegalArgumentException("row out of range");
        }
        this.cursorRow = row;
    }

    @Override
    public int getCursorColumn() {
        return this.cursorColumn;
    }

    @Override
    public void setCursorColumn(int column) {
        if (column < 0 || column >= this.columns) {
            throw new IllegalArgumentException("column out of range");
        }
        this.cursorColumn = column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminalCell getCell(int column, int row) {
        this.lock();
        try {
            if (column < 0 || row < 0 || column >= this.columns || row >= this.bufferSize) {
                throw new IndexOutOfBoundsException();
            }
            TerminalCell terminalCell = this.cells[row][column];
            return terminalCell;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCell(int column, int row, TerminalCell cell) {
        this.lock();
        try {
            if (column < 0 || row < 0 || column >= this.columns || row >= this.bufferSize) {
                throw new IndexOutOfBoundsException();
            }
            this.cells[row][column] = cell;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void print(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        this.parser.parse(str);
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public BellStrategy getBellStrategy() {
        return this.bellStrategy;
    }

    @Override
    public void setBellStrategy(BellStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("strategy");
        }
        this.bellStrategy = strategy;
    }

    @Override
    public Color getDefaultBackgroundColor() {
        boolean bg = false;
        return SgrColor.COLOR_NORMAL[0];
    }

    @Override
    public Color getDefaultForegroundColor() {
        int fg = 7;
        return SgrColor.COLOR_BRIGHT[7];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setWindowSize(int rows, int columns) {
        this.lock();
        try {
            if (this.rows == rows && this.columns == columns) {
                boolean bl = false;
                return bl;
            }
            this.rows = rows;
            this.columns = columns;
            this.bufferSize = Math.max(rows, this.bufferSize);
            int rowsToCopy = Math.min(this.cells.length, this.bufferSize);
            TerminalCell[][] newCells = new TerminalCell[this.bufferSize][columns];
            for (int i = 0; i < rowsToCopy; ++i) {
                int cellCount = Math.min(newCells[i].length, this.cells[i].length);
                System.arraycopy(this.cells[i], 0, newCells[i], 0, cellCount);
            }
            this.cells = newCells;
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void lock() {
        this.PAINT_LOCK.getReadWriteLock();
    }

    @Override
    public void unlock() {
        this.PAINT_LOCK.releaseReadWriteLock();
    }

    private class Vt100Listener
    implements AnsiControlSequenceListener {
        private int savedCursorRow = -1;
        private int savedCursorColumn = -1;
        private static final boolean DEBUG = true;

        private Vt100Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void parsedControlSequence(AnsiControlSequence seq) {
            Vt100TerminalModel.this.lock();
            try {
                char command = seq.getCommand();
                Object[] parameters = seq.getParameters();
                switch (command) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': {
                        int n = 1;
                        if (parameters.length == 1) {
                            n = Integer.parseInt(parameters[0]);
                        }
                        if (command == 'A') {
                            System.out.println("[VT100] Move cursor up by " + n);
                            Vt100TerminalModel.this.moveCursorUp(n);
                            return;
                        } else if (command == 'B') {
                            System.out.println("[VT100] Move cursor down by " + n);
                            Vt100TerminalModel.this.moveCursorDown(n);
                            return;
                        } else if (command == 'C') {
                            System.out.println("[VT100] Move cursor forward by " + n);
                            Vt100TerminalModel.this.moveCursorForward(n);
                            return;
                        } else {
                            if (command != 'D') return;
                            System.out.println("[VT100] Move cursor back by " + n);
                            Vt100TerminalModel.this.moveCursorBack(n);
                            return;
                        }
                    }
                    case 'E': 
                    case 'F': {
                        int n = 1;
                        if (parameters.length == 1) {
                            n = Integer.parseInt(parameters[0]);
                        }
                        if (command == 'E') {
                            System.out.println("[VT100] Move cursor down by " + n + " and to the start of new line");
                            Vt100TerminalModel.this.moveCursorDown(n);
                        } else if (command == 'F') {
                            System.out.println("[VT100] Move cursor up by " + n + " and to the start of new line");
                            Vt100TerminalModel.this.moveCursorUp(n);
                        }
                        Vt100TerminalModel.this.setCursorColumn(0);
                        return;
                    }
                    case 'G': {
                        if (parameters.length != 1) return;
                        int n = Integer.parseInt(parameters[0]);
                        System.out.println("[VT100] Move cursor to column " + (n - 1));
                        Vt100TerminalModel.this.setCursorColumn(n - 1);
                        return;
                    }
                    case 'H': 
                    case 'f': {
                        if (parameters.length == 2) {
                            int n = 1;
                            int m = 1;
                            if (parameters[0].length() > 0) {
                                n = Integer.parseInt((String)parameters[0]);
                            }
                            if (((String)parameters[1]).length() > 0) {
                                m = Integer.parseInt((String)parameters[1]);
                            }
                            System.out.println("[VT100] Move cursor to " + (n - 1) + "," + (m - 1));
                            Vt100TerminalModel.this.setCursorRow(n - 1);
                            Vt100TerminalModel.this.setCursorColumn(m - 1);
                            return;
                        } else {
                            System.out.println("[VT100] Move cursor to 0,0");
                            Vt100TerminalModel.this.setCursorRow(0);
                            Vt100TerminalModel.this.setCursorColumn(0);
                            return;
                        }
                    }
                    case 'J': {
                        int n = 0;
                        if (parameters.length == 1) {
                            n = Integer.parseInt(parameters[0]);
                        }
                        if (n == 0) {
                            System.out.println("[VT100] Clear screen from cursor down");
                            int column = Vt100TerminalModel.this.cursorColumn;
                            for (int row = Vt100TerminalModel.this.cursorRow; row < Vt100TerminalModel.this.bufferSize; ++row) {
                                while (column < Vt100TerminalModel.this.columns) {
                                    ((Vt100TerminalModel)Vt100TerminalModel.this).cells[row][column] = null;
                                    ++column;
                                }
                                column = 0;
                            }
                            return;
                        } else if (n == 1) {
                            System.out.println("[VT100] Clear screen from cursor up");
                            int column = Vt100TerminalModel.this.cursorColumn;
                            for (int row = Vt100TerminalModel.this.cursorRow; row >= 0; --row) {
                                while (column >= 0) {
                                    ((Vt100TerminalModel)Vt100TerminalModel.this).cells[row][column] = null;
                                    --column;
                                }
                                column = Vt100TerminalModel.this.columns - 1;
                            }
                            return;
                        } else {
                            if (n != 2) return;
                            System.out.println("[VT100] Clear screen");
                            Vt100TerminalModel.this.clear();
                            return;
                        }
                    }
                    case 'K': {
                        int n = 0;
                        if (parameters.length == 1) {
                            n = Integer.parseInt(parameters[0]);
                        }
                        if (n == 0) {
                            System.out.println("[VT100] Clear line from cursor right");
                            for (int column = Vt100TerminalModel.this.cursorColumn; column < Vt100TerminalModel.this.columns && Vt100TerminalModel.this.cursorRow < Vt100TerminalModel.this.bufferSize; ++column) {
                                try {
                                    ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).cursorRow][column] = null;
                                    continue;
                                }
                                catch (ArrayIndexOutOfBoundsException ex) {
                                    System.out.println("[VT100] " + Vt100TerminalModel.this.cursorRow + " " + column + " - " + Vt100TerminalModel.this.cells.length + " - " + Vt100TerminalModel.this.cells[0].length);
                                }
                            }
                            return;
                        } else if (n == 1) {
                            System.out.println("[VT100] Clear line from cursor left");
                            for (int column = 0; column < Vt100TerminalModel.this.cursorColumn; ++column) {
                                ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).cursorRow][column] = null;
                            }
                            return;
                        } else {
                            if (n != 2) return;
                            System.out.println("[VT100] Clear line");
                            for (int column = 0; column < Vt100TerminalModel.this.columns; ++column) {
                                ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).cursorRow][column] = null;
                            }
                        }
                        return;
                    }
                    case 'm': {
                        if (parameters.length == 0) {
                            parameters = new String[]{"0"};
                        }
                        for (Object parameter : parameters) {
                            if (((String)parameter).equals("0")) {
                                System.out.println("[VT100] Turn off attributes");
                                Vt100TerminalModel.this.foregroundColor = 7;
                                Vt100TerminalModel.this.backgroundColor = 0;
                                Vt100TerminalModel.this.backgroundBold = false;
                                Vt100TerminalModel.this.foregroundBold = true;
                                continue;
                            }
                            if (((String)parameter).equals("2")) {
                                System.out.println("[VT100] Turn low intensity mode on");
                                Vt100TerminalModel.this.backgroundBold = true;
                                Vt100TerminalModel.this.foregroundBold = true;
                                continue;
                            }
                            if (((String)parameter).equals("22")) {
                                Vt100TerminalModel.this.backgroundBold = false;
                                Vt100TerminalModel.this.foregroundBold = false;
                                continue;
                            }
                            if (((String)parameter).equals("7")) {
                                System.out.println("[VT100] Turn reverse video on");
                                int tmp = Vt100TerminalModel.this.backgroundColor;
                                Vt100TerminalModel.this.backgroundColor = Vt100TerminalModel.this.foregroundColor;
                                Vt100TerminalModel.this.foregroundColor = tmp;
                                continue;
                            }
                            if (!((String)parameter).startsWith("3") && !((String)parameter).startsWith("4") || ((String)parameter).length() != 2) continue;
                            int color = Integer.parseInt(((String)parameter).substring(1));
                            if (((String)parameter).startsWith("3")) {
                                Vt100TerminalModel.this.foregroundColor = color;
                                continue;
                            }
                            if (!((String)parameter).startsWith("4")) continue;
                            Vt100TerminalModel.this.backgroundColor = color;
                        }
                        return;
                    }
                    case 'u': {
                        System.out.println("[VT100] Restoring saved cursor position " + this.savedCursorRow + "," + this.savedCursorColumn);
                        if (this.savedCursorColumn == -1 || this.savedCursorRow == -1) return;
                        Vt100TerminalModel.this.cursorColumn = this.savedCursorColumn;
                        Vt100TerminalModel.this.cursorRow = this.savedCursorRow;
                        return;
                    }
                    case 's': {
                        System.out.println("[VT100] Saving cursor position " + Vt100TerminalModel.this.cursorRow + "," + Vt100TerminalModel.this.cursorColumn);
                        this.savedCursorColumn = Vt100TerminalModel.this.cursorColumn;
                        this.savedCursorRow = Vt100TerminalModel.this.cursorRow;
                        return;
                    }
                    case 'l': {
                        if (parameters.length == 1 && parameters[0].equals("?25")) {
                            System.out.println("[ANSISYS] Skipping cursor control");
                            return;
                        }
                    }
                    case 'h': {
                        if (parameters.length == 1 && parameters[0].equals("?25")) {
                            System.out.println("[ANSISYS] Skipping cursor control");
                            return;
                        }
                    }
                    default: {
                        System.out.println("[VT100] Unknown command " + command + " params=" + Arrays.toString(parameters));
                        return;
                    }
                }
            }
            finally {
                Vt100TerminalModel.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parsedString(String str) {
            Vt100TerminalModel.this.lock();
            try {
                block12: for (char ch : str.toCharArray()) {
                    switch (ch) {
                        case '\b': {
                            Vt100TerminalModel.this.moveCursorBack(1);
                            continue block12;
                        }
                        case '\u0000': {
                            continue block12;
                        }
                        case '\r': {
                            Vt100TerminalModel.this.cursorColumn = 0;
                            continue block12;
                        }
                        case '\n': {
                            Vt100TerminalModel.this.cursorColumn = 0;
                            Vt100TerminalModel.this.cursorRow++;
                            this.scrollIfRequired();
                            continue block12;
                        }
                        case '\t': {
                            while (++Vt100TerminalModel.this.cursorColumn % 8 != 0) {
                            }
                            continue block12;
                        }
                        case '\u007f': {
                            if (Vt100TerminalModel.this.cursorColumn <= 0) continue block12;
                            ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).cursorRow][--((Vt100TerminalModel)Vt100TerminalModel.this).cursorColumn] = null;
                            continue block12;
                        }
                        case '\u0007': {
                            Vt100TerminalModel.this.bellStrategy.soundBell();
                            continue block12;
                        }
                        default: {
                            if (Vt100TerminalModel.this.cursorColumn >= Vt100TerminalModel.this.columns) {
                                Vt100TerminalModel.this.cursorColumn = 0;
                                Vt100TerminalModel.this.cursorRow++;
                            }
                            this.scrollIfRequired();
                            Color back = Vt100TerminalModel.this.backgroundBold ? SgrColor.COLOR_BRIGHT[Vt100TerminalModel.this.backgroundColor] : SgrColor.COLOR_NORMAL[Vt100TerminalModel.this.backgroundColor];
                            Color fore = Vt100TerminalModel.this.foregroundBold ? SgrColor.COLOR_BRIGHT[Vt100TerminalModel.this.foregroundColor] : SgrColor.COLOR_NORMAL[Vt100TerminalModel.this.foregroundColor];
                            ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).cursorRow][((Vt100TerminalModel)Vt100TerminalModel.this).cursorColumn++] = new TerminalCell(ch, back, fore);
                        }
                    }
                }
            }
            finally {
                Vt100TerminalModel.this.unlock();
            }
        }

        private void scrollIfRequired() {
            if (Vt100TerminalModel.this.cursorRow >= Vt100TerminalModel.this.bufferSize) {
                int diff;
                for (int i = diff = Vt100TerminalModel.this.cursorRow - Vt100TerminalModel.this.bufferSize + 1; i < Vt100TerminalModel.this.bufferSize; ++i) {
                    System.arraycopy(Vt100TerminalModel.this.cells[i], 0, Vt100TerminalModel.this.cells[i - diff], 0, Vt100TerminalModel.this.columns);
                }
                for (int row = 1; row < diff + 1; ++row) {
                    for (int i = 0; i < Vt100TerminalModel.this.columns; ++i) {
                        ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).bufferSize - row][i] = null;
                    }
                }
                Vt100TerminalModel.this.cursorRow = Vt100TerminalModel.this.cursorRow - diff;
            }
            if (Vt100TerminalModel.this.terminalScroller != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Vt100TerminalModel.this.terminalScroller.updateScrollBar();
                    }
                });
            }
        }
    }

    public static interface TerminalScroller {
        public void updateScrollBar();
    }
}

