/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.rsa;

import com.aem.utils.entropy.EntropyGatherer;
import com.aem.utils.entropy.TimedEntropyWrap;
import com.aem.utils.random.GenericRandom;
import com.aem.utils.random.ISAAC;
import com.aem.utils.rsa.RSAConstants;
import com.aem.utils.rsa.RSADecryptor;
import com.aem.utils.rsa.RSAEncryptor;
import java.math.BigInteger;
import java.util.Random;

public class RSAKeyGen
implements RSAConstants {
    private GenericRandom secure_rand;
    private static int PQ_BITS = 1400;
    public static final int SEEDBITS = 2048;
    public static final int SEEDBYTES = 256;
    BigInteger one = BigInteger.ONE;
    BigInteger zero = BigInteger.ZERO;
    private BigInteger[] privkey;
    private BigInteger[] privkeycrt;
    private BigInteger[] pubkey;

    public RSAKeyGen(int min_n_size, GenericRandom grand, EntropyGatherer ent, boolean preSeeded) {
        PQ_BITS = min_n_size;
        this.init(grand, ent, preSeeded);
    }

    public RSAKeyGen(int min_n_size) {
        PQ_BITS = min_n_size;
        this.init(new ISAAC(), new TimedEntropyWrap(), false);
    }

    public RSAKeyGen() {
        this.init(new ISAAC(), new TimedEntropyWrap(), false);
    }

    private void init(GenericRandom srand, EntropyGatherer ent, boolean preSeeded) {
        this.secure_rand = srand;
        long t = System.currentTimeMillis();
        if (!preSeeded) {
            this.secure_rand.init(ent.getBytes(2048));
            for (int i = 0; i < 100; ++i) {
                this.secure_rand.nextInt();
            }
        }
        t = System.currentTimeMillis() - t;
        t = System.currentTimeMillis();
        PrimeThread p1 = new PrimeThread();
        PrimeThread p2 = new PrimeThread();
        p1.rand.init(this.secure_rand.nextBytes(1024));
        p2.rand.init(this.secure_rand.nextBytes(1024));
        p1.start();
        p2.start();
        try {
            p1.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            p2.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BigInteger P = p1.PRIME;
        BigInteger Q = p2.PRIME;
        t = System.currentTimeMillis() - t;
        t = System.currentTimeMillis();
        t = System.currentTimeMillis() - t;
        BigInteger n = P.multiply(Q);
        BigInteger m = P.subtract(this.one).multiply(Q.subtract(this.one));
        BigInteger e = new BigInteger("20");
        while (!e.gcd(m).equals(this.one)) {
            e = e.add(this.one);
        }
        BigInteger d = e.modInverse(m);
        BigInteger dp = d.remainder(P.subtract(this.one));
        BigInteger dq = d.remainder(Q.subtract(this.one));
        BigInteger c2 = P.modInverse(Q);
        this.privkeycrt = new BigInteger[]{P, Q, dp, dq, c2, n};
        this.privkey = new BigInteger[]{n, d};
        this.pubkey = new BigInteger[]{n, e};
    }

    public BigInteger[] getPublicKey() {
        return this.pubkey;
    }

    public BigInteger[] getPrivateKey() {
        return this.privkey;
    }

    public BigInteger[] getPrivateKeyCRT() {
        return this.privkeycrt;
    }

    public static void main(String[] args) {
        int KEYS = 10;
        RSAKeyGen kgen = null;
        for (int Z = 0; Z < KEYS; ++Z) {
            System.out.println("Creating key...");
            long T = System.currentTimeMillis();
            if (args.length > 0) {
                try {
                    kgen = new RSAKeyGen(Integer.parseInt(args[0]));
                }
                catch (Exception e) {
                    System.out.println("If you specify an argument, it must be a valid key size");
                }
            } else {
                kgen = new RSAKeyGen(1024);
            }
            System.out.println("PRIME P (" + kgen.privkeycrt[0].bitLength() + ") = " + kgen.privkeycrt[0]);
            System.out.println("PRIME Q (" + kgen.privkeycrt[1].bitLength() + ") = " + kgen.privkeycrt[1]);
            System.out.println("Created key in " + (System.currentTimeMillis() - T) + "ms, encrypting...");
        }
        RSAEncryptor enc = new RSAEncryptor(kgen.getPublicKey());
        RSADecryptor dec = new RSADecryptor(kgen.getPrivateKeyCRT());
        Random craprand = new Random(System.currentTimeMillis());
        byte[] dat = new byte[1024];
        craprand.nextBytes(dat);
        long t = System.currentTimeMillis();
        byte[] cipher = enc.encrypt(dat);
        t = System.currentTimeMillis() - t;
        System.out.println("Encryption took = " + t + " ms");
        t = System.currentTimeMillis();
        byte[] plain = dec.decrypt(cipher);
        t = System.currentTimeMillis() - t;
        System.out.println("Decryption took = " + t + " ms");
        System.out.println("Plain message size = " + dat.length + " bytes");
        System.out.println("Encrypted message size = " + cipher.length + " bytes");
        if (dat.length != plain.length) {
            System.out.println("encrypted and decrypted length do not match (" + dat.length + ") Vs (" + plain.length + ")");
        }
        int failure = 0;
        for (int i = 0; i < dat.length; ++i) {
            if (dat[i] == plain[i]) continue;
            System.out.println("data at " + i + " differ");
            System.out.println("in  = " + dat[i]);
            System.out.println("out = " + plain[i]);
            if (++failure != 50) continue;
            System.exit(0);
        }
        System.out.println("Data encryption and decryption test successful");
    }

    class PrimeThread
    extends Thread {
        BigInteger PRIME;
        ISAAC rand = new ISAAC();

        PrimeThread() {
        }

        @Override
        public void run() {
            int size = PQ_BITS;
            this.PRIME = BigInteger.probablePrime(size, this.rand);
        }
    }
}

