/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.random;

import com.aem.utils.random.GenericRandom;

public class ISAAC
extends GenericRandom {
    private static final int SIZEL = 8;
    private static final int SIZE = 256;
    private static final int MASK = 1020;
    private int count;
    private int[] rsl;
    private int[] mem;
    private int a;
    private int b;
    private int c;

    @Override
    public boolean isCryptographicallySecure() {
        return true;
    }

    public ISAAC() {
        this.init();
    }

    public ISAAC(int seed) {
        this.init(seed);
    }

    public ISAAC(long seed) {
        this.init(seed);
    }

    public ISAAC(int[] seed) {
        this.init(seed);
    }

    @Override
    public synchronized void init() {
        this.c = 0;
        this.b = 0;
        this.a = 0;
        this.count = 0;
        this.mem = new int[256];
        this.rsl = new int[256];
        this.init(false);
    }

    @Override
    public synchronized void init(int seed) {
        this.c = 0;
        this.b = 0;
        this.a = 0;
        this.count = 0;
        this.mem = new int[256];
        this.rsl = new int[256];
        this.rsl[0] = seed;
        this.init(true);
    }

    @Override
    public synchronized void init(long seed) {
        this.c = 0;
        this.b = 0;
        this.a = 0;
        this.count = 0;
        this.mem = new int[256];
        this.rsl = new int[256];
        this.rsl[0] = (int)(seed >>> 32);
        this.rsl[1] = (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.init(true);
    }

    @Override
    public synchronized void init(int[] seed) {
        this.c = 0;
        this.b = 0;
        this.a = 0;
        this.count = 0;
        this.mem = new int[256];
        this.rsl = new int[256];
        int n = 0;
        for (int i = 0; i < seed.length; ++i) {
            if (n == this.rsl.length) {
                n = 0;
            }
            this.rsl[n] = this.rsl[n] ^ seed[i];
            ++n;
        }
        this.init(true);
    }

    @Override
    public synchronized void addEntropy(int seed) {
        this.rsl[0] = this.rsl[0] ^ seed;
        this.generate();
    }

    @Override
    public synchronized void addEntropy(long seed) {
        this.rsl[0] = this.rsl[0] ^ (int)(seed >>> 32);
        this.rsl[1] = this.rsl[1] ^ (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.generate();
    }

    @Override
    public synchronized void addEntropy(int[] seed) {
        int n = 0;
        for (int i = 0; i < seed.length; ++i) {
            if (n == this.rsl.length) {
                n = 0;
            }
            this.rsl[n] = this.rsl[n] ^ seed[i];
            ++n;
        }
        this.generate();
    }

    @Override
    public synchronized int getMaximumSeedComplexity() {
        return 2048;
    }

    private final synchronized void generate() {
        this.b += ++this.c;
        for (int i = 0; i < 256; ++i) {
            int y;
            int x = this.mem[i];
            switch (i & 3) {
                case 0: {
                    this.a ^= this.a << 13;
                    break;
                }
                case 1: {
                    this.a ^= this.a >>> 6;
                    break;
                }
                case 2: {
                    this.a ^= this.a << 2;
                    break;
                }
                case 3: {
                    this.a ^= this.a >>> 16;
                }
            }
            this.a += this.mem[i + 128 & 0xFF];
            this.mem[i] = y = this.mem[(x & 0x3FC) >> 2] + this.a + this.b;
            this.rsl[i] = this.b = this.mem[(y >> 8 & 0x3FC) >> 2] + x;
        }
    }

    private final synchronized void init(boolean flag) {
        int i;
        int h = -1640531527;
        int g = -1640531527;
        int f = -1640531527;
        int e = -1640531527;
        int d = -1640531527;
        int c = -1640531527;
        int b = -1640531527;
        int a = -1640531527;
        for (i = 0; i < 4; ++i) {
            d += (a ^= b << 11);
            b += c;
            e += (b ^= c >>> 2);
            c += d;
            f += (c ^= d << 8);
            d += e;
            g += (d ^= e >>> 16);
            e += f;
            h += (e ^= f << 10);
            f += g;
            a += (f ^= g >>> 4);
            g += h;
            b += (g ^= h << 8);
            h += a;
            c += (h ^= a >>> 9);
            a += b;
        }
        for (i = 0; i < 256; i += 8) {
            if (flag) {
                a += this.rsl[i];
                b += this.rsl[i + 1];
                c += this.rsl[i + 2];
                d += this.rsl[i + 3];
                e += this.rsl[i + 4];
                f += this.rsl[i + 5];
                g += this.rsl[i + 6];
                h += this.rsl[i + 7];
            }
            d += (a ^= b << 11);
            b += c;
            e += (b ^= c >>> 2);
            c += d;
            f += (c ^= d << 8);
            d += e;
            g += (d ^= e >>> 16);
            e += f;
            h += (e ^= f << 10);
            f += g;
            a += (f ^= g >>> 4);
            g += h;
            b += (g ^= h << 8);
            h += a;
            c += (h ^= a >>> 9);
            this.mem[i] = a += b;
            this.mem[i + 1] = b;
            this.mem[i + 2] = c;
            this.mem[i + 3] = d;
            this.mem[i + 4] = e;
            this.mem[i + 5] = f;
            this.mem[i + 6] = g;
            this.mem[i + 7] = h;
        }
        if (flag) {
            for (i = 0; i < 256; i += 8) {
                a += this.mem[i];
                b += this.mem[i + 1];
                c += this.mem[i + 2];
                d += this.mem[i + 3];
                e += this.mem[i + 4];
                f += this.mem[i + 5];
                g += this.mem[i + 6];
                h += this.mem[i + 7];
                d += (a ^= b << 11);
                b += c;
                e += (b ^= c >>> 2);
                c += d;
                f += (c ^= d << 8);
                d += e;
                g += (d ^= e >>> 16);
                e += f;
                h += (e ^= f << 10);
                f += g;
                a += (f ^= g >>> 4);
                g += h;
                b += (g ^= h << 8);
                h += a;
                c += (h ^= a >>> 9);
                this.mem[i] = a += b;
                this.mem[i + 1] = b;
                this.mem[i + 2] = c;
                this.mem[i + 3] = d;
                this.mem[i + 4] = e;
                this.mem[i + 5] = f;
                this.mem[i + 6] = g;
                this.mem[i + 7] = h;
            }
        }
        this.generate();
        this.count = 256;
    }

    @Override
    public final synchronized int nextUniformInt() {
        if (0 == this.count--) {
            this.generate();
            this.count = 255;
        }
        return this.rsl[this.count];
    }
}

