/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.keyhandling;

import com.aem.utils.keyhandling.KeyRequest;
import utils.ostools.OS;

public class ModifierState {
    public boolean controlDown = false;
    public boolean altDown = false;
    public boolean shiftDown = false;
    public boolean altGrDown = false;
    public boolean windowsKeyDown = false;
    public boolean metaKeyDown = false;

    public ModifierState() {
    }

    public ModifierState(int modifiers) {
        this.altDown = (modifiers & 4) == 4;
        this.shiftDown = (modifiers & 1) == 1;
        this.controlDown = (modifiers & 2) == 2;
        boolean bl = this.altGrDown = (modifiers & 0x10) == 16;
        if (OS.isWindows()) {
            this.windowsKeyDown = (modifiers & 8) == 8;
        } else if (OS.isMacOS()) {
            this.metaKeyDown = (modifiers & 8) == 8;
        }
    }

    public ModifierState(KeyRequest key) {
        this.altDown = key.altDown();
        this.controlDown = key.controlDown();
        this.shiftDown = key.shiftDown();
        this.altGrDown = key.altGrDown();
        if (OS.isWindows()) {
            this.windowsKeyDown = key.metaDown();
        } else if (OS.isMacOS()) {
            this.metaKeyDown = key.metaDown();
        }
    }

    public Object clone() {
        ModifierState state = new ModifierState();
        state.controlDown = this.controlDown;
        state.altDown = this.altDown;
        state.shiftDown = this.shiftDown;
        state.windowsKeyDown = this.windowsKeyDown;
        state.metaKeyDown = this.metaKeyDown;
        state.altGrDown = this.altGrDown;
        return state;
    }

    public String toString() {
        return "cntl: " + this.controlDown + " alt:" + this.altDown + " gr:" + this.altGrDown + " shift:" + this.shiftDown + " win:" + this.windowsKeyDown + " meta:" + this.metaKeyDown;
    }
}

