/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.keyhandling;

import java.awt.event.KeyEvent;
import utils.message.Message;

public class KeyRequest {
    public boolean keyPressed = true;
    public boolean preferMappedMode = false;
    public int characterTyped = -1;
    public int modifiers = 0;
    public int keyCode = 0;

    public boolean metaDown() {
        return (this.modifiers & 8) == 8;
    }

    public boolean altDown() {
        return (this.modifiers & 4) == 4;
    }

    public boolean shiftDown() {
        return (this.modifiers & 1) == 1;
    }

    public boolean controlDown() {
        return (this.modifiers & 2) == 2;
    }

    public boolean altGrDown() {
        return (this.modifiers & 0x10) == 16;
    }

    public String toString() {
        String mod = "";
        if (this.metaDown()) {
            mod = mod + "m";
        }
        if (this.altDown()) {
            mod = mod + "a";
        }
        if (this.altGrDown()) {
            mod = mod + "g";
        }
        if (this.shiftDown()) {
            mod = mod + "s";
        }
        if (this.controlDown()) {
            mod = mod + "c";
        }
        return "KeyRequest down:" + this.keyPressed + " code:" + this.keyCode + " preferMap:" + this.preferMappedMode + " (char:" + (char)this.characterTyped + " / charInt:" + this.characterTyped + ") / charValid:" + this.charIsValid() + " / keyValid:" + this.keyIsValid() + " / modifiers:" + mod + ")";
    }

    public boolean charIsValid() {
        return this.characterTyped != 65535;
    }

    public boolean keyIsValid() {
        return this.keyCode != 0;
    }

    public boolean isKeyDown() {
        return this.keyPressed;
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.keyPressed);
        m.append(this.preferMappedMode);
        m.append(this.characterTyped);
        m.append(this.modifiers);
        m.append(this.keyCode);
        return m;
    }

    public static KeyRequest fromMessage(Message m) {
        m.resetIndex();
        KeyRequest req = new KeyRequest();
        req.keyPressed = m.getNextBoolean();
        req.preferMappedMode = m.getNextBoolean();
        req.characterTyped = m.getNextInt();
        req.modifiers = m.getNextInt();
        req.keyCode = m.getNextInt();
        return req;
    }

    public static KeyRequest getKeyRequest(KeyEvent event, boolean useMappedMode, boolean keyPressed) {
        KeyRequest request = new KeyRequest();
        request.keyPressed = keyPressed;
        request.preferMappedMode = useMappedMode;
        request.characterTyped = event.getKeyChar();
        request.keyCode = event.getKeyCode();
        request.modifiers = 0;
        if (event.isAltDown()) {
            request.modifiers = KeyRequest.setAltDown(request.modifiers);
        }
        if (event.isShiftDown()) {
            request.modifiers = KeyRequest.setShiftDown(request.modifiers);
        }
        if (event.isControlDown()) {
            request.modifiers = KeyRequest.setControlDown(request.modifiers);
        }
        if (event.isAltGraphDown()) {
            request.modifiers = KeyRequest.setAltGraphDown(request.modifiers);
        }
        return request;
    }

    public static KeyRequest getKeyRequestForCode(int vkCode, boolean down) {
        KeyRequest req = new KeyRequest();
        req.characterTyped = 65535;
        req.keyCode = vkCode;
        req.keyPressed = down;
        req.preferMappedMode = false;
        return req;
    }

    public static KeyRequest getKeyRequestForChar(char c) {
        KeyRequest req = new KeyRequest();
        req.characterTyped = c;
        req.keyCode = 0;
        req.keyPressed = true;
        req.preferMappedMode = true;
        return req;
    }

    public static int setShiftDown(int modifiers) {
        return modifiers | 1;
    }

    public static int setControlDown(int modifiers) {
        return modifiers | 2;
    }

    public static int setAltDown(int modifiers) {
        return modifiers | 4;
    }

    public static int setMetaDown(int modifiers) {
        return modifiers | 8;
    }

    public static int setAltGraphDown(int modifiers) {
        return modifiers | 0x10;
    }
}

