/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.crc;

import com.aem.utils.blowfish.Blowfish;
import com.aem.utils.crc.CRC;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class BlowfishCRC
extends CRC {
    Blowfish bfish = new Blowfish();
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    int len;
    byte[] digest;

    public BlowfishCRC() {
        this.len = 1024;
        this.reset();
    }

    public BlowfishCRC(int bytes) {
        this.len = bytes;
        this.reset();
    }

    @Override
    public void reset() {
        this.bfish = new Blowfish();
        this.digest = new byte[this.len];
        Arrays.fill(this.digest, (byte)0);
    }

    @Override
    public void add(byte b) {
        this.bout.write(b);
        if (this.bout.size() == 76) {
            this.doHash();
        }
    }

    @Override
    public byte[] getDigest() {
        byte[] orig = (byte[])this.digest.clone();
        if (this.bout.size() > 0) {
            this.doHash();
        }
        byte[] ret = this.digest;
        this.digest = orig;
        return ret;
    }

    private void doHash() {
        this.bfish.init(this.bout.toByteArray());
        this.bout.reset();
        this.digest = this.bfish.hashSecure(this.digest, 0, this.digest.length);
    }
}

