/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.blowfish;

import com.aem.utils.blowfish.Blowfish;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BlowfishFileEncryptor {
    private static String[] cutArg(String[] args, int a) {
        String[] newargs = new String[args.length - 1];
        for (int i = 0; i < args.length; ++i) {
            if (i == a) continue;
            if (i < a) {
                newargs[i] = args[i];
                continue;
            }
            if (i <= a) continue;
            newargs[i - 1] = args[i];
        }
        return newargs;
    }

    public static void main(String[] args) {
        Blowfish bf = new Blowfish();
        if (!bf.test()) {
            System.out.println("error, test failed");
            return;
        }
        System.out.println("blowfish encryption working ok :)");
        boolean usage = true;
        boolean verify = true;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-nv")) continue;
            args = BlowfishFileEncryptor.cutArg(args, i);
            verify = false;
        }
        if (args.length > 1) {
            if (args[0].equals("-d") && args.length > 2) {
                usage = false;
                try {
                    String key = args[1];
                    String filename = args[2];
                    FileInputStream fin = new FileInputStream(filename);
                    int n = filename.toLowerCase().lastIndexOf(".fish");
                    if (n == -1) {
                        System.out.println("The file does not have a .fish extenstion");
                        System.exit(0);
                    }
                    filename = filename.substring(0, n);
                    FileOutputStream fout = new FileOutputStream(filename);
                    BufferedInputStream bin = new BufferedInputStream(fin);
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    DataInputStream din = new DataInputStream(bin);
                    DataOutputStream dout = new DataOutputStream(bout);
                    bf.init(key);
                    int size = din.readInt();
                    System.out.println("Decrypting...");
                    BlowfishFileEncryptor.passThrough(bf, size, din, dout, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (!args.equals("-d")) {
                usage = false;
                try {
                    String key = args[0];
                    String filename = args[1];
                    FileInputStream fin = new FileInputStream(filename);
                    FileOutputStream fout = new FileOutputStream(filename + ".fish");
                    BufferedInputStream bin = new BufferedInputStream(fin);
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    DataInputStream din = new DataInputStream(bin);
                    DataOutputStream dout = new DataOutputStream(bout);
                    bf.init(key);
                    int size = fin.available();
                    dout.writeInt(size);
                    System.out.println("Encrypting...");
                    BlowfishFileEncryptor.passThrough(bf, size, din, dout, true);
                    if (verify) {
                        File tmpout = new File(System.currentTimeMillis() + ".temporary");
                        int n = 0;
                        while (tmpout.exists()) {
                            tmpout = new File(System.currentTimeMillis() + ".temporary_" + ++n);
                        }
                        tmpout.deleteOnExit();
                        fin = new FileInputStream(filename + ".fish");
                        fout = new FileOutputStream(tmpout);
                        bin = new BufferedInputStream(fin);
                        bout = new BufferedOutputStream(fout);
                        din = new DataInputStream(bin);
                        dout = new DataOutputStream(bout);
                        key = args[0];
                        bf.init(key);
                        size = din.readInt();
                        System.out.println("Verifying (Decrypting)...");
                        BlowfishFileEncryptor.passThrough(bf, size, din, dout, false);
                        fin.close();
                        fout.close();
                        FileInputStream tmp1 = new FileInputStream(filename);
                        FileInputStream tmp2 = new FileInputStream(tmpout);
                        System.out.println("Verifying (Comparing)...");
                        BlowfishFileEncryptor.verify(tmp1, tmp2, size);
                        tmp1.close();
                        tmp2.close();
                    }
                }
                catch (Exception e) {
                    System.out.println("Error:" + e.getMessage());
                    System.exit(-1);
                }
            }
        }
        if (usage) {
            System.out.println("Usage: java Blowfish [-nv] [-d] <key> <file>");
            System.out.println("\t-d\t\tdecrypt (default is to encrypt)");
            System.out.println("\t-nv\t\tdo not verify data");
        }
    }

    private static void verify(InputStream orig, InputStream dec, int max) throws IOException {
        byte[] b1 = new byte[4096];
        byte[] b2 = new byte[4096];
        double pcmult = max;
        pcmult = 100.0 / pcmult;
        int total = 0;
        block0: while (true) {
            int t1;
            int r1 = 0;
            int r2 = 0;
            int t2 = 0;
            for (t1 = 0; t1 != b1.length && (r1 = orig.read(b1, 0, b1.length)) != -1; t1 += r1) {
            }
            while (t2 != b2.length && (r2 = dec.read(b2, 0, b2.length)) != -1) {
                t2 += r2;
            }
            if (t1 != t2) {
                throw new IOException("Data do not match");
            }
            if (r1 == -1 && r2 == -1) break;
            int i = 0;
            while (true) {
                if (i >= t1) continue block0;
                if (++total % 16384 == 0) {
                    System.out.print("\r" + (int)((double)total * pcmult) + "%");
                }
                if (b1[i] != b2[i]) {
                    throw new IOException("Data do not match");
                }
                ++i;
            }
            break;
        }
        System.out.println("\r100% - all data verified ok");
    }

    private static void passThrough(Blowfish bf, int size, DataInputStream in, DataOutputStream dout, boolean encrypt) throws IOException {
        int L = 0;
        int R = 0;
        int ints = 0;
        byte[] intbuffer = new byte[8];
        double pcmult = size;
        pcmult = 100.0 / pcmult;
        int total = 0;
        int read = 0;
        int written = 0;
        while (true) {
            for (int i = 0; i < 4; ++i) {
                intbuffer[i] = 0;
                intbuffer[i + 4] = 0;
            }
            read = in.read(intbuffer);
            if (read == -1) break;
            L = (intbuffer[0] & 0xFF) << 24 | (intbuffer[1] & 0xFF) << 16 | (intbuffer[2] & 0xFF) << 8 | intbuffer[3] & 0xFF;
            R = (intbuffer[4] & 0xFF) << 24 | (intbuffer[5] & 0xFF) << 16 | (intbuffer[6] & 0xFF) << 8 | intbuffer[7] & 0xFF;
            long tmplong = encrypt ? bf.encrypt(L, R) : bf.decrypt(L, R);
            L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
            intbuffer[0] = (byte)(0xFF & L >>> 24);
            intbuffer[1] = (byte)(0xFF & L >>> 16);
            intbuffer[2] = (byte)(0xFF & L >>> 8);
            intbuffer[3] = (byte)(0xFF & L);
            intbuffer[4] = (byte)(0xFF & R >>> 24);
            intbuffer[5] = (byte)(0xFF & R >>> 16);
            intbuffer[6] = (byte)(0xFF & R >>> 8);
            intbuffer[7] = (byte)(0xFF & R);
            written += 8;
            if ((total += 8) % 16384 == 0) {
                System.out.print("\r" + (int)((double)total * pcmult) + "%");
            }
            if (written > size && !encrypt) {
                dout.write(intbuffer, 0, size - written + 8);
            } else {
                dout.write(intbuffer, 0, 8);
            }
            ints += 2;
        }
        dout.flush();
        System.out.println("\r100% - all data " + (encrypt ? "encrypted" : "decrypted") + " ok");
    }
}

