/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.authentication;

import com.aem.utils.authentication.AuthenticationRequest;
import com.aem.utils.authentication.SHRadiusAuthenticator;
import com.aem.utils.authentication.ServerAuthenticationHandler;
import net.jradius.exception.TimeoutException;
import utils.radius.ChallengeHandler;

public class RadiusAuthenticationRequest
extends AuthenticationRequest {
    public final int numberOfRetries;
    public final long timeoutMS;
    public String authenticationProtocol;
    public String hostname;
    public int port;
    public String secret;
    public ChallengeHandler challengeHandler;

    public RadiusAuthenticationRequest(Object finishedLock, int numberOfRetries, long timeoutMS) {
        super(finishedLock);
        this.numberOfRetries = numberOfRetries;
        this.timeoutMS = timeoutMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate() throws Exception {
        try {
            boolean bl = SHRadiusAuthenticator.authenticate(this);
            return bl;
        }
        catch (Exception t) {
            if (t instanceof TimeoutException) {
                ServerAuthenticationHandler.ServerConnectException ex = new ServerAuthenticationHandler.ServerConnectException(t.getMessage());
                ex.initCause(t);
                throw ex;
            }
            throw t;
        }
        finally {
            if (this.finishedLock != null) {
                Object object = this.finishedLock;
                synchronized (object) {
                    this.finishedLock.notify();
                }
            }
        }
    }
}

