/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.LogicalArray;
import com.aem.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class NonNativeLogicalArray
implements LogicalArray {
    int logicalWidth;
    int logicalHeight;
    public int[] source;
    int sourceWidth;
    int totalOffset;
    private static final int ENCODE_KEY = 1;
    private static final int REPLACE_KEY = 2;
    static int[] bufferArray = null;

    public void setSource(int[] source) {
        this.source = source;
    }

    static long[] getSpeed() {
        int[] source = new int[100000];
        NonNativeLogicalArray ar = new NonNativeLogicalArray(0, 0, source, 100, 0, 0);
        long chunkScanlinesPerSecond = 0L;
        long t = System.currentTimeMillis() + 100L;
        while (System.currentTimeMillis() < t) {
            for (int i = 0; i < 1000; ++i) {
                ar.arraycopy(0, 0, source, 0, 32);
                ++chunkScanlinesPerSecond;
            }
        }
        chunkScanlinesPerSecond *= 10L;
        long pixelOpsPerSecond = 0L;
        long t2 = System.currentTimeMillis() + 100L;
        while (System.currentTimeMillis() < t2) {
            for (int i = 0; i < 1000; ++i) {
                ar.setXY(0, 0, 0);
                ++pixelOpsPerSecond;
            }
        }
        System.out.println("[NonNativeLogicalArray] Approximately " + chunkScanlinesPerSecond + " chunk scanlines per second");
        System.out.println("[NonNativeLogicalArray] Approximately " + (pixelOpsPerSecond *= 10L) + " pixel ops per second");
        return new long[]{chunkScanlinesPerSecond, pixelOpsPerSecond};
    }

    protected NonNativeLogicalArray() {
    }

    public NonNativeLogicalArray(int logicalWidth, int logicalHeight, int[] source, int sourceWidth, int sourceX, int sourceY) {
        this(logicalWidth, logicalHeight, source, sourceWidth, sourceX + sourceY * sourceWidth);
    }

    public NonNativeLogicalArray(int logicalWidth, int logicalHeight, int[] source, int sourceWidth, int totalOffset) {
        this.logicalWidth = logicalWidth;
        this.logicalHeight = logicalHeight;
        this.source = source;
        this.sourceWidth = sourceWidth;
        this.totalOffset = totalOffset;
    }

    private NonNativeLogicalArray(int logicalWidth, int logicalHeight, NonNativeLogicalArray la, int sourceX, int sourceY) {
        this.logicalWidth = logicalWidth;
        this.logicalHeight = logicalHeight;
        this.source = la.source;
        this.sourceWidth = la.sourceWidth;
        this.totalOffset = la.getSourceOffset(sourceX, sourceY);
    }

    public NonNativeLogicalArray getSubArray(int sourceX, int sourceY, int logicalWidth, int logicalHeight) {
        return new NonNativeLogicalArray(logicalWidth, logicalHeight, this, sourceX, sourceY);
    }

    public NonNativeLogicalArray getSubArray(int sourceX, int sourceY, int logicalWidth, int logicalHeight, NonNativeLogicalArray into) {
        into.logicalWidth = logicalWidth;
        into.logicalHeight = logicalHeight;
        into.source = this.source;
        into.sourceWidth = this.sourceWidth;
        into.totalOffset = this.getSourceOffset(sourceX, sourceY);
        return into;
    }

    @Override
    public int getWidth() {
        return this.logicalWidth;
    }

    @Override
    public int getHeight() {
        return this.logicalHeight;
    }

    @Override
    public int getYOffset(int y) {
        int off = this.totalOffset;
        return off += y * this.sourceWidth;
    }

    @Override
    public int getSourceOffset(int x, int y) {
        return this.getYOffset(y) + x;
    }

    @Override
    public int getXY(int x, int y) {
        return this.source[this.getSourceOffset(x, y)];
    }

    @Override
    public void setXY(int x, int y, int val) {
        int index = this.getSourceOffset(x, y);
        if (index < this.source.length) {
            this.source[index] = val;
        }
    }

    public void arraycopyScanline(int myY, NonNativeLogicalArray logicalArray, int logicalY) {
        int myOffset = this.getSourceOffset(0, myY);
        int logicalOffset = logicalArray.getSourceOffset(0, logicalY);
        System.arraycopy(this.source, myOffset, logicalArray.source, logicalOffset, this.logicalWidth);
    }

    public void arraycopyPartialScanline(int myX, int myY, NonNativeLogicalArray logicalArray, int logicalX, int logicalY, int width) {
        int myOffset = this.getSourceOffset(myX, myY);
        int logicalOffset = logicalArray.getSourceOffset(logicalX, logicalY);
        System.arraycopy(this.source, myOffset, logicalArray.source, logicalOffset, width);
    }

    public void arraycopy(int x, int y, int[] dest, int off, int w) {
        System.arraycopy(this.source, this.getSourceOffset(x, y), dest, off, w);
    }

    public void toStream(OutputStream out) throws IOException {
        StreamUtils.writeInt(out, this.logicalWidth);
        StreamUtils.writeInt(out, this.logicalHeight);
        StreamUtils.writeInt(out, this.sourceWidth);
        StreamUtils.writeInt(out, this.totalOffset);
        StreamUtils.writeInt(out, this.source.length);
        if (this.source.length > 0) {
            int currentInt = this.source[0];
            int currentCount = 1;
            for (int i = 1; i < this.source.length; ++i) {
                int newInt = this.source[i];
                if (newInt == 1) {
                    newInt = 2;
                }
                if (newInt != currentInt) {
                    if (currentCount == 1) {
                        StreamUtils.writeInt(out, currentInt);
                    } else {
                        StreamUtils.writeInt(out, 1);
                        StreamUtils.writeInt(out, currentCount);
                        StreamUtils.writeInt(out, currentInt);
                    }
                    currentCount = 1;
                    currentInt = newInt;
                    continue;
                }
                ++currentCount;
            }
            if (currentCount == 1) {
                StreamUtils.writeInt(out, currentInt);
            } else {
                StreamUtils.writeInt(out, 1);
                StreamUtils.writeInt(out, currentCount);
                StreamUtils.writeInt(out, currentInt);
            }
        }
    }

    public static NonNativeLogicalArray fromStream(InputStream in) throws IOException {
        int logicalWidth = StreamUtils.readInt(in);
        int logicalHeight = StreamUtils.readInt(in);
        int sourceWidth = StreamUtils.readInt(in);
        int totalOffset = StreamUtils.readInt(in);
        int length = StreamUtils.readInt(in);
        if (bufferArray == null || bufferArray.length < length) {
            bufferArray = new int[length];
        }
        int i = 0;
        while (i < length) {
            int newInt = StreamUtils.readInt(in);
            if (newInt != 1) {
                NonNativeLogicalArray.bufferArray[i++] = newInt;
                continue;
            }
            int count = StreamUtils.readInt(in);
            newInt = StreamUtils.readInt(in);
            for (int change = 0; change < count; ++change) {
                NonNativeLogicalArray.bufferArray[i++] = newInt;
            }
        }
        return new NonNativeLogicalArray(logicalWidth, logicalHeight, bufferArray, sourceWidth, totalOffset);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                sb.append(this.getXY(x, y));
                if (x >= this.getWidth() - 1) continue;
                sb.append(',');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(NonNativeLogicalArray.getSpeed());
        int[] src = new int[100];
        for (int i = 0; i < src.length; ++i) {
            src[i] = i;
        }
        int[] array = new int[10000000];
        int[] array2 = new int[10000000];
        long start = System.currentTimeMillis();
        for (int i = 0; i < array.length; ++i) {
            array2[i] = array[i];
        }
        long end = System.currentTimeMillis();
        System.out.println("Old copy = " + (end - start));
        start = System.currentTimeMillis();
        System.arraycopy(array, 0, array2, 0, array.length);
        end = System.currentTimeMillis();
        System.out.println("Old copy = " + (end - start));
        start = System.currentTimeMillis();
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
        end = System.currentTimeMillis();
        System.out.println("Total = " + (end - start));
        start = System.currentTimeMillis();
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
        end = System.currentTimeMillis();
        System.out.println("Total = " + (end - start));
        start = System.currentTimeMillis();
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
        end = System.currentTimeMillis();
        System.out.println("Total = " + (end - start));
        long start2 = System.currentTimeMillis();
        Arrays.fill(array, 0);
        long end2 = System.currentTimeMillis();
        System.out.println("Total = " + (end2 - start2));
        start2 = System.currentTimeMillis();
        Arrays.fill(array, 10);
        end2 = System.currentTimeMillis();
        System.out.println("Total = " + (end2 - start2));
        start2 = System.currentTimeMillis();
        Arrays.fill(array, 10);
        end2 = System.currentTimeMillis();
        System.out.println("Total = " + (end2 - start2));
        System.out.println(new NonNativeLogicalArray(10, 10, src, 10, 0, 0));
        System.out.println(new NonNativeLogicalArray(5, 5, src, 10, 5, 5));
        System.out.println(new NonNativeLogicalArray(5, 5, src, 10, 0, 0));
        System.out.println(new NonNativeLogicalArray(3, 3, src, 10, 1, 1));
        System.out.println(new NonNativeLogicalArray(10, 10, src, 10, 0, 0).getSubArray(1, 1, 8, 8));
    }
}

