/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.FilteringUtil;
import com.aem.utils.LogicalArray;
import com.aem.utils.NonNativeLogicalArray;

public class NonNativeFilteringUtil
implements FilteringUtil {
    boolean new_image = false;
    int[] prev_image;
    NonNativeLogicalArray prevScreenArray;
    NonNativeLogicalArray screenGrabArray;
    NonNativeLogicalArray screenChunkArray;

    @Override
    public void chunksBegin(int scr_w, int scr_h, int grab_x, int grab_y, int grab_w, int grab_h) {
        int scr_siz = scr_w * scr_h;
        if (this.prev_image == null) {
            this.prev_image = new int[scr_siz];
            this.new_image = true;
        }
        if (this.prev_image.length != scr_siz) {
            this.prev_image = new int[scr_siz];
            this.new_image = true;
        }
        this.prevScreenArray = new NonNativeLogicalArray(scr_w, scr_h, null, scr_w, 0);
        this.screenGrabArray = this.prevScreenArray.getSubArray(grab_x, grab_y, grab_w, grab_h);
        this.screenGrabArray.setSource(this.prev_image);
        this.prevScreenArray.setSource(this.prev_image);
        this.screenChunkArray = this.screenGrabArray.getSubArray(0, 0, 0, 0);
    }

    public NonNativeLogicalArray getEntireScreen() {
        return this.prevScreenArray;
    }

    @Override
    public boolean mustSendAllChunks() {
        return this.new_image;
    }

    @Override
    public void chunksFinished() {
        this.new_image = false;
    }

    @Override
    public boolean workingOK() {
        return true;
    }

    @Override
    public void clearScreen() {
        this.prev_image = null;
    }

    @Override
    public void releaseMemory() {
        this.prev_image = null;
    }

    @Override
    public LogicalArray getLogicalArrayForChunk(int x, int y, int w, int h) {
        this.screenChunkArray = this.screenGrabArray.getSubArray(x, y, w, h, this.screenChunkArray);
        return this.screenChunkArray;
    }

    @Override
    public void setLogicalArrayForPreviousChunk(NonNativeLogicalArray array) {
        int h = this.screenChunkArray.getHeight();
        for (int dy = 0; dy < h; ++dy) {
            array.arraycopyScanline(dy, this.screenChunkArray, dy);
        }
    }
}

