/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.NativeLibraryLoader;
import java.io.File;
import java.util.ArrayList;
import utils.ostools.OS;

public class NativeEventUtil {
    static String libdir;
    static NativeEventUtil nutils;
    private ArrayList eventListeners = new ArrayList();

    private native void setNativeEventListener();

    private native void removeNativeEventListener();

    public static String getLibDir() {
        return libdir;
    }

    private NativeEventUtil() {
        if (!OS.isWindowsPreXp()) {
            System.out.println("[NativeEventUtil] Setting global native event listener...");
            this.setNativeEventListener();
            System.out.println("[NativeEventUtil] Done setting global native event listener.");
        }
    }

    public void addEventListener(NativeEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public static NativeEventUtil getInstance() {
        if (NativeLibraryLoader.isNativeLibraryLoadedOK() && nutils == null) {
            try {
                nutils = new NativeEventUtil();
            }
            catch (Throwable t) {
                System.out.println("[NativeEventUtil] No event utility found. (" + t.getMessage() + ")");
            }
        }
        return nutils;
    }

    public void sessionDeactivated() {
        System.out.println("[NativeEventUtil] Session deactivated");
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ((NativeEventListener)this.eventListeners.get(i)).sessionDeactivated();
        }
    }

    public void sessionActivated() {
        System.out.println("[NativeEventUtil] Session activated");
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ((NativeEventListener)this.eventListeners.get(i)).sessionActivated();
        }
    }

    public void powerOrLogoff() {
        System.out.println("[NativeEventUtil] Session power or logoff");
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ((NativeEventListener)this.eventListeners.get(i)).powerOrLogoff();
        }
    }

    public void willSleep() {
        System.out.println("[NativeEventUtil] Session sleep");
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ((NativeEventListener)this.eventListeners.get(i)).willSleep();
        }
    }

    public void didWake() {
        System.out.println("[NativeEventUtil] Session wake");
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ((NativeEventListener)this.eventListeners.get(i)).didWake();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        NativeLibraryLoader.loadLibrary(new File("."));
        NativeEventUtil.getInstance().addEventListener(new NativeEventListener(){

            @Override
            public void sessionDeactivated() {
                System.out.println("sessionDeactivated");
            }

            @Override
            public void sessionActivated() {
                System.out.println("sessionActivated");
            }

            @Override
            public void powerOrLogoff() {
                System.out.println("powerOrLogoff");
            }

            @Override
            public void willSleep() {
                System.out.println("willSleep");
            }

            @Override
            public void didWake() {
                System.out.println("didWake");
            }
        });
        Thread.sleep(10000L);
    }

    public static interface NativeEventListener {
        public void sessionDeactivated();

        public void sessionActivated();

        public void powerOrLogoff();

        public void willSleep();

        public void didWake();
    }
}

