/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    public static File findFirstExistingFile(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].exists()) continue;
            return files[i];
        }
        return null;
    }

    public static String readFileString(String path) throws IOException {
        return new String(FileUtils.readFileBinary(path));
    }

    public static byte[] readFileBinary(String path) throws IOException {
        return FileUtils.readFileBinary(new BufferedInputStream(new FileInputStream(path), 10240));
    }

    public static String readFileString(InputStream file) throws IOException {
        return new String(FileUtils.readFileBinary(file));
    }

    public static byte[] readFileBinary(InputStream file) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = file.read(buf, 0, 1024);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        file.close();
        return bout.toByteArray();
    }

    public static void deleteDirectoryAndContents(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.deleteDirectoryAndContents(files[i]);
            }
            file.delete();
        }
    }
}

