/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.multiplex.MultiplexerByteInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import utils.switches.Switches;

public class DualPrintstream {
    Object LOCK = new Object();
    ArrayList ps = new ArrayList();
    ArrayList ds = new ArrayList();
    ArrayList readers = new ArrayList();
    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM HH:mm:ss.SSS: ");

    public OutputStream addOutputStream() {
        MultiplexerByteInputStream bin = new MultiplexerByteInputStream(Switches.SH_1839_dualPrintStreamNoBufferLimit ? -1 : 100000, false);
        ByteArrayInPrinter printer = new ByteArrayInPrinter(bin);
        RePrinter reprinter = new RePrinter(new BufferedReader(new InputStreamReader(bin)));
        reprinter.start();
        return printer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDateStream(PrintStream pp) {
        Object object = this.LOCK;
        synchronized (object) {
            this.ds.add(pp);
            System.out.println("[DualPrintStream] added ds " + pp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThroughStream(PrintStream pp) {
        Object object = this.LOCK;
        synchronized (object) {
            this.ps.add(pp);
            System.out.println("[DualPrintStream] added ts " + this.ps);
        }
    }

    class ByteArrayInPrinter
    extends OutputStream {
        MultiplexerByteInputStream bin;

        public ByteArrayInPrinter(MultiplexerByteInputStream bin) {
            this.bin = bin;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
            this.bin.addData(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            byte[] dat = new byte[len];
            System.arraycopy(b, off, dat, 0, len);
            this.bin.addData(dat);
        }

        @Override
        public void write(int b) {
            this.bin.addData(new byte[]{(byte)b});
        }
    }

    public class RePrinter
    extends Thread {
        BufferedReader bread;

        public RePrinter(BufferedReader bread) {
            super("DualPrintStream-Reprinter");
            this.bread = bread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    String s = this.bread.readLine();
                    Date date = new Date(System.currentTimeMillis());
                    if (s == null) {
                        return;
                    }
                    Object object = DualPrintstream.this.LOCK;
                    synchronized (object) {
                        PrintStream pp;
                        int i;
                        String dates = DualPrintstream.this.sdf.format(date);
                        for (i = 0; i < DualPrintstream.this.ps.size(); ++i) {
                            pp = (PrintStream)DualPrintstream.this.ps.get(i);
                            pp.println(s);
                            pp.flush();
                        }
                        for (i = 0; i < DualPrintstream.this.ds.size(); ++i) {
                            pp = (PrintStream)DualPrintstream.this.ds.get(i);
                            pp.print(dates);
                            pp.print(s);
                            pp.print("\r\n");
                            pp.flush();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

