/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressionUtil {
    public static byte[] compressString(String source, String encoding) {
        if (source == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzout = new GZIPOutputStream(bout);
            gzout.write(source.getBytes(encoding));
            gzout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
        return bout.toByteArray();
    }

    public static String decompressString(byte[] data, String encoding) {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream bout = new ByteArrayInputStream(data);
        try {
            GZIPInputStream gzin = new GZIPInputStream(bout);
            return new String(StreamUtils.readAll(gzin), encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

