/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests.suites.tests;

import com.aem.tests.TestUtils;
import com.aem.tests.suites.ContinuousTestSpec;
import com.aem.tests.suites.LargeContinuousTest;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTesting;
import utils.ostools.OSDirs;
import utils.string.Padder;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;

public class SessionStageTest
extends LargeContinuousTest {
    int sessions;
    RootPaneContainer rpc;
    static int N = 0;

    private SessionStageTest(RootPaneContainer rpc, ContinuousTestSpec spec, int sessions) {
        super(spec);
        this.rpc = rpc;
        this.sessions = sessions;
    }

    public static SessionStageTest createSessionStageTest(int sessions, RootPaneContainer rpc) {
        ContinuousTestSpec spec = new ContinuousTestSpec();
        spec.N_techUi = JWTestControl.getConnected(TestUtils.APP_TECH_TEST);
        spec.N_accessSessions = 0;
        return new SessionStageTest(rpc, spec, sessions);
    }

    @Override
    protected void launchTestControl() throws Exception {
        while (JWTestControl.getAvailable(TestUtils.APP_TECH_UI) < this.spec.N_techUi) {
            System.out.println("[Session Stage Test] Waiting for more tech UIs (" + JWTestControl.getAvailable(TestUtils.APP_TECH_UI) + "/" + this.spec.N_techUi + ")...");
            Thread.sleep(2000L);
        }
        System.out.println("[Session Stage Test] Launching " + this.sessions + " tech sessions immediately");
        JWTestControl.callN(this.sessions, TestUtils.APP_TECH_UI, TestUtils.TU_CMD_launchAccessSession);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        File sshotdir = new File(OSDirs.getDesktopDir(), "SessionStageTest_" + sdf.format(new Date()));
        sshotdir.mkdirs();
        boolean autoSnapshot = true;
        String skipToStage = null;
        boolean skipComplete = false;
        boolean skipAfterStage = false;
        if (autoSnapshot) {
            skipComplete = false;
            skipAfterStage = false;
        }
        String prevBarrier = "Start";
        while (true) {
            System.out.println("[Session Stage Test] Waiting for all sessions to reach barrier (" + JWTesting.getBarrierCount() + "/" + this.sessions + ")...");
            while (JWTesting.getBarrierCount() < this.sessions) {
                Thread.sleep(200L);
            }
            String barrier = JWTesting.getLatestBarrierReached();
            Object[] options = new String[]{"Quit", "Continue"};
            boolean mustSkip = false;
            if (skipToStage != null && !skipComplete) {
                if (skipToStage.equals(barrier)) {
                    skipComplete = true;
                } else {
                    mustSkip = true;
                }
            } else if (skipComplete && skipAfterStage) {
                mustSkip = true;
            }
            int option = 1;
            if (!mustSkip) {
                if (autoSnapshot) {
                    Thread.sleep(4000L);
                    SessionStageTest.doScreenshot(sshotdir, prevBarrier);
                } else {
                    option = JOptionPane.showOptionDialog(null, "Stage '" + barrier + "' ready x" + JWTesting.getBarrierCount(), "Stage reached", 2, -1, ImageLoader.getImageIcon("images/svg/technology/screen.svg,48"), options, "default");
                }
            }
            if (barrier.equals(JWTesting.BARRIER_SET_COMPLETE)) {
                JWTesting.releaseAllAtBarrier();
                SHGlassOptionPane.showMessageDialog(this.rpc, "All Barrier stages are COMPLETE", "All Barrier stages are COMPLETE", null);
                if (autoSnapshot) {
                    System.exit(0);
                }
                return;
            }
            if (option == 0) {
                return;
            }
            JWTesting.releaseAllAtBarrier();
            prevBarrier = barrier;
        }
    }

    public static void doScreenshot(File dir, String name) throws AWTException, IOException {
        ++N;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        Robot robot = new Robot();
        System.out.println(d);
        BufferedImage bimg = ImageHelper.toBufferedImageARGB(robot.createScreenCapture(new Rectangle(0, 0, d.width, d.height)));
        File file = new File(dir, Padder.padStart("" + N, 4, '0') + "_" + name + ".png");
        ImageIO.write((RenderedImage)bimg, "PNG", file);
        System.out.println("Wrote " + file);
    }

    @Override
    public Properties getLaunchProperties() {
        Properties props = new Properties();
        props.setProperty(JWTesting.JWA_REPORT_BARRIER, "BARRIER_SET_SESSION_START");
        return props;
    }
}

