/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests.suites.tests;

import com.aem.tests.TestUtils;
import com.aem.tests.suites.ContinuousTestSpec;
import com.aem.tests.suites.LargeContinuousTest;
import java.io.IOException;
import java.util.Properties;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import utils.progtools.RobustThread;

public class LongChurnTest
extends LargeContinuousTest {
    private LongChurnTest(ContinuousTestSpec spec) {
        super(spec);
    }

    public static LongChurnTest createLongChurnTest(boolean small) {
        ContinuousTestSpec spec = new ContinuousTestSpec();
        if (small) {
            spec.N_remoteAccess = 2;
            spec.N_techUi = 2;
            spec.N_cust = 2;
        } else {
            spec.N_remoteAccess = 20;
            spec.N_techUi = 3;
            spec.N_cust = 3;
        }
        return new LongChurnTest(spec);
    }

    @Override
    protected void launchTestControl() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            new RAOfflineDriver().start();
        }
        for (i = 0; i < 2; ++i) {
            new LongRunningSessionDriver(true).start();
        }
        for (i = 0; i < 2; ++i) {
            new LongRunningSessionDriver(false).start();
        }
        for (i = 0; i < 2; ++i) {
            new TechUiSessionsDriver().start();
        }
        for (i = 0; i < 2; ++i) {
            new TechUiMonitoringDriver().start();
        }
        new RAChurnDriver().start();
    }

    @Override
    public Properties getLaunchProperties() {
        return null;
    }

    class TechUiMonitoringDriver
    extends RobustThread {
        JWTestable tech;
        String name = "Tech UI Monitoring " + this.hashCode() % 1000;

        @Override
        public String getRobustName() {
            return "TechUi Monitoring Driver";
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public void reInit() throws Throwable {
            System.out.println("[TechUi Monitoring] TechUi Monitoring Driver re-initing, connecting to TechUi");
            this.tech = JWTestControl.popShared(TestUtils.APP_TECH_UI, 120000);
        }

        @Override
        public void robustRun() throws Throwable {
            System.out.println("[TechUi Monitoring] TechUi Monitoring Driver Running");
            JWTesting.countdownStatus(this.name, "Beginning", (int)(Math.random() * 3.0));
            while (true) {
                JWTesting.countdownStatus(this.name, "Will cycle Tech UI tabs", 15);
                this.tech.call(TestUtils.TU_CMD_testCycleUi, null);
            }
        }
    }

    class TechUiSessionsDriver
    extends RobustThread {
        JWTestable tech;
        String name = "Tech UI Session Launcher " + this.hashCode() % 1000;

        @Override
        public String getRobustName() {
            return "TechUi Sessions Driver";
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public void reInit() throws Throwable {
            System.out.println("[TechUi Sessions] TechUi Sessions Driver re-initing, connecting to TechUi");
            this.tech = JWTestControl.popShared(TestUtils.APP_TECH_UI, 120000);
        }

        @Override
        public void robustRun() throws Throwable {
            System.out.println("[TechUi Sessions] TechUi Sessions Driver Running");
            JWTesting.countdownStatus(this.name, "Beginning", 1 + (int)(Math.random() * 3.0));
            while (true) {
                if (Math.random() < 0.5) {
                    System.out.println("[TechUi Sessions] Launching short access session");
                    this.tech.call(TestUtils.TU_CMD_launchAccessSession, null);
                } else {
                    System.out.println("[TechUi Sessions] Launching short support session");
                    this.tech.call(TestUtils.TU_CMD_launchCustomerSession, null);
                }
                new ShortRunningSessionDriver().start();
                System.out.println("[TechUi Sessions] Continuing...");
                JWTesting.countdownStatus(this.name, "Will launch one short running session", 7);
            }
        }
    }

    class RAChurnDriver
    extends Thread {
        RAChurnDriver() {
        }

        @Override
        public void run() {
            System.out.println("[RA Churn] RA Churn Driver Running");
            String name = "RA Churn " + this.hashCode() % 1000;
            while (true) {
                JWAutomate.sleepMins(1.0);
                try {
                    JWTesting.countdownStatus(name, "May kill some RA Service HTTP sockets", 30);
                    if (Math.random() < 0.7) {
                        System.out.println("[RA Churn] Killing 0-6 RA service HTTP sockets (simulating small network event)");
                        JWTestControl.callN(6, TestUtils.APP_RA_SERVICE, TestUtils.RA_CMD_killHttpSocket);
                        System.out.println("[RA Churn] Continuing...");
                    }
                    JWTesting.countdownStatus(name, "Will force renegotiations for one or all RA services", 10);
                    if (Math.random() < 0.2) {
                        System.out.println("[RA Churn] Forcing renegotiate of ALL RA services");
                        JWTestControl.callAll(TestUtils.APP_RA_SERVICE, TestUtils.RA_CMD_renegotiate);
                        System.out.println("[RA Churn] Continuing...");
                        continue;
                    }
                    if (!(Math.random() < 0.8)) continue;
                    System.out.println("[RA Churn] Forcing renegotiate of 1 RA service");
                    JWTestControl.callOne(TestUtils.APP_RA_SERVICE, TestUtils.RA_CMD_renegotiate);
                    System.out.println("[RA Churn] Continuing...");
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class RAOfflineDriver
    extends Thread {
        RAOfflineDriver() {
        }

        @Override
        public void run() {
            String name = "RA Offline " + this.hashCode() % 1000;
            System.out.println("[RA Offline] RA Offline Driver Running");
            try {
                JWTestable raService = JWTestControl.popShared(TestUtils.APP_RA_SERVICE, 120000);
                JWTesting.countdownStatus(name, "Beginning", (int)(Math.random() * 5.0));
                while (true) {
                    try {
                        while (true) {
                            JWTesting.countdownStatus(name, "Stopping one RA service polling", 25);
                            System.out.println("[RA Offline] Stopping polling");
                            raService.call(TestUtils.RA_CMD_stopPolling, null);
                            System.out.println("[RA Offline] Continuing...");
                            JWTesting.countdownStatus(name, "Restarting RA service polling", 20);
                            System.out.println("[RA Offline] Starting polling");
                            raService.call(TestUtils.RA_CMD_startPolling, null);
                            System.out.println("[RA Offline] Continuing...");
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                return;
            }
        }
    }

    class LongRunningSessionDriver
    extends RobustThread {
        boolean accessSession;
        String name;

        public LongRunningSessionDriver(boolean accessSession) {
            this.accessSession = accessSession;
            this.name = accessSession ? "Long SH Session " + this.hashCode() % 1000 : "Long SG Session " + this.hashCode() % 1000;
        }

        @Override
        public String getRobustName() {
            return "Long Run Session Driver";
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public void reInit() throws Throwable {
            System.out.println("[Long Session] Long Session Driver re-initing, launching session");
            JWTesting.countdownStatus(this.name, "Beginning", (int)(Math.random() * 3.0));
            while (true) {
                try {
                    if (this.accessSession) {
                        JWTestControl.callOne(TestUtils.APP_TECH_UI, TestUtils.TU_CMD_launchAccessSession);
                        break;
                    }
                    JWTestControl.callOne(TestUtils.APP_TECH_UI, TestUtils.TU_CMD_launchCustomerSession);
                }
                catch (NullPointerException xx) {
                    System.out.println("[Long Session] no TechUis available right now");
                    JWAutomate.sleep(5000L);
                    continue;
                }
                break;
            }
        }

        @Override
        public void robustRun() throws Throwable {
            System.out.println("[Long Session] Long Session Driver Running");
            JWTesting.reportStatus(this.name, "Waiting for available Tech Session");
            JWTestable session = JWTestControl.popShared(TestUtils.APP_TECH_SESSION_GUI, 120000);
            if (session == null) {
                System.out.println("[Long Session] Failed to connect to launched session");
                JWAutomate.sleepMins(1.0);
                return;
            }
            System.out.println("[Long Session] Connected to session");
            while (true) {
                double rand;
                if ((rand = Math.random()) < 0.1) {
                    JWTesting.reportStatus(this.name, "Checking stability of random transport");
                    JWAutomate.sleepMins(3.0);
                } else if (rand < 0.2) {
                    JWTesting.reportStatus(this.name, "Switching to random transport");
                    JWAutomate.sleepMins(1.0);
                }
                JWTesting.countdownStatus(this.name, "Running further interactions", 1);
            }
        }
    }

    class ShortRunningSessionDriver
    extends Thread {
        ShortRunningSessionDriver() {
        }

        @Override
        public void run() {
            String name = "Short Session " + this.hashCode() % 1000;
            try {
                System.out.println("[Short Session] Short Session Driver connecting to session...");
                JWTestable session = JWTestControl.popShared(TestUtils.APP_TECH_SESSION_GUI, 120000);
                System.out.println("[Short Session] Continuing...");
                int runs = 1 + (int)(Math.random() * 9.0);
                for (int i = 0; i < runs; ++i) {
                    session.call(TestUtils.SS_CMD_switchToRandomTransport, null);
                    JWTesting.countdownStatus(name, "Running further interactions", 1);
                }
                JWTesting.countdownStatus(name, "Terminating", 1);
                session.call(TestUtils.SS_CMD_terminate, null);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }
}

