/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import com.aem.sdesktop.util.Version;
import com.aem.sgateway.SGInstallationCheck;
import com.aem.shelp.common.TechLaunchAPI;
import com.aem.shelp.licence.OemBranding;
import com.aem.utils.ClassPathHacker;
import com.aem.utils.NullOutputStream;
import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JOptionPane;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWLinuxOS;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.ProcessPrinter;
import utils.string.CharStack;
import utils.string.Normaliser;
import utils.string.Padder;
import utils.string.StringUtil;

public class SgSetupUtility {
    public static final String[] EMPTY_ARGS = new String[0];
    public static final int TYPE_INSTALL_NORMAL_MANUAL = 0;
    public static final int TYPE_INSTALL_PRECONFIGURED = 1;
    public static final int TYPE_INSTALL_MANUAL_DELETE = 2;
    public static final int TYPE_INSTALL_STOP_START_SERVICE_UPGRADE = 3;
    private static Object creds_LOCK = new Object();
    private static Properties creds = new Properties();

    private static String getPasswordFor(String server) throws IOException {
        if (creds.containsKey(server)) {
            return creds.getProperty(server);
        }
        File folder = new File(".");
        try {
            folder = JWSystem.getAllAppVersionsSharedFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File adminPassFile = new File(folder, "techTestServerPass_" + Normaliser.normaliseShort(server));
        String pass = adminPassFile.exists() ? SgSetupUtility.getInput("Admin pass for " + server, FileUtil.readFileAsStringUTF8(adminPassFile)) : SgSetupUtility.getInput("Admin pass for " + server, "");
        creds.setProperty(server, pass);
        FileUtil.writeFileAsStringUTF8(adminPassFile, pass);
        return pass;
    }

    private static String getInput(String message, String initial) {
        return JOptionPane.showInputDialog(null, message, initial);
    }

    private static void haltForMessage(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    public static void testSgWorkingOk(String serverBaseURL, int retries) throws Exception {
        for (int i = 0; i < retries; ++i) {
            try {
                SgSetupUtility.testSgWorkingOk(serverBaseURL);
                break;
            }
            catch (Exception x) {
                JWTesting.reportStandaloneFail("Failed to connect through " + serverBaseURL, x);
                if (i != retries - 1) continue;
                throw x;
            }
        }
    }

    public static void testSgWorkingOk(String serverBaseURL) throws Exception {
        Stats.ProcessStatistic[] procs;
        long sgid;
        try {
            sgid = SGInstallationCheck.getSgID();
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new Exception("Unable to get SG ID to even try a connection, SG is not installed correctly?");
        }
        JWSystem.clearPreparedFork();
        Thread.sleep(1000L);
        Stats stats = OsStats.getOsStats();
        HashMap<String, String> present = new HashMap<String, String>();
        stats.update();
        for (Stats.ProcessStatistic proc : procs = stats.getProcessStatistics()) {
            System.out.println("Existing process: " + proc.id + ", " + proc.name + ", " + proc.cmdLineArgs);
            present.put(proc.id, proc.cmdLineArgs);
        }
        long sessionTimeout = 60000L;
        TechLaunchAPI api = new TechLaunchAPI();
        api.setDirectMachine("SG_" + sgid);
        String pass = SgSetupUtility.getPasswordFor(serverBaseURL);
        api.setTechLogin(OemBranding.OEM_ADMIN_USERNAME, pass);
        api.launch(serverBaseURL);
        String match = "FTP Server version is";
        File logdir = JWSystem.getAllAppLoggingFolder();
        boolean success = false;
        long giveUp = System.currentTimeMillis() + sessionTimeout;
        block3: while (System.currentTimeMillis() < giveUp && !success) {
            Thread.sleep(3000L);
            File[] files = logdir.listFiles();
            for (File file : files) {
                String name = file.getName();
                if (name.indexOf("SessionUI") == -1 || System.currentTimeMillis() - file.lastModified() >= 30000L) continue;
                System.out.println("Checking SessionUI file " + name);
                String contents = FileUtil.readFileAsString(file);
                if (!contents.contains(match)) continue;
                success = true;
                continue block3;
            }
        }
        if (!success) {
            throw new Exception("Failed to verify with successful session");
        }
        stats.update();
        Stats.ProcessStatistic[] testprocs = stats.getProcessStatistics();
        for (Stats.ProcessStatistic proc : testprocs) {
            if (present.containsKey(proc.id)) continue;
            System.out.println("New process: " + proc.id + ", " + proc.name + ", " + proc.cmdLineArgs);
            String info = proc.name.toLowerCase() + " " + proc.cmdLineArgs.toLowerCase();
            String[] killprocs = new String[]{"session", "tech", "access", "simplegateway", "osxwrapper", "osxlauncher"};
            boolean matches = false;
            for (String kill : killprocs) {
                if (info.indexOf(kill.toLowerCase()) == -1) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            System.out.println("Terminating " + proc.id);
            OsStats.getOsStats().killProcess(proc.id);
        }
    }

    private static void removeSgInstall(boolean tryNormalUninstall) throws Exception {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        tryNormalUninstall = false;
        if (tryNormalUninstall) {
            System.out.println("[SgSetupUtility] Trying to uninstall v4 service via cmdline normally");
            try {
                File exe;
                String bin;
                String path;
                if (OS.isWindows()) {
                    path = master.getCanonicalPath();
                    if (!path.endsWith("\\")) {
                        path = path + "\\";
                    }
                    path = path + "Remote AccessWinLauncher.exe";
                    SgSetupUtility.platformRun(new File(path), new String[]{"uninstall"});
                } else if (OS.isLinux()) {
                    path = master.getCanonicalPath();
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    if (!new File(bin = path + "Remote AccessLinLauncher").exists()) {
                        bin = path + "Remote AccessLinLauncher64";
                    }
                    exe = new File(bin);
                    SgSetupUtility.platformRun(exe, new String[]{"uninstall"});
                } else if (OS.isMacOS()) {
                    path = master.getCanonicalPath();
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    bin = path + "JWAppsSharedConfig/SimpleGatewayService/SimpleGatewayService.app";
                    exe = new File(bin);
                    SgSetupUtility.platformRun(exe, new String[]{"uninstall"});
                }
            }
            catch (IOException x) {
                System.out.println("[SgSetupUtility] Unable to run uninstaller: " + x);
            }
            if (master.exists()) {
                System.out.println("[SgSetupUtility] WARNING ran SG uninstall but master folder still exists");
            }
        }
        if (master.exists()) {
            Stats.ProcessStatistic[] procs;
            System.out.println("[SgSetupUtility] Master folder exists, uninstall either didn't work or wasn't run, will force terminate and delete master folder");
            Stats stats = OsStats.getOsStats();
            stats.update();
            for (Stats.ProcessStatistic proc : procs = stats.getProcessStatistics()) {
                System.out.println("[SgSetupUtility] Process: " + proc.name + " " + proc.id + " " + proc.cmdLineArgs);
                String lc = proc.cmdLineArgs.toLowerCase();
                if (!lc.contains("remote access") && !lc.contains("simpleservice") && !lc.contains("simplegateway") && !lc.contains("jucheck") && !lc.contains("jusched") && !lc.contains("-online.exe") && !lc.contains("-offline.exe") && !lc.contains("cmd.exe")) continue;
                System.out.println("[SgSetupUtility] Terminating " + proc.name + " " + proc.id);
                JWGenericOS.getInstance();
                if (JWGenericOS.terminateProcess(Integer.parseInt(proc.id))) continue;
                System.out.println("[SgSetupUtility] WARNING unable to terminate process " + proc.id);
                RunCommandGetOutput.runCommandIgnoreOutput("taskkill.exe /PID " + proc.id + " /F");
            }
            try {
                System.out.println("[SgSetupUtility] Forcibly terminating any remaining v4 services");
                SGInstallationCheck.forceKillAllV4Services();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (OS.isWindows()) {
                try {
                    System.out.println("[SgSetupUtility] Sleeping to let windows catch up");
                    Thread.sleep(10000L);
                }
                catch (Exception t) {
                    // empty catch block
                }
            }
            System.out.println("[SgSetupUtility] Forcibly deleting the v4 service folder");
            SGInstallationCheck.forceDeleteV4ServiceFolder();
            if (master.exists()) {
                System.out.println("[SgSetupUtility] ERROR ran SG force delete but master folder still exists");
                stats = OsStats.getOsStats();
                stats.update();
                for (Stats.ProcessStatistic proc : procs = stats.getProcessStatistics()) {
                    System.out.println("[SgSetupUtility] Process: " + proc.name + " " + proc.id);
                }
                throw new Exception("Tried to forcibly terminate and delete SG but master folder still exists");
            }
        }
    }

    private static File replaceSuffix(File orig, String suffix) {
        String path = orig.getPath();
        int index = path.lastIndexOf(46);
        if (index != -1) {
            path = path.substring(0, index);
            if (suffix.length() != 0) {
                path = suffix.startsWith(".") ? path + suffix : path + "." + suffix;
            }
        }
        return new File(path);
    }

    private static File platformExtract(File archive) throws IOException {
        if (OS.isWindows()) {
            return archive;
        }
        if (OS.isMacOS()) {
            String[] lines;
            RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"hdiutil", "attach", archive.getCanonicalPath()});
            if (response.returnCode != 0) {
                System.out.println("hdiutil output:\n" + response.stdout);
                System.out.println("hdiutil errors:\n" + response.stderr);
                throw new IOException("hdiutil returned non-zero return code");
            }
            String diskPath = null;
            String volumePath = null;
            for (String line : lines = response.stdout.trim().split("\n")) {
                System.out.println("Line: " + line);
                int maxIndex = Math.max(line.indexOf(" /"), line.indexOf("\t/"));
                if (maxIndex == -1) continue;
                volumePath = line.substring(++maxIndex).trim();
                diskPath = new CharStack(line).popText(true);
            }
            if (volumePath == null) {
                System.out.println("hdiutil output:\n" + response.stdout);
                System.out.println("hdiutil errors:\n" + response.stderr);
                throw new IOException("unable to get volume path from hdiutil output");
            }
            if (volumePath.endsWith("/")) {
                volumePath = volumePath.substring(0, volumePath.length() - 1);
            }
            File target = SgSetupUtility.replaceSuffix(archive, ".app");
            File volume = new File(volumePath);
            File[] files = volume.listFiles();
            if (files == null) {
                throw new IOException("Unable to list volume provided by hdiutil " + volumePath);
            }
            File source = null;
            for (File file : files) {
                if (!file.getName().endsWith(".app")) continue;
                source = file;
            }
            if (source == null) {
                throw new IOException("Couldn't find .app file in volume provided by hdiutil " + volumePath);
            }
            System.out.println("Copying " + source + " to " + target);
            FileUtil.deleteDir(target);
            System.out.println("Deleting " + target);
            if (target.exists()) {
                System.out.println("ERROR unable to delete " + target);
            }
            RunCommandGetOutput.runCommand(new String[]{"cp", "-r", source.getCanonicalPath(), target.getCanonicalPath()});
            System.out.println("Copying finished");
            System.out.println("chmodding " + target);
            RunCommandGetOutput.runCommand(new String[]{"chmod", "777", target.getCanonicalPath()});
            RunCommandGetOutput.runCommandNoWait(new String[]{"hdiutil", "detach", diskPath});
            return target;
        }
        System.out.println("Extracting tar archive");
        RunCommandGetOutput.runCommand(new String[]{"tar", "-xf", archive.getCanonicalPath()});
        File extracted = new File(archive.getParentFile(), "Remote Access-" + SgSetupUtility.replaceSuffix(archive, "").getName());
        System.out.println("chmodding " + extracted);
        RunCommandGetOutput.runCommand(new String[]{"chmod", "777", extracted.getCanonicalPath()});
        return extracted;
    }

    private static RunCommandGetOutput.CommandResponse platformRun(File app, String[] args) throws IOException {
        return SgSetupUtility.platformRun(app, args, true);
    }

    private static RunCommandGetOutput.CommandResponse platformRun(File app, String[] args, boolean wait) throws IOException {
        System.out.println("[PlatformRun] Original: " + app);
        app = SgSetupUtility.convertToExe(app);
        System.out.println("[PlatformRun] Converted: " + app);
        String[] cmd = new String[args.length + 1];
        cmd[0] = app.getCanonicalPath();
        System.arraycopy(args, 0, cmd, 1, args.length);
        for (String param : cmd) {
            System.out.println("[PlatformRun] Cmd: " + param);
        }
        if (!wait) {
            Process p = Runtime.getRuntime().exec(cmd, null, app.getParentFile());
            p.getOutputStream().close();
            new ProcessPrinter(p, new NullOutputStream(), new NullOutputStream());
            return null;
        }
        RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(cmd, app.getParentFile());
        System.out.println("[PlatformRun] Retcode: " + response.returnCode);
        if (response.returnCode != 0) {
            System.out.println("[PlatformRun] Stdout: " + response.stdout);
            System.out.println("[PlatformRun] Stderr: " + response.stderr);
        }
        return response;
    }

    private static File convertToExe(File app) {
        if (OS.isMacOS()) {
            String name = app.getName();
            if (name.endsWith("osxwrapper")) {
                return app;
            }
            if (!name.endsWith(".app")) {
                app = new File(app.getAbsolutePath() + ".app");
            }
            return new File(new File(new File(app, "Contents"), "MacOS"), "osxwrapper");
        }
        return app;
    }

    public static File getServiceXmlConfig() throws IOException {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        File config = new File(master, "JWAppsSharedConfig");
        File xml = new File(config, "serviceconfig.xml");
        return xml;
    }

    public static File getServiceIdFile() throws IOException {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        File config = new File(master, "JWAppsSharedConfig");
        File xml = new File(config, "serviceid.dat");
        return xml;
    }

    private static void resetServiceServerURL(String targetURL) throws IOException {
        File xml = SgSetupUtility.getServiceXmlConfig();
        String utf8 = FileUtil.readFileAsStringUTF8(xml);
        String[] lines = utf8.split("\n");
        boolean added = false;
        ArrayList<String> results = new ArrayList<String>();
        for (String line : lines) {
            if (line.indexOf("<ConnectTo") == -1) {
                results.add(line);
                continue;
            }
            results.add("<ConnectTo>" + targetURL + "</ConnectTo>");
            added = true;
        }
        StringBuffer sb = new StringBuffer();
        for (String line : results) {
            sb.append(line).append("\n");
        }
        FileUtil.writeFileAsStringUTF8(xml, sb.toString());
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 || !JWLaunchProperties.isJWrapperSetup()) {
            System.out.println("[SgSetupUtility] Testing mode, usage: SgSetupUtility <dloadserver> <targetserver> <online|offline> <clean|overwrite> <normal|preconfigured|stopstart|delete>");
            if (args.length == 0) {
                System.exit(0);
            }
            String downloadServerURL = args[1];
            String targetServerURL = args[2];
            boolean online = args[3].equals("online");
            boolean clean = args[4].equals("clean");
            int type = args[5].equals("normal") ? 0 : (args[5].equals("stopstart") ? 3 : (args[5].equals("delete") ? 2 : 1));
            SgSetupUtility.runSgTest(downloadServerURL, targetServerURL, online, clean, type, 1);
        } else {
            JWTesting.reportStandaloneSuccess("SgSetupUtility launched OK");
            SgSetupUtility.runSgUpgradeTestBattery();
        }
    }

    private static String getVersion(String server) {
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        server = server + "version";
        try {
            URL url = new URL(server);
            System.out.println("Querying for version " + url);
            InputStream in = url.openStream();
            String version = utils.stream.StreamUtils.readAllAsString(in);
            in.close();
            if (version.indexOf("SSuite-") == -1) {
                throw new Exception("Not a valid SH server");
            }
            return version.trim();
        }
        catch (Exception x) {
            return null;
        }
    }

    private static void runSgUpgradeTestBattery() {
        String test;
        String otherBuild;
        String target = JWLaunchProperties.getProperty("update_url");
        String mypass = JWLaunchProperties.getProperty("password");
        try {
            String apijar = StringUtil.ensureTrailing(target, "/") + "technician/SimpleHelp%20Technician-java-online.jar";
            URL url = new URL(apijar);
            System.out.println("Attempting to download cmd API jar from " + url);
            InputStream in = url.openStream();
            byte[] dat = StreamUtils.readAll(in);
            File jar = new File("techapi.jar");
            FileUtil.writeFile(jar, dat);
            ClassPathHacker.addFile(jar);
            JWTesting.reportStandaloneSuccess("Successfully loaded cmdline API jar");
        }
        catch (IOException x) {
            x.printStackTrace();
            JWTesting.reportStandaloneFail("Successfully loaded cmdline API jar", x);
        }
        String build = SgSetupUtility.getVersion(target);
        ArrayList<String> testurls = new ArrayList<String>();
        StringBuffer details = new StringBuffer();
        for (int i = 2; i <= 99 && (otherBuild = SgSetupUtility.getVersion(test = "http://sh4" + i + ".simplehelp.io")) != null && !Version.isBuildSameOrNewer(build, otherBuild); ++i) {
            testurls.add(test);
            System.out.println("Will test: " + test + " " + otherBuild + " < " + build);
            details.append("Will test: " + test + " " + otherBuild + " < " + build + "\n");
        }
        try {
            SgSetupUtility.getPasswordFor(target);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        for (String testurl : testurls) {
            try {
                SgSetupUtility.getPasswordFor(testurl);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        JWTesting.reportStandaloneSuccess("Got test servers x" + testurls.size(), details.toString());
        String name = "SgSetupUtilityAutotest";
        String attempt = "";
        int T = 1;
        int latestAttempts = 2;
        int oldServerAttempts = 5;
        boolean online = true;
        boolean offline = false;
        try {
            attempt = "T" + Padder.padStart("" + T++, 2, '0') + " - Install latest version from clean, online, preconfigured";
            SgSetupUtility.runSgTest(target, target, online, true, 1, latestAttempts);
            JWTesting.reportStandaloneSuccess(attempt);
        }
        catch (Exception x) {
            JWTesting.reportStandaloneFail(attempt, x);
        }
        try {
            attempt = "T" + Padder.padStart("" + T++, 2, '0') + " - Install latest version from clean, offline, preconfigured";
            SgSetupUtility.runSgTest(target, target, offline, true, 1, latestAttempts);
            JWTesting.reportStandaloneSuccess(attempt);
        }
        catch (Exception x) {
            JWTesting.reportStandaloneFail(attempt, x);
        }
        try {
            attempt = "T" + Padder.padStart("" + T++, 2, '0') + " - Manually forcibly delete, then install online preconfigured";
            SgSetupUtility.runSgTest(target, target, online, true, 2, latestAttempts);
            SgSetupUtility.runSgTest(target, target, online, true, 1, latestAttempts);
            JWTesting.reportStandaloneSuccess(attempt);
        }
        catch (Exception x) {
            JWTesting.reportStandaloneFail(attempt, x);
        }
        try {
            attempt = "T" + Padder.padStart("" + T++, 2, '0') + " - Manually forcibly delete, then install offline preconfigured";
            SgSetupUtility.runSgTest(target, target, offline, true, 2, latestAttempts);
            SgSetupUtility.runSgTest(target, target, offline, true, 1, latestAttempts);
            JWTesting.reportStandaloneSuccess(attempt);
        }
        catch (Exception x) {
            JWTesting.reportStandaloneFail(attempt, x);
        }
        Iterator iterator = testurls.iterator();
        while (iterator.hasNext()) {
            String oldserver;
            String oldname = oldserver = (String)iterator.next();
            int index = oldname.indexOf("://");
            oldname = oldname.substring(index + 3);
            try {
                attempt = "T" + Padder.padStart("" + T++, 2, '0') + " - Connecting to RA service downloaded from " + oldname;
                SgSetupUtility.runSgTest(oldserver, target, offline, true, 1, oldServerAttempts);
                JWTesting.reportStandaloneSuccess(attempt);
            }
            catch (Exception x) {
                JWTesting.reportStandaloneFail(attempt, x);
            }
            try {
                attempt = "T" + Padder.padStart("" + T++, 2, '0') + " - Connecting to Latest RA service via " + oldname;
                SgSetupUtility.runSgTest(target, oldserver, offline, true, 1, oldServerAttempts);
                JWTesting.reportStandaloneSuccess(attempt);
            }
            catch (Exception x) {
                JWTesting.reportStandaloneFail(attempt, x);
            }
        }
        JWTesting.reportStandaloneSuccess("All tests completed");
    }

    public static void runSgTest(String downloadServerURL, String targetServerURL, boolean online, boolean clean, int type, int connectAttempts) throws Exception {
        String serviceName = "SgSetupUtilityTestService";
        if (OS.isMacOS() ? !JWMacOS.haveSudoPermissions() : OS.isLinux() && !JWLinuxOS.haveSudoPermissions()) {
            throw new Exception("SgSetupUtility MUST be run as ROOT");
        }
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        System.out.println("[SgSetupUtility] Master folder is " + master + " (exists=" + master.exists() + ")");
        System.out.println("[SgSetupUtility] Download Server URL: " + downloadServerURL);
        System.out.println("[SgSetupUtility] SH Server URL: " + targetServerURL);
        System.out.println("[SgSetupUtility] Clean: " + clean);
        System.out.println("[SgSetupUtility] Type: " + type);
        if (clean && type != 2) {
            System.out.println("[SgSetupUtility] Attempting to uninstall SG, will delete if necessary");
            SgSetupUtility.removeSgInstall(true);
        }
        if (!downloadServerURL.endsWith("/")) {
            downloadServerURL = downloadServerURL + "/";
        }
        String platform = OS.isMacOS() ? (online ? "macos64-online.dmg" : "macos64-offline.dmg") : (OS.isLinux64bit() ? (online ? "linux64-online.tar" : "linux64-offline.tar") : (OS.isLinux() ? (online ? "linux32-online.tar" : "linux32-offline.tar") : (OS.isWindowsXpOr2003() ? (online ? "windows32-online.exe" : "windows32-offline.exe") : (online ? "windows64-online.exe" : "windows64-offline.exe"))));
        if (type == 3) {
            System.out.println("[SgSetupUtility] Stop-starting service to trigger upgrade");
            File stopper = new File(new File(master, serviceName), serviceName + "Stop.app");
            File starter = new File(new File(master, serviceName), serviceName + ".app");
            System.out.println("Stopping service...");
            SgSetupUtility.platformRun(stopper, EMPTY_ARGS);
            System.out.println("Starting service...");
            SgSetupUtility.platformRun(starter, EMPTY_ARGS);
        } else if (type == 2) {
            System.out.println("[SgSetupUtility] Terminating the service and deleting install folder");
            SgSetupUtility.removeSgInstall(false);
        } else {
            System.out.println("[SgSetupUtility] Downloading service from dl server URL and pointing at target server URL");
            String download = downloadServerURL + "access/Remote%20Access-" + platform + "?language=en&hostname=" + URLEncoder.encode(downloadServerURL);
            boolean popupHelp = false;
            if (type == 1) {
                download = download + "&name=" + serviceName + "&silent=yes&servers=" + URLEncoder.encode(downloadServerURL);
            }
            URL downloadURL = new URL(download);
            System.out.println("[SgSetupUtility] Downloading from " + downloadURL);
            BufferedInputStream bin = new BufferedInputStream(downloadURL.openStream());
            byte[] dat = StreamUtils.readAll(bin);
            System.out.println("[SgSetupUtility] Read " + dat.length + " bytes");
            File output = new File(platform);
            output.delete();
            if (output.exists()) {
                System.out.println("[SgSetupUtility] ERROR unable to delete archive ready for download");
            }
            FileUtil.writeFile(output, dat);
            System.out.println("[SgSetupUtility] Downloaded to file " + output);
            System.out.println("[SgSetupUtility] Absolute path " + output.getAbsolutePath());
            File extracted = SgSetupUtility.platformExtract(output);
            SgSetupUtility.platformRun(extracted, EMPTY_ARGS);
            if (downloadServerURL.contains("sh42.")) {
                File config = new File(SGInstallationCheck.getStandardSgMasterFolder(), "JWAppsSharedConfig");
                File sgservice = new File(config, "SimpleGatewayService");
                File start = null;
                if (OS.isWindows()) {
                    start = new File(sgservice, "SimpleGatewayService.exe");
                } else if (OS.isMacOS()) {
                    start = new File(sgservice, "SimpleGatewayService.app");
                } else if (OS.isLinux()) {
                    start = new File(sgservice, "SimpleGatewayService");
                }
                if (start != null) {
                    long timeout = System.currentTimeMillis() + 60000L;
                    while (!start.exists()) {
                        System.out.println("[SgSetupUtility] Waiting for 4.2 service start shortcut to appear");
                        Thread.sleep(1000L);
                        if (System.currentTimeMillis() <= timeout) continue;
                        throw new Exception("4.2 service start shortcut never appeared");
                    }
                    Thread.sleep(7000L);
                    System.out.println("[SgSetupUtility] Attempting to manually start 4.2 SG service...");
                    SgSetupUtility.platformRun(start, EMPTY_ARGS, false);
                }
            }
            File xml = SgSetupUtility.getServiceXmlConfig();
            File iddat = SgSetupUtility.getServiceIdFile();
            long giveup = System.currentTimeMillis() + 300000L;
            while (!xml.exists() || !iddat.exists()) {
                System.out.println("[SgSetupUtility] Waiting for SG XML config and SGID file to appear...");
                Thread.sleep(1000L);
                if (System.currentTimeMillis() <= giveup) continue;
                throw new IOException("SG XML file or SGID didn't appear (xml=" + xml.exists() + ") (iddat=" + iddat.exists() + ")");
            }
            if (!downloadServerURL.equals(targetServerURL)) {
                Thread.sleep(5000L);
                System.out.println("[SgSetupUtility] Overwriting config server URL to " + targetServerURL);
                SgSetupUtility.resetServiceServerURL(targetServerURL);
            }
            for (int i = 10; i > 0; --i) {
                System.out.println("[SgSetupUtility] Launching session in " + i + "...");
                Thread.sleep(1000L);
            }
            System.out.println("[SgSetupUtility] Launching session via " + targetServerURL);
            SgSetupUtility.testSgWorkingOk(targetServerURL, connectAttempts);
        }
    }
}

