/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.swing;

import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import utils.swing.SwingUtil;
import utils.swing.components.animated.arrow.ArrowAnimatedIcon;

public abstract class CopyToClipboardButton
implements ActionListener {
    public JButton rootComponent = new JButton(Language.get("COPY"));
    private static final ArrowAnimatedIcon ARROW_ICON = new ArrowAnimatedIcon();
    private static final Timer timer = new Timer();

    public CopyToClipboardButton() {
        this.rootComponent.addActionListener(this);
        int height = this.rootComponent.getPreferredSize().height;
        SwingUtil.setHeight(this.rootComponent, height);
    }

    public abstract String getClipboardText();

    @Override
    public void actionPerformed(ActionEvent e) {
        this.rootComponent.setText("");
        this.rootComponent.setIcon(ARROW_ICON);
        this.rootComponent.repaint();
        try {
            ClipboardUtil.setClipboardAsText(this.getClipboardText());
        }
        finally {
            timer.schedule((TimerTask)new ResetButtonTimerTask(), 500L);
        }
    }

    public Component getRootComponent() {
        return this.rootComponent;
    }

    class ResetButtonTimerTask
    extends TimerTask {
        ResetButtonTimerTask() {
        }

        @Override
        public void run() {
            CopyToClipboardButton.this.rootComponent.setText(Language.get("COPY"));
            CopyToClipboardButton.this.rootComponent.setIcon(null);
            CopyToClipboardButton.this.rootComponent.repaint();
        }
    }
}

