/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.notifications;

import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.Language;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import jwrapper.jwutils.JWSystem;
import utils.ostools.OS;
import utils.swing.JTextLabel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageHelper;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.LinePanel;

public class StandaloneNotification
extends JFrame {
    JFrame frame;
    JButton dismiss;

    public StandaloneNotification(Image icon, String title, String message, ActionListener listener) {
        try {
            SimpleHelpFrame.getTestFrame();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.frame = this;
        title = title.trim();
        message = message.trim();
        if (icon == null) {
            try {
                ClientBranding.loadBrandingFromCacheDir(null);
                icon = ClientBranding.get().getSplashImage(false);
            }
            catch (Throwable t) {
                System.out.println("[StandaloneNotify] Unable to load branding icon.");
                t.printStackTrace();
            }
            try {
                if (icon == null) {
                    icon = ImageIO.read(new ByteArrayInputStream(JWSystem.getAppBundleSplashPNG()));
                }
            }
            catch (Exception x) {
                System.out.println("[StandaloneNotify] Unable to load logo " + x);
                x.printStackTrace();
            }
        }
        if (icon != null) {
            icon = ImageHelper.scaleDownToFitInside(ImageHelper.toBufferedImageARGB(icon), 96, 96);
        }
        BorderPanel nomargin = new BorderPanel(new Insets(0, 0, 0, 0));
        BorderPanel upper = new BorderPanel(new Insets(0, 0, 0, 0));
        nomargin.addNorth(upper);
        JLabel label = new JLabel(title);
        label.setOpaque(true);
        label.setFont(SHStyle.largeFont);
        label.setBorder(new EmptyBorder(7, 7, 7, 7));
        label.setHorizontalAlignment(0);
        upper.addSouth(label);
        label.setBackground(SHStyle.PANEL_BACKGROUND_LIGHT);
        BorderPanel bp = new BorderPanel(new Insets(7, 7, 7, 7));
        bp.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        nomargin.addCenter(bp);
        JComponent label2 = new JLabel(new ImageIcon(icon));
        ((JLabel)label2).setVerticalAlignment(1);
        ((JLabel)label2).setHorizontalAlignment(0);
        upper.addCenter(label2);
        label2.setBorder(new EmptyBorder(7, 7, 7, 7));
        LinePanel lp = new LinePanel(1, true, false);
        lp.setOpaque(false);
        this.dismiss = new JButton(Language.get("DISMISS"));
        lp.add(this.dismiss);
        bp.addSouth(lp);
        label2 = new JTextLabel(message);
        ((JTextLabel)label2).fixSizeByWidth(440);
        ((JTextArea)label2).setWrapStyleWord(true);
        bp.addCenter(label2);
        this.frame.getContentPane().add(nomargin);
        this.dismiss.addActionListener(listener);
        this.frame.setUndecorated(true);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setResizable(false);
        this.setAlwaysOnTop(this.frame, true);
        this.frame.setFocusableWindowState(false);
        this.frame.setFocusable(false);
        this.frame.pack();
        System.out.println("Frame width " + this.frame.getWidth());
        System.out.println("Frame height " + this.frame.getHeight());
        label2.setPreferredSize(null);
        Toolkit toolkit = this.frame.getToolkit();
        Insets insets = toolkit.getScreenInsets(this.frame.getGraphicsConfiguration());
        Dimension frameSize = this.frame.getSize();
        Dimension size = toolkit.getScreenSize();
        if (OS.isWindows()) {
            this.frame.setLocation(size.width - (int)frameSize.getWidth() - insets.left - insets.right, size.height - (int)frameSize.getHeight() - insets.bottom);
        } else {
            this.frame.setLocation(size.width - (int)frameSize.getWidth() - insets.left - insets.right, insets.top);
        }
        this.frame.setVisible(true);
    }

    private void setAlwaysOnTop(JFrame frame, boolean b) {
        try {
            Method method = frame.getClass().getMethod("setAlwaysOnTop", Boolean.TYPE);
            method.invoke((Object)frame, new Boolean(b));
        }
        catch (Throwable t) {
            System.out.println("Frame notification not always on top - pre 1.5 JVM");
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        new StandaloneNotification(ImageIO.read(new File("/Users/aem/Desktop/sh_512.png")), "Message to Users", "Dear User,\n\nCould everyone please take note to clean all coffee mugs before going home at night.\n\nThank you\n\nYour Friendly SysAdmin", new QuitActionListener());
    }

    static class QuitActionListener
    implements ActionListener {
        QuitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }
}

