/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.autoupdate;

import java.util.LinkedList;

public class AutoRestartCountUtil {
    private static final int REQUEST_1HR = 1;
    private static final int REQUEST_6HR = 6;
    private static final int REQUEST_12HR = 12;
    private static final int REQUEST_24HR = 24;
    private static final int REQUEST_1W = 168;
    private final LinkedList<Integer> requestQueue = new LinkedList();
    private long lastAutoRestartTime = 0L;
    private long nextAutoRestartTime = 0L;
    private int totalRestartRequests = 0;
    private long lastWarningTime = 0L;

    public AutoRestartCountUtil() {
        int i;
        for (i = 0; i < 6; ++i) {
            this.requestQueue.add(1);
        }
        for (i = 0; i < 4; ++i) {
            this.requestQueue.add(6);
        }
        for (i = 0; i < 4; ++i) {
            this.requestQueue.add(12);
        }
        for (i = 0; i < 4; ++i) {
            this.requestQueue.add(24);
        }
    }

    public boolean requestAutoRestart() {
        if (System.currentTimeMillis() < this.nextAutoRestartTime) {
            return false;
        }
        this.lastAutoRestartTime = System.currentTimeMillis();
        if (this.requestQueue.size() == 0) {
            this.nextAutoRestartTime = this.lastAutoRestartTime + 604800000L;
            ++this.totalRestartRequests;
            return true;
        }
        switch (this.requestQueue.removeFirst()) {
            case 1: {
                this.nextAutoRestartTime = this.lastAutoRestartTime + 3600000L;
                break;
            }
            case 6: {
                this.nextAutoRestartTime = this.lastAutoRestartTime + 21600000L;
                break;
            }
            case 12: {
                this.nextAutoRestartTime = this.lastAutoRestartTime + 43200000L;
                break;
            }
            case 24: {
                this.nextAutoRestartTime = this.lastAutoRestartTime + 86400000L;
                break;
            }
            default: {
                this.nextAutoRestartTime = this.lastAutoRestartTime + 604800000L;
            }
        }
        ++this.totalRestartRequests;
        return true;
    }

    public int getTotalRestartRequests() {
        return this.totalRestartRequests;
    }

    public int getLastRestartHoursAgo() {
        if (this.lastAutoRestartTime == 0L) {
            return 0;
        }
        int hours = (int)((System.currentTimeMillis() - this.lastAutoRestartTime) / 3600000L);
        return Math.max(0, hours);
    }

    public int getNextRestartHours() {
        if (this.nextAutoRestartTime == 0L) {
            return 0;
        }
        int hours = (int)((this.nextAutoRestartTime - System.currentTimeMillis()) / 3600000L);
        return Math.max(0, hours);
    }

    public boolean showWarning() {
        if (this.requestQueue.isEmpty() && (this.lastWarningTime == 0L || System.currentTimeMillis() - this.lastWarningTime >= 3600000L)) {
            this.lastWarningTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

