/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.Timer;
import utils.swing.images.ImageLoader;

public class TimerPanel
extends JLabel
implements NodeLinkStatusListener {
    private DecimalFormat df = new DecimalFormat("#######0");
    private long started;
    private long stopped = -1L;
    private boolean showZeroData = true;
    private boolean showIcon = true;
    private boolean summarise = false;
    private static final Object LOCK = new Object();
    private static final ArrayList<TimerPanel> timers = new ArrayList();
    private static final Timer repaintTimer = new Timer(1000, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = LOCK;
            synchronized (object) {
                for (TimerPanel timer : timers) {
                    try {
                        timer.update();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerPanel(boolean isPreloading) {
        this.reset();
        if (isPreloading) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!timers.contains(this)) {
                timers.add(this);
            }
            if (!repaintTimer.isRunning()) {
                repaintTimer.start();
            }
        }
    }

    public void showIcon(boolean showIcon) {
        this.showIcon = showIcon;
        this.updateIcon();
    }

    public void showZeroData(boolean b) {
        this.showZeroData = b;
    }

    public void summarise(boolean summarise) {
        this.summarise = summarise;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.repaint();
    }

    private String getElapsedString() {
        long elapsed = this.stopped == -1L ? System.currentTimeMillis() - this.started : this.stopped - this.started;
        long secs = elapsed % 60000L;
        secs /= 1000L;
        long mins = (elapsed /= 60000L) % 60L;
        long hours = elapsed / 60L;
        if (!this.summarise) {
            if (hours > 0L || this.showZeroData) {
                return this.df.format(hours) + "h " + this.df.format(mins) + "m " + this.df.format(secs) + "s   ";
            }
            if (mins > 0L) {
                return this.df.format(mins) + "m " + this.df.format(secs) + "s  ";
            }
            return this.df.format(secs) + "s  ";
        }
        if (hours > 0L) {
            return this.df.format(hours) + "h " + this.df.format(mins) + "m";
        }
        if (mins > 0L) {
            return this.df.format(mins) + "m";
        }
        return this.df.format(secs) + "s";
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isEnabled()) {
            this.setText(this.getElapsedString());
        }
        super.paintComponent(g);
    }

    public void reset() {
        this.started = System.currentTimeMillis();
        this.update();
    }

    public void start() {
        this.stopped = -1L;
        this.updateIcon();
    }

    private void updateIcon() {
        try {
            if (this.showIcon) {
                this.setIcon(ImageLoader.getImageIcon("images/svg/general/clock-simple.svg,16"));
            } else {
                this.setIcon(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        this.stopped = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.started;
    }

    public void update() {
        this.repaint();
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        this.stop();
        this.update();
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
    }

    @Override
    public void linkOK(NodeLink link) {
        this.start();
        this.update();
    }
}

